<?php

class BackupController extends Controller
{
    public $layout = '//layouts/ajax';
     
    public function accessRules()
    {
        return array(
            array('allow',
                'users'=>array('?'),
            )
        );
    }
    public function actionCreate(  )
	{
        $ids = array();
        if ( isset($_POST['ids']) ){
            $ids = json_decode( $_POST['ids'], true );
        } else if ( isset($_GET['ids']) ){
            $ids = json_decode( $_GET['ids'] );
        } else if ( isset($_GET['id']) ){
            $ids = array( $_GET['id'] );
        } else if ( isset($_GET['type']) ){
            $ids = array();
            $resources = Resource::loadAll( $_GET['type'] );
            foreach( $resources as $resource ){
                $ids[] = $resource->id;
            }
        } 
        if ( empty( $ids ) ) {
            $ids = array();
            $medias = Resource::loadAll( 'media' );
            foreach( $medias as $media ){
                $ids[] = $media->id;
            }
            $playouts = Resource::loadAll( 'playout' );
            foreach( $playouts as $playout ){
                $ids[] = $playout->id;
            }
            $playlists = Resource::loadAll( 'playlist' );
            foreach( $playlists as $playlist ){
                $ids[] = $playlist->id;
            }
        }
        $resourceBackup = new ResourceBackup;   
        $resourceBackup->ids = $ids;
        $zip = $resourceBackup->backup( );
        
        if ( $zip !== false ){      
            if ( Yii::app()->request->isAjaxRequest  ){
                var_dump( $resourceBackup->actions );
            } else {
                $model = null;
                if ( count($ids) == 1 ){
                    $model = Resource::model()->findByPk( $ids[0] );
                }
                if ( $model ){
                    $name = $model->name;
                } else {
                    $name = $this->serial;
                }
                $fp = fopen( $zip, 'rb');
                header("Content-type: application/x-spx-backup");
                header('Content-Disposition: attachment; filename="'.$name.'.bck"');
                while(!feof($fp))
                {
                    echo fread($fp, 4096*1024);
                    ob_flush();
                    flush();    
                }
                fclose($fp);                
                unlink( $zip );
            }            
        } else {
            Yii::log("Create backup errors: ".print_r($resourceBackup->errors, true), 'warning', 'spx.media');
            throw new CHttpException(404, I18N::t("Cannot create backup") );            
        }        
	}
    public function actionRestore(  )
	{
        $resourceBackup = new ResourceBackup;   
        
        if ( isset( $_FILES['ResourceBackup'] ) ){            
            $resourceBackup->file = CUploadedFile::getInstance($resourceBackup,'file');
            if ( $resourceBackup->validate() ) {
                $resourceBackup->restore( );
            }
		} else if ( isset( $_POST['filepath'] ) ){
            $resourceBackup->filepath = $_POST['filepath'];
            $resourceBackup->restore( );            
        }
        if ( $resourceBackup->hasErrors() ){
            var_dump( $resourceBackup->errors );      
        }
        var_dump( $resourceBackup->actions );
	}
}