<?php

yii::import('application.modules.controlcenter.controllers.actions.SystemAction');
yii::import('application.modules.controlcenter.controllers.actions.DisplayAction');

class MainController extends ControlCenterController
{
    public $defaultAction = 'summary';
    public function accessRules()
    {
        $rules = array(
            array('allow',
                'actions' => array( 'index', 'summary', 'logs' ),
                'roles'=>array('viewLogs'),
            ),
        );
        
        return array_merge( $rules, parent::accessRules() ); ;
    }
    public function actions()
    {
        $base = 'application.modules.controlcenter.controllers.actions.';
        return array(
            'index'=> $base.'SummaryAction',
            'summary'=> $base.'SummaryAction',
            'system'=> $base.'SystemAction',
            'display'=> $base.'DisplayAction',
            'network'=> $base.'NetworkAction',
            'content'=> $base.'ContentAction',
            'applications'=> $base.'ApplicationsAction',
            'peripherals'=> $base.'PeripheralsAction',
            'operations'=> $base.'OperationsAction',
            'logs'=> $base.'LogsAction',
        );
    }
    
    public function actionPullmodeScheduleGet()
	{
        $pullModeConfig = new PullModeConfig;
        $pullModeConfig->download();                
    }
    public function actionPullmodeScheduleSet()
	{
        $this->ajaxOnly(); 
        $errors = array();
        
        $pullModeConfig = new PullModeConfig;
        $pullModeConfig->load();
        $pullModeConfig->setSelectMode( PullModeConfig::PULL_FILE );        
        //$pullModeConfig->setAttributes( $_POST['PullModeConfig'] );
        if ( $pullModeConfig->validate() ){
            $pullModeConfig->save();
            Tools::addMessage('Schedule file uploaded');
        }
        
        $this->render('/layouts/ajax', array(
            'errors' => $this->updateErrors( $pullModeConfig, $errors )
        ));
    }
    public function actionStreamingDownloadXML()
    {
        header('Content-type: text/xml');
        header('Content-Disposition: attachment; filename="streaming.xml"');
        //if (($XML = @file_get_contents(Streaming::XML_FILE))) {
        //    echo $XML;
        //} else {
        //    echo '';
        //}
        $streaming = new Streaming;
        $streaming->load();
        echo $streaming->getXML();
    }
    public function actionAbout()
	{
        $this->render( 'about' );
    }    
    
}