<?php
class BonjourConfig extends CFormModel {
	
    CONST FILE="/etc/default/spxmanage-mdns";
    CONST FILE_AVAHI="/etc/default/avahi-daemon";
    
    public $enabledAvahi = 1;
    public $enabledDiscovery = 1;
    
    public function rules() {
		$res = array(
            array( "enabledDiscovery", 'safe' ),
            array( "enabledAvahi", 'safe' ),
    	);
        return $res;
	}

    public function attributeLabels()
	{
		return array(
            'enabledAvahi'=>'Enable Bonjour service discovery and name resolution',
            'enabledDiscovery'=>'Enable player discovery via Bonjour'
		);
	}

    public function load() {
        $this->enabledDiscovery = $this->loadStatusDiscovery();
        $this->enabledAvahi = $this->loadStatusAvahi();               
    }
    
    public function save() {
        
        $this->enabledAvahi = intval( $this->enabledAvahi );
        $wasEnabledAvahi = $this->loadStatusAvahi();
        
        $this->enabledDiscovery = intval( $this->enabledDiscovery );
        $wasEnabledDiscovery = $this->loadStatusDiscovery( $conf );
        
        if ( $wasEnabledAvahi != $this->enabledAvahi) {
           if ( $this->enabledAvahi ){
                unlink( self::FILE_AVAHI );
           } else {
                Tools::save_file( self::FILE_AVAHI, "AVAHI_DAEMON_START=0\n" );        
           }
           Tools::addReason( "Bonjour " . ($this->enabledAvahi?"enabled":"disabled") );
        }
        
        if ( $wasEnabledDiscovery != $this->enabledDiscovery) {
            $val =  $this->enabledDiscovery ? "yes": "no";
            if ($conf) {
                Tools::save_file( self::FILE, preg_replace("/ENABLE_MDNS_SERVICE_PUBLISH=.*/","ENABLE_MDNS_SERVICE_PUBLISH=$val", $conf) );
            } else {
                Tools::save_file( self::FILE, "ENABLE_MDNS_SERVICE_PUBLISH=$val\n" );
            }
            Tools::addReason( "player discovery " . ($this->enabledDiscovery?"enabled":"disabled") );
        }
        
        if ( $wasEnabledDiscovery != $this->enabledDiscovery || $wasEnabledAvahi != $this->enabledAvahi ) {
            $mdnsconf = "ENABLE_MDNS_SERVICE_PUBLISH=". ($this->enabledDiscovery ? "yes": "no") ."\n";
            $mdnsconf .= "AVAHI_DAEMON_START=". ($this->enabledAvahi ? "1": "0") ."\n";

            if ( !Tools::setSafeModeData("discovery-mdns", $mdnsconf, FALSE) ){
                $this->addError('file','Failed saving discovery-mdns configuration for recovery console, please try again.');
                return false;
            }
        }
    }

    private function loadStatusDiscovery(&$conf = null) {
       if (($conf = @file_get_contents(self::FILE)) && preg_match("/ENABLE_MDNS_SERVICE_PUBLISH=(.*)/", $conf, $matches)) {
            if ( $matches[1] == 'yes' ){
                return 1;
            }
        } 
        return 0;
    }

    private function loadStatusAvahi() {
        if (($conf = @file_get_contents(self::FILE_AVAHI)) && preg_match("/AVAHI_DAEMON_START=(.*)/", $conf, $matches)) {
            if ( $matches[1] == '0' ){
                return 0;
            }
        } 
        return 1;
    }
}
