<?php

/*
 * This script is run on package update, from a boot script on the
 * first reboot after an update, *before* the HTTP service is started.
 * Note that stdout and stderr go to the console, not a browser. 
 *
 * Put here any complex operations that are required after a package
 * update. As much as possible the operations should only be performed
 * if necessary, so that minimal system modification is done.
 *
 * The operations in here should also be idempotent, running them more
 * than once should have no ill effects, as this may happen under some
 * circusmtances after an update (think power loss at just the wrong
 * moment).
 * 
 * Conditions to run the script:
 * A) Following files do not exists
 *  /var/lib/spxmanage/ui/ui.db
 *  /srv/raperca/interface/protected/assets.db
 * B) Following file exists:
 *  /var/spool/spxmanage/run-update-jobs
 * C) The file defined in the SPX_RESTORE_CONFIG environment variable exists
 * 
 */

chdir(__DIR__ . '/../..'); // many includes are relative to the root app dir
include_once( __DIR__.'/runYiic.php' );
include_once( __DIR__.'/BrandingInfo.php' );
include_once( __DIR__.'/MaintenanceJobs.php' ); // a general requirement of many classes
$script = basename( __FILE__ );
// make sure all the errors are also pushed to stderr
ini_set('display_errors', 'stderr');

syslog(LOG_NOTICE, 'running migration for main db' );
runYiic( array( 'yiic.php', 'migrate', 'up', '--interactive=0' ), $script, true);

$branding = new BrandingInfo;
if ( $branding->hasRight("CreateSchedule")) {
  syslog(LOG_NOTICE, 'running migration for assets db' );
  runYiic( array( 'yiic.php', 'migrate', 'up', '--interactive=0', '--migrationPath=application.migrations_assets', '--connectionID=dbassets' ), $script, false);

  syslog(LOG_NOTICE, 'updating assets' );
  runYiic( array( 'yiic.php', 'assets', 'update' ), $script, false);
}

// Restoring a configuration backup must be done after all migrations have been applied,
// otherwise some migrations may override some configurations.
$configFile = getenv('SPX_RESTORE_CONFIG');
if ( ! empty( $configFile ) && file_exists( $configFile ) ) {
	syslog(LOG_NOTICE, "restoring configuration from '$configFile'" );
	runYiic( array( 'yiic.php', 'config', 'restore', '--rebootDelay=-1', $configFile ), $script, true);
}
