<?php

class m141112_000000_resource extends CDbMigration
{
	var $folders = array( 'media', 'playlist', 'playout', 'template', 'apps', 'schedule', 'external');

	// Use safeUp/safeDown to do migration with transaction
	public function up()
	{
        $this->execute( 'PRAGMA encoding = "UTF-8";' );
        $this->execute( 'PRAGMA journal_mode=WAL;');
        
        $transaction=$this->getDbConnection()->beginTransaction();
        try {
            $this->createTable('Resource', array(
                'id'            => 'INTEGER         NOT NULL PRIMARY KEY AUTOINCREMENT',
                'name'          => 'VARCHAR(64) 	NOT NULL',
                'type'          => 'VARCHAR(128)    NOT NULL',
                'keywordsStr'   => 'VARCHAR(256)    DEFAULT NULL',
                'modified'      => 'DATETIME        NOT NULL',
                'uuid'          => 'VARCHAR(36)     DEFAULT NULL',
                'version'       => 'VARCHAR(10)     DEFAULT NULL'
            ));

            $this->createTable('Media', array(
                'id'            => 'INTEGER         NOT NULL    PRIMARY KEY',
                'fileName'      => 'VARCHAR(64) 	NOT NULL',
                'mimeType'      => 'VARCHAR(64) 	NOT NULL',
                'dur'           => 'DOUBLE                      DEFAULT NULL',
                'dimension'     => 'VARCHAR(10)                 DEFAULT NULL',
                'aspectRatio'   => 'VARCHAR(5)                  DEFAULT NULL',
                'hidden'        => 'TINYINT                     DEFAULT 0',
                "foreign key ('id') references Resource ('id') on delete cascade on update cascade"
            ));        

            $this->createTable('Owner', array(
                'id'            => 'INTEGER 	NOT NULL PRIMARY KEY AUTOINCREMENT',
                'parentId'      => 'INTEGER 	NOT NULL',
                'childId'       => 'INTEGER 	NOT NULL',
                "foreign key ('parentId') references Resource ('id') on delete cascade on update cascade",
                "foreign key ('childId') references Resource ('id') on delete cascade on update cascade"
            ));

            // create the folders

            if ( !file_exists( GlobalSettings::$fileBase ) )
                mkdir( GlobalSettings::$fileBase );
            foreach ($this->folders as $folder ){
                $dest = GlobalSettings::$fileBase.$folder."/";            
                if ( !file_exists( $dest ) )
                    mkdir( $dest );
                else
                    GlobalSettings::rrmdir( $dest, false );
            }
        } catch(Exception $e){
			$transaction->rollback();
			return false;
		}
        $transaction->commit();
        return true;
	}
    public function safeDown()
	{        
        $this->dropTable('Resource');
        $this->dropTable('Media');
        $this->dropTable('Owner'); 
        
        foreach ($this->folders as $folder ){
            $dest = GlobalSettings::$fileBase.$folder."/";            
            GlobalSettings::rrmdir( $dest, false );
        }          
         
	}

}