<?php
include_once 'protected/utils/MaintenanceJobs.php';

class WifiNetwork {
    public $name;
    public $security;
    public $signal;
    public $connected;
}

class WifiInfo extends CFormModel {
    public function load() {
        try {
            MaintenanceJobs::scanWifi();
            $info = MaintenanceJobs::getWifiInfo();
        } catch (Exception $e) {
            syslog(LOG_ERR, $e->getMessage());
            return;
        }
        foreach ($info['knownNetworks'] as $knownNetworkInfo) {
            $network = new WifiNetwork();
            $network->name = $knownNetworkInfo['name'];
            $network->security = self::security($knownNetworkInfo['type']);
            if ($networkInfo = self::networkInfo(
                $info['networks'], $knownNetworkInfo['name'])) {
                $network->signal = self::signal($networkInfo['signal']);
                $network->connected = $networkInfo['connected'];
            } else {
                $network->signal = 'Not seen';
                $network->connected = false;
            }
            $this->networks[] = $network;
        }
    }

    private static function security($type) {
        switch ($type) {
            case 'psk':
                return 'Personal';
            case '8021x':
                return 'Enterprise';
            default:
                return ucfirst($type);
        }
    }

    private static function networkInfo($networks, $name) {
        foreach ($networks as $network) {
            if ($network['name'] == $name) {
                return $network;
            }
        }
        return null;
    }

    private static function signal($dbm) {
        $dbm = intdiv($dbm, 100);
        if ($dbm >= -60) {
            $signal = 'Excellent';
        } else if ($dbm >= -67) {
            $signal = 'Good';
        } else if ($dbm >= -75) {
            $signal = 'Fair';
        } else {
            $signal = 'Weak';
        }
        return $signal . ' (' . $dbm . ' dBm)';
    }
    
    public $networks = array();
}
