<?php

$cockpitHost = "https://cockpit.spinetix.com";
$cockpitUri = "/users/remote_login";
$cockpitNewPlayer = "/users/concentrator_url.json";

/* @var $this ConfigController */
$cockpitEnabled = $pullModeConfig->cockpitUri != null;
$box = $this->beginWidget('SimpleForm', array( 
    'title' => "Cockpit",
    'button' => array( $cockpitEnabled?"Stop Monitoring":"Monitor by Cockpit", array( "id"=> "CockpitMonitor")),
    'id' => 'Cockpit',
    'defaultClass' => "btn btn-default",
    'action' => array ( 'post' => array() )
) );
    if ( $cockpitEnabled ) {
        echo CHtml::activeHiddenField($pullModeConfig, "cockpitUri", array('value'=> ""));
        echo BsHtml::alert(
                BsHtml::ALERT_COLOR_INFO, 
                'This player is monitored by '. BsHtml::alertLink('Cockpit', $cockpitHost, array( 'target' => '_blank' ))
        );
        $this->widget( 'DialogButton' , array(
            'label' => 'Open in Cockpit',
            'link' => $cockpitHost . '/players/'.$this->serviceSerial ."/search" ,
            'options' => array( 'target' => '_blank' ),
            'content' => false
        ));        
    } else {
        $pullModeConfig->cockpitUri = $concentrator_url;
        $txt = CHtml::tag("p", array(), "This player is not monitored by " . CHtml::link("Cockpit", $cockpitHost."/", array( "target"=>"_blank") ) ."." );
        if ( empty($pullModeConfig->cockpitUri) ){
            $txt .= CHtml::openTag("div", array('id' => 'CockpitLogin') );        
            $txt .= CHtml::tag("p", array(), "To monitor this player you need to login to Cockpit first. " . 
                CHtml::link("Click here to go to the Cockpit login screen.", 
                    $cockpitHost.$cockpitUri."?href=". urlencode(yii::app()->request->getHostInfo() . CHtml::normalizeUrl(array( "/controlcenter/main/system" ))."?id=Cockpit")
                ). " ".
                "You will be redirected to this page once logged in.");        
            $txt .= CHtml::closeTag('div');
        }   
        echo BsHtml::alert(
                BsHtml::ALERT_COLOR_INFO, 
                $txt,
                array( 'closeText' => false )
        );
        echo CHtml::activeHiddenField($pullModeConfig, "cockpitUri", array( 'id' => 'CockpitUri' ));        
    }
$this->endWidget();
if ( empty($pullModeConfig->cockpitUri)) {
?>
<script type="text/javascript">//<![CDATA[
$(function(){
    $('#CockpitLogin').hide();
    // $.get( <?php echo CJavaScript::encode( $cockpitHost.$cockpitNewPlayer);?> )
    $('#CockpitMonitor').hide();
    $.ajax({url: <?php echo CJavaScript::encode( $cockpitHost.$cockpitNewPlayer);?>, 
        type: "GET",
        crossDomain: true, 
        xhrFields: { withCredentials: true } })      
     .done(function( data, textStatus, jqXHR ){         
         if ( data.url ){
            $('#CockpitUri').val( data.url );
            $('#CockpitMonitor').show();
         }
     })
     .fail(function( jqXHR, textStatus, errorThrown ){         
         //if ( jqXHR.status == 401 ){             
             $('#CockpitLogin').show();
         //}
     });
});
//]]></script>
<?php 
}
?>
