<?php
yii::import('system.cli.commands.MessageCommand', true);
    
class TranslateCommand extends MessageCommand {
    
    protected $lineNumbers = array();
    
    protected function appMessage( $appFolder ){
        $options=array();
		$options['fileTypes']= array( "svg" );
		//$options['exclude']=$exclude;
        $files=CFileHelper::findFiles(realpath($appFolder),$options);
        $messages=array();
        foreach($files as $file){
			$messages=array_merge_recursive($messages,$this->extractAppsMessages($file, count($files) > 2 ) );
        }
        
        $options=array();
		$options['fileTypes']= array( "json" );
		//$options['exclude']=$exclude;
        $files=CFileHelper::findFiles(realpath($appFolder),$options);
        foreach($files as $file){
			$messages=array_merge_recursive($messages,$this->extractAppsName($file));
        }
        $messages = array( "app" => $messages );
        
        $options=array();
		$options['fileTypes']= array( "html", "js" );
		//$options['exclude']=$exclude;
        $files=CFileHelper::findFiles(realpath($appFolder),$options);
        foreach($files as $file){
			$messages=array_merge_recursive($messages,$this->extractMessages($file, array( 'spxapi.t', 'root.t') ));
        }
        return $messages;
    }
    protected function loadRef( $fileName, $context ){
        $file = new CGettextPoFile();
        
        $alt = dirname( $fileName )."/".$context.".php";
        
        if ( is_file($alt) ){
            echo "Using php...";
            $fuzzy = require($alt);
            if ( $fuzzy === null ){
                $fuzzy = array();
            }
        } else {
            $fuzzy = array();
        }
		if(is_file($fileName)) {
			$translated = $file->load( $fileName, $context );
        } else {
            $translated = array( );
        }
        foreach ( $fuzzy as $message=>$translation ){
            if ( empty($translation) ){
                continue;
            }
            if ( !isset( $translated[$message]) || empty($translated[$message]) ){
                if(substr($translation,0,2)==='@@' && substr($translation,-2)==='@@'){
                    continue;
                }
                if(substr($translation,0,2)==='$$' && substr($translation,-2)==='$$'){
                    $translated[$message] = $translation;
                } else {
                    $translated[$message] = "$$".$translation."$$";
                }
            }
        }
        return $translated;
    }
    protected function merge( $messages, $translated, $removeOld = false, $forceSave = false) {
        $messages=array_values(array_unique($messages));
        
        sort($messages);
        ksort($translated);
        if(!$forceSave && array_keys($translated)==$messages )
        {
            echo "nothing new...skipped.\n";
            return false;
        }
        $merged=array();
        $untranslated=array();
        foreach($messages as $message)
        {
            if(array_key_exists($message,$translated) ){
                if (is_array( $translated[$message] )){
                    $realMsg = "";
                    foreach( $translated[$message] as $msg ){
                        if ( empty($realMsg) && !empty($msg) ){
                            if( substr($msg,0,2)!=='$$' || substr($msg,-2)!=='$$'){
                                $realMsg = $msg;
                            }
                        } else if ( !empty($realMsg) && !empty($msg) && $realMsg!=$msg ){
                            if( substr($msg,0,2)!=='$$' || substr($msg,-2)!=='$$'){
                                echo "\nDifferent translation found for '$message'\nused: $realMsg\nalt: $msg";
                            }                            
                        }
                    }  
                    if ( !empty($realMsg) ){
                        $merged[$message]=$realMsg;
                    } else {
                        $untranslated[]=$message;
                    }
                } else if ( strlen($translated[$message])>0) {
                    $merged[$message]=$translated[$message];
                } else {
                    $untranslated[]=$message;
                }                
            }                
            else
                $untranslated[]=$message;
        }
        ksort($merged);
        sort($untranslated);
        $todo=array();
        foreach($untranslated as $message)
            $todo[$message]='';
        ksort($translated);
        foreach($translated as $message=>$translation)
        {
            if(!isset($merged[$message]) && !isset($todo[$message]) && !$removeOld)
            {
                if ( is_array($translation) ){
                    $realMsg = "";
                    foreach( $translation as $msg ){
                        if ( empty($realMsg) && !empty($msg) ){
                            $realMsg = $msg;
                        } 
                    } 
                    $translation = $realMsg;
                }
                if(substr($translation,0,2)==='@@' && substr($translation,-2)==='@@')
                    $todo[$message]=$translation;
                else
                    $todo[$message]='@@'.$translation.'@@';
            }
        }
        $merged=array_merge($todo,$merged);
        ksort($merged);        
        echo "translation merged.\n";   
        
        return $merged;
    }
    protected function saveRef( $merged, $fileName, $context, $savePHPFile = false, $saveUnused = false  ){
        
        $date = date( DATE_ISO8601 );
        $fileHeader=<<<EOD
# Translation file HMP/DiVA interface.
# Copyright (C) 2015 Spinetix SA
#
msgid ""
msgstr ""
"Project-Id-Version: HMP/DiVA interface\\n"
"Report-Msgid-Bugs-To: support@spinetix.com\\n"
"PO-Revision-Date: $date\\n"
"Last-Translator: Julien Reichel <jr@spinetix.com>\\n"
"Language-Team: SpinetiX <jr@spinetix.com>\\n"
"MIME-Version: 1.0\\n"
"Content-Type: text/plain; charset=UTF-8\\n"
"Content-Transfer-Encoding: 8bit\\n"


EOD;
        
        $content='';
		foreach($merged as $id=>$message)
		{
            if ( substr($message,0,2)==='@@' && substr($message,-2)==='@@' ){
                $message = substr($message, 2, -2 );
                if ( $saveUnused ){
                    $content.='#~ msgid "'.$this->encodePoText($id)."\"\n";
                    $content.='#~ msgstr "'.$this->encodePoText($message)."\"\n\n";
                }
            } else {
                if ( $saveUnused ){
                    if ( isset( $this->lineNumbers[$id]) ){
                        $content.= "#: ".implode("\n#: ", $this->lineNumbers[$id] )."\n";
                    }
                }
                if ( substr($message,0,2)==='$$' && substr($message,-2)==='$$' ){
                    $message = substr($message, 2, -2 );
                    $content.= "#, fuzzy\n";
                }
                $content.='msgctxt "'.$context."\"\n";
                $content.='msgid "'.$this->encodePoText($id)."\"\n";
                $content.='msgstr "'.$this->encodePoText($message)."\"\n\n";
            }
		}
        file_put_contents($fileName, $fileHeader . $content);
        if ( $savePHPFile ){
            $alt = dirname( $fileName )."/".$context.".php";
            $array=str_replace("\r",'',var_export($merged,true));
            file_put_contents($alt,<<<EOD
<?php
return $array;

EOD
            );
        }
    }

    public function run($args)
	{
        if(!isset($args[0]))
			$this->usageError('the configuration file is not specified.');
		if(!is_file($args[0]))
			$this->usageError("the configuration file {$args[0]} does not exist.");

        $config = require( $args[0] );
		$translator='Yii::t';
		extract($config);

		if(!isset($sourcePath,$messagePath,$languages))
			$this->usageError('The configuration file must specify "sourcePath", "messagePath" and "languages".');
		if(!is_dir($sourcePath))
			$this->usageError("The source path $sourcePath is not a valid directory.");
		if(!is_dir($messagePath))
			$this->usageError("The message path $messagePath is not a valid directory.");
		if(empty($languages))
			$this->usageError("Languages cannot be empty.");

		if(!isset($overwrite))
			$overwrite = false;

		if(!isset($removeOld))
			$removeOld = false;

		if(!isset($sort))
			$sort = false;

		if(!isset($fileHeader))
			$fileHeader = true;
        
        $messages = array();        
        $context = "app";
        $applicationMesages = array();
        
        // Step 1: load the reference
        $translated = array();
        foreach($languages as $language)
		{
            $dir=$messagePath.DIRECTORY_SEPARATOR.$language;            
            $translated[$language] = $this->loadRef( $dir.DIRECTORY_SEPARATOR.$language.'.po', $context );
        }        
        // Step 2: process each app, find the string to translate and see if we already have a translation for it
        $appFolder = dirname(__FILE__)."/../../../apps";
        $folder=opendir($appFolder);
        while(($file=readdir($folder))!==false) {
            if(substr($file,0,1)==='.'){
				continue;
            }
            $appsMesages = $this->appMessage( $appFolder.DIRECTORY_SEPARATOR.$file );
            $messages = array_merge_recursive($messages, $appsMesages);
            $apps = $appFolder.DIRECTORY_SEPARATOR.$file;
            $dir = $apps.DIRECTORY_SEPARATOR."messages";
            $dbFile = $apps.DIRECTORY_SEPARATOR."db.json";
            $db = json_decode( file_get_contents( $dbFile ), true);
            if ( $db['type'] == 'apps' ){   
                if(!is_dir($dir))
                    @mkdir($dir); 
                $updateApps = false;
                foreach($languages as $language){      
                    // load the source (if needed)
                    $translated[$language] = array_merge_recursive($translated[$language], $this->loadRef( $dir.DIRECTORY_SEPARATOR.$language.'.po', $context ));

                    $merged = $this->merge( $appsMesages[$context], $translated[$language] );  
                    if ( $merged ){
                        $this->saveRef( $merged, $dir.DIRECTORY_SEPARATOR.$language.'.po', $context); 
                        $updateApps = true;                    
                    }
                    if ( isset($db['name']) ){
                        $applicationMesages['app'][] = $db['name'];
                    }
                }              
                if ( $updateApps ){
                    $db['version'] = (string)(floatval( $db['version'] ) + 0.1);
                    file_put_contents($dbFile, json_encode($db,JSON_PRETTY_PRINT));
                }
            } else {
                $applicationMesages = array_merge_recursive($applicationMesages, $appsMesages ); 
            }            
        }
        
        // Step 3: process the application itself
		$options=array();
		if(isset($fileTypes))
			$options['fileTypes']=$fileTypes;
		if(isset($exclude))
			$options['exclude']=$exclude;
		$files=CFileHelper::findFiles(realpath($sourcePath),$options);
		
        
		foreach($files as $file){
			$applicationMesages = array_merge_recursive($applicationMesages,$this->extractMessages($file,$translator));
        }
        $messages = array_merge_recursive($messages, $applicationMesages);
        
		foreach($languages as $language)
		{
			$dir=$messagePath.DIRECTORY_SEPARATOR.$language;
			if(!is_dir($dir))
				@mkdir($dir);            
            $translated[$language] = array_merge_recursive($translated[$language], $this->loadRef( $dir.DIRECTORY_SEPARATOR.$context.'.po', $context ));               
            
            $merged = $this->merge( $applicationMesages[$context], $translated[$language] );
            if ( $merged ){
                $this->saveRef( $merged, $dir.DIRECTORY_SEPARATOR.$context.'.po', $context);
            }
            
            // save the reference (not used by the apps, but used by the translators
            $merged = $this->merge( $messages[$context], $translated[$language], true, true );            
            if ( $merged ){
                $this->saveRef( $merged, $dir.DIRECTORY_SEPARATOR.$language.'.po', $context, true, true);            
            }
		}
    }
    protected function getFirstText( $dom, $tag ){
        $titles = $dom->getElementsByTagName( $tag );
        foreach( $titles as $title ) {
            if ( !empty($title->textContent) ) {
                $first = substr( trim($title->textContent), 0, 1 );
                if ( $first!="{" && $first!="[" && $first!="#" ) {
                    return trim($title->textContent);                    
                }
            }
        }
        return "";
    }
    public function getWidgetOptions( $dom, $base ) {
        
        $messages=array();
        
        // open the widgetfile
        $params = $dom->getElementsByTagNameNS("http://www.spinetix.com/namespace/1.0/spx", "properties");        
        $entrys = array();
        foreach( $params as $param ) {            
			for ( $item=$param->firstChild; $item!=null; $item=$item->nextSibling ) {
				if ( $item->nodeType==XML_ELEMENT_NODE ) {
                    if ( $item->localName=='group' ) {
                        $base = $item->getAttribute("name");
                        for ( $item2=$item->firstChild; $item2!=null; $item2=$item2->nextSibling ) {
                            if ( $item2->nodeType==XML_ELEMENT_NODE ) {
                                $name = $item2->getAttribute("name");
                                if ( $name == 'Visible' ){                                    
                                    $item2->setAttribute("name", $base);
                                } 
                                $entrys[ $base .":". $name] = $item2;
                            }
                        }
                    } else {
                        $name = $item->getAttribute("name");
                        $entrys[ $name ] = $item;
                    }
				}
			}
        }
        foreach ($entrys as $name => $entry) {
            if ( substr($entry->localName, 0, 4) == "json" )
                $type = substr($entry->localName, 5);
            else
                $type = $entry->localName;
            
            if ( $type==='data' )
                $type = 'string';
            if ( $type==='integer' )
                $type = 'number';
            if ( !$entry->getAttribute("query") )
                continue;            
            if ( !in_array($type, array('string', 'text', 'number', 'boolean', 'choice', 'color') ) ) 
                continue;
            
            $name = $entry->getAttribute("name");
            if ( !empty($name) ){
                $messages[] = $name;
                $this->lineNumbers[$name][] = $base;
            }
            /*
            $desc = $entry->getAttribute("desc");
            if ( !empty($desc) ){
                $messages[] = $desc;
                $this->lineNumbers[$desc][] = $base;
            }             
            */
            if ( $type==='choice' ){
                if ( !$entry->hasAttribute("choice") ){
                    $i = 1 ;
                    if ( $entry->hasAttribute("choice-1") )
                        $add = false;
                    else 
                        $add = true;
                    $idx = ($i<10&&$add)?"0".$i:$i;

                    while ( $entry->hasAttribute("choice-".$idx) ){
                        $val = array( "value" => $entry->getAttribute( "choice-".$idx ) );
                        if ( $entry->hasAttribute("name-".$idx) ){
                            $name = $entry->getAttribute( "name-".$idx );
                            if ( !empty($name) ){
                                $messages[] = $name;
                                $this->lineNumbers[$name][] = $base;
                            }
                        } 
                        $i++;
                        $idx = ($i<10&&$add)?"0".$i:$i;
                    }
                }
                
            }
        }
        return $messages;
    }
    
    protected function extractAppsMessages( $fileName, $useTitle = false )
	{
        echo "Extracting messages from apps $fileName...\n";
        $st = strpos($fileName,"\\apps\\")+6;
        $base = strtr( substr($fileName, $st ), "\\", "/");
        $messages=array();
        
        $cnt = file_get_contents( $fileName );
        $dom = new DOMDocument;
        if ( @$dom->loadXML( $cnt )===false ){
            return $messages;
        }
        $svg = $dom->documentElement;
        if ( !$svg ) {
            return $messages;
        }
        
        if ( $useTitle ) {   
            $name = $this->getFirstText( $dom, "title" );
            if ( !empty($name) ){
                $this->lineNumbers[$name][] = $base;
                $messages[] = $name;
            }
        }
        /*
        $desc = $this->getFirstText( $dom, "desc" );
        if ( !empty($desc) ){
            $this->lineNumbers[$name][] = $base;
            $messages[] = $desc;
        }
        */      
        return array_merge_recursive($messages,$this->getWidgetOptions( $dom, $base ));
    }
    protected function extractAppsName( $fileName )
	{
        echo "Extracting messages from apps $fileName...\n";
        $st = strpos($fileName,"\\apps\\")+6;
        $base = strtr( substr($fileName, $st, -8 ), "\\", "/");
        $messages=array();
        
        $apps = file_get_contents( $fileName );
        $config = json_decode( $apps, true );
        if ( !empty($config['name']) ){
            $this->lineNumbers[$config['name']][] = $base;
            $messages[] = $config['name'];
        }        
        if ( !empty($config['desc']) ){
            $this->lineNumbers[$config['desc']][] = $base;
            $messages[] = $config['desc'];
        }
        return $messages;
    }
    protected function extractMessages($fileName,$translator)
	{
		echo "Extracting messages from $fileName...\n";
		$lines = file ($fileName);
		$messages=array();
		if(!is_array($translator))
			$translator=array($translator);

		foreach ($translator as $currentTranslator)
		{
            foreach ( $lines as $idx => $subject ){
                $n = preg_match_all('/\b'.$currentTranslator.'\s*\((?:\s*(\'[\w.\/]*?(?<!\.)\'|"[\w.]*?(?<!\.)")\s*,)?\s*(\'.*?(?<!\\\\)\'|".*?(?<!\\\\)")\s*[,\)]/s',$subject,$matches,PREG_SET_ORDER);

                for($i=0;$i<$n;++$i)
                {
                    if( empty($matches[$i][1]) ){
                        $category = "app";
                    } else if(($pos=strpos($matches[$i][1],'.'))!==false)
                        $category=substr($matches[$i][1],$pos+1,-1);
                    else
                        $category=substr($matches[$i][1],1,-1);
                    $message=$matches[$i][2];
                    $val = eval("return $message;");  // use eval to eliminate quote escape
                    $messages[$category][] = $val;
                    $this->lineNumbers[$val][] = basename($fileName) .":". ($idx+1);
                }
            }
		}
		return $messages;
	}
    
	protected function encodePoText($string)
	{
		return str_replace(
			array('"',"\n","\t","\r"),
			array('\\"',"\\n",'\\t','\\r'),
			$string
		);
	}    
}