<?php
class ActionButton extends CWidget
{
    var $label;
    var $options;
    var $action;
    var $defaultClass = "btn";
    var $type = 'default';
    var $block = false;
    var $ko = false;
    var $link = false;
    var $post = false;
    var $file = false;
    var $args = false;
    var $script = false;
    protected function registerClientScript()
    {        
        $cs=Yii::app()->clientScript;
        $cs->registerScript( 
            'yiiErrors', "var yiiErrors = [];", CClientScript::POS_BEGIN
        );        
        $csrfTokenName = Yii::app()->request->csrfTokenName;
        $csrfToken = CJavaScript::quote(Yii::app()->request->csrfToken);
        
        $script = <<<JSSCRIPT
ko.bindingHandlers.submitFileUpload = {
    init: function (element, valueAccessor, allBindings ) {
        var button = $(element).parent();
        var args = {} ;
        if ( typeof valueAccessor() === 'string' ){
            args.url = valueAccessor();
        } else {
            $.extend( args, valueAccessor() );
        }
        if ( args.done ) {
            args.inputDone = args.done;
        }
        if ( args.done ) {
            args.inputDone = args.done;
        }
        if ( !args.formData ) {
            args.formData = {};
        }
        args.formData['$csrfTokenName'] = '$csrfToken';
        
        args.done = function (e, data) {
            button.button('reset');
            setTimeout( function() { 
                // muste re-apply the fileupload, as the loading/reset destry the element            
                button.children('input').fileupload( args );
            }, 0 );
            yiiModel.updatePlayerResponse( data.result );
            if ( args.inputDone ){
                args.inputDone( e, data );                
            }
        };
        if ( args.fail ) {
            args.inputFail = args.fail;
        }
        args.fail = function (e, data) {
            button.button('reset');
            // muste re-apply the fileupload, as the loading/reset destry the element            
            setTimeout( function() { 
                // muste re-apply the fileupload, as the loading/reset destry the element            
                button.children('input').fileupload( args );
            }, 0 );
            var r;
            try {
                r = JSON.parse( data.jqXHR.responseText );
            } catch ( e ) {      
                r = { errors : [ "Some error occured: " + data.errorThrown ] };
            }            
            yiiModel.updatePlayerResponse( r );
            if ( args.inputFail ){
                args.inputFail( e, data );                
            }            
        };
        if ( args.submit ) {
            args.inputSubmit = args.submit;
        }
        args.submit = function (e, data) {
            button.button('loading');
            if ( args.inputSubmit ){
                args.inputSubmit( e, data );                
            }
        };
        $(element).fileupload( args );
    }
};
JSSCRIPT;
        $cs->registerScript( 
            'fileUploadBinding', $script, CClientScript::POS_BEGIN
        );        
    }
    
    public function run()
    {
        $label = $this->label;
        $options = $this->options;
        $this->controller->addClass( $options, $this->defaultClass );
        $this->controller->addClass( $options, "btn-".$this->type );
        if ( $this->block ){
            $this->controller->addClass( $options, "btn-block" );
        }
        
        if ( $this->ko ){
            $ko = 'click: '.$this->ko;
            $this->controller->addDatabind( $options, $ko );                
            if ( $this->link )
                echo CHtml::link($label,$this->link, $options ) ;
            else 
                echo CHtml::tag("div", $options, $label ) ;
        } else if ( $this->post ){      
            $options['onclick'] = '$(this).parents("form")[0].submit(); loadButtonWithCheck( $(this) );';
            echo CHtml::tag("div", $options, $label ) ;            
        } else if ( $this->file && $this->link ){
            $options['class'] .= " fileinput-button";                
            $this->registerClientScript();
            echo CHtml::tag("div", $options, 
                    $label . 
                    CHtml::fileField( $this->file, "", array( 
                        "data-bind" => "submitFileUpload: '". CHtml::normalizeUrl( $this->link ) ."'"                 
                    ) ) 
            );
        } else if ( $this->file && $this->args ){
            $options['class'] .= " fileinput-button";                
            $this->registerClientScript();
            echo CHtml::tag("div", $options, 
                    $label . 
                    CHtml::fileField( $this->file, "", array( 
                        "data-bind" => "submitFileUpload: ".  $this->args                 
                    ) ) 
            );
        } else if ( $this->script ){
            $options['onclick'] = $this->script;
            if ( $this->link )
                echo CHtml::link($label,$this->link, $options ) ;
            else 
                echo CHtml::tag("div", $options, $label ) ;            
        } else if ( $this->link  ){
            $options['onclick'] = 'loadButtonWithCheck( $(this) ); return true;';
            echo CHtml::link($label, $this->link, $options ) ;
        } else {
            echo "Error" ;
        }
        
    }
}
