<?php
/* @var $this PlayoutController */
// If neededing additonal scripts
//Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/ascript/file',CClientScript::POS_END);


$this->registerSpxScript( 'resources.js' );
$this->registerSpxScript( 'schedule.js' );
    
$this->breadcrumbs[] = $this->title = '&nbsp;'; 

$this->topBar .= $this->widget('ActionSet', array(
    'actions' => array( 
        array( 'preset'=> 'clear', 'data-bind' => 'click: clear',
                'visible' => Yii::app()->user->checkAccess('editSchedule')
        ),
        array( 'preset'=> 'apply', 'data-bind' => 'click: apply, visible: isDirty',
                'visible' => Yii::app()->user->checkAccess('editSchedule')
        ) 
    ),
    'options' => array( 
        "class" => "pull-right"
    )
), true); 
$helpDefault = "";
$helpActive = "";
if ( Yii::app()->user->checkAccess('editSchedule') ){
    $this->topBar .= $this->helpButton( array(
        'steps' => array(
            array( 'intro' => I18N::t('This page let you schedule Playout, Playlist or Media')),
            array( 
                'element' => '#IconViewTable',
                'intro' => I18N::t('Select a file to be scheduled'),
                "position" => 'top',
            ),
            array( 
                'element' => '#IconViewForm',
                'intro' => I18N::t('Filter can be used to help'),
                "position" => 'top'
            ),        
            array( 
                'element' => '.spx-gallery > .type-external',
                'intro' => I18N::t('This file let you play content published by Elementi'),
                "position" => 'top',
                "visible" => Yii::app()->user->checkAccess('viewExternal')
            ),
            array( 
                'element' => '#DefaultItem',
                'intro' => I18N::t('Drop the file to the default to select what is displayed by the device when nothing is scheduled.'),
                "position" => 'bottom'
            ),
            array( 
                'element' => '.fc-view-container',
                'intro' => I18N::t('Drop the file on the calendar to schedule it.'),
                "position" => 'bottom'
            ),
        )
    ));
    $helpDefault = $this->helpButton( array(
        'steps' => array(
            array( 
                'element' => '#DefaultItem',
                'intro' => I18N::t('The default file is displayed by the device when nothing is scheduled.'),
                "position" => 'bottom'
            ),
            array( 
                'element' => '#DefaultItemContent',
                'intro' => I18N::t('Drag & drop a playout, a playlist or some media here to configure the file to play by default.'),
                "position" => 'bottom'
            ),
            array( 
                'element' => '#clearDefaultContent',
                'intro' => I18N::t('Clear the default content.'),
                "position" => 'left'
            ),
            array( 
                'element' => '#editDefaultContent',
                'intro' => I18N::t('Edit the file selected as default content.'),
                "position" => 'left'
            )
        )
    ), "startIntroDefault", array( 'data-bind' => 'visible: showDefaultHelp() && !activeEvent().valid && defaultEvent().valid' ), array( "class"=>"btn-sm" ) );
    $helpDefault .= $this->helpButton( array(
        'steps' => array(
            array( 
                'element' => '#DefaultItem',
                'intro' => I18N::t('The default file is displayed by the device when nothing is scheduled.'),
                "position" => 'bottom'
            ),
            array( 
                'element' => '#DefaultItemContent',
                'intro' => I18N::t('Drag & drop a playout, a playlist or some media here to configure the file to play by default.'),
                "position" => 'bottom'
            )
        )
    ), "startIntroDefault2", array( 'data-bind' => 'visible: showDefaultHelp() && !activeEvent().valid && !defaultEvent().valid' ), array( "class"=>"btn-sm" ) );
    $helpActive = $this->helpButton( array(
        'steps' => array(
            array( 
                'element' => '#ActiveItem',
                'intro' => I18N::t('This item is displayed by the device when scheduled.'),
                "position" => 'bottom'
            ),
            array( 
                'element' => '#ActiveItemContent',
                'intro' => I18N::t('Drag & drop a playout, a playlist or some media here to configure the file to play according to the schedule.'),
                "position" => 'bottom'
            ),
            array( 
                'element' => '#ActiveItemProps',
                'intro' => I18N::t('Edit the scheduling properties of the file.'),
                "position" => 'left'
            ),
            array( 
                'element' => '#removeActiveContent',
                'intro' => I18N::t('Remove this file from the schedule.'),
                "position" => 'left'
            ),
            array( 
                'element' => '#editActiveContent',
                'intro' => I18N::t('Edit the file selected.'),
                "position" => 'left'
            )
        )
    ), "startIntroActive", array( 'data-bind' => 'visible: showActivetHelp() && activeEvent().resource' ), array( "class"=>"btn-sm" ) );
    $helpActive .= $this->helpButton( array(
        'steps' => array(
            array( 
                'element' => '#ActiveItem',
                'intro' => I18N::t('This is a placeholder for a new item.'),
                "position" => 'bottom'
            ),
            array( 
                'element' => '#ActiveItemContent',
                'intro' => I18N::t('Drag & drop an item here to create a new event.'),
                "position" => 'bottom'
            )
        )
    ), "startIntroActive2", array( 'data-bind' => 'visible: showActivetHelp() && !activeEvent().resource' ), array( "class"=>"btn-sm" ) );
}
?>

<?php
    
if ( $vertical ){
    echo CHtml::openTag("div", array( "id" => "topWindow", "class" => "row spx-vertical" ));
    echo CHtml::tag("div", array( "class" => "col-lg-9 col-md-8 col-sm-7" ), 
            CHtml::tag("div", array( "data-bind" => "fullCalendar: calendar" ), "" )
    );
    echo CHtml::tag("div", array( "class" => "col-lg-3 col-md-4 col-sm-5 hidden-xs spx-right-menu", "style"=>"margin-top: 42px;"), "" );
    echo CHtml::openTag("div", array( "class" => "col-lg-3 col-md-4 col-sm-5 spx-right-menu", "style"=>"margin-top: 10px;" ) );
    //spx-row-border
} else {
    echo CHtml::openTag("div", array( "id" => "topWindow", "class" => "row spx-row-border" ));
    echo CHtml::tag("div", array( "class" => "col-md-8 col-sm-6" ), 
            CHtml::tag("div", array( "data-bind" => "fullCalendar: calendar" ), "" )
    );
    echo CHtml::tag("div", array( "class" => "col-md-4 col-sm-6 hidden-xs spx-right-menu", "style"=>"margin-top: 42px;"), "" );
    echo CHtml::openTag("div", array( "class" => "col-md-4 col-sm-6 spx-right-menu", "style"=>"margin-top: 10px;" ) );
}
?>
        <div class="panel-group" id="accordion">            
            <div class="panel not-collapsed" id='DefaultItem'>
                <div class="panel-heading">
    <?php     
    $this->widget('ActionSet', array(
        'actions' => array( 
            //array( 'preset'=> 'new', 'data-bind' => 'click: function() { defaultEvent().open(); }, visible: !defaultEvent().valid' ) ,
            array( 
                'preset'=> 'clear', 
                'data-bind' => 'visible: defaultEvent().valid , click: function() { defaultEvent().remove(); }',
                'visible' => Yii::app()->user->checkAccess('editSchedule'),
                'id'=>"clearDefaultContent"
            ), 
            array( 'preset'=> 'edit', 'data-bind' => 'click: function() { defaultEvent().open(); }, visible: defaultEvent().valid && defaultEvent().resource.type !== "external"' ,
                   'visible' => Yii::app()->user->checkAccess('editPlayout'),
                    'id'=>"editDefaultContent"
            ),            
        ),
        'options' => array( 
            "class" => "pull-right",
            'data-bind' => 'visible: showDefaultHelp()'
        ),
        'style' => 'icon',
        'size' => 'btn-sm'
    ));
    echo $helpDefault;
    ?>               
                    <a data-toggle="collapse" data-parent="#accordion" href="#collapseDefault" data-bind="text: defaultEvent().valid?spxapi.t('Default: {name}',{ &quot;{name}&quot;: defaultEvent().resource.model.name.shortStr()} ):spxapi.t('Default')"></a>               
                </div>
                <div id="collapseDefault" class="panel-collapse collapse in">
                    <div class="panel-body" >
                        
                        <div class='row'>
                        <div class="col-md-12">    
                            <div class="content" id="DefaultItemContent" data-bind="hidden: defaultPowerOff, css: {'vertical': defaultEvent().valid && defaultEvent().resource && defaultEvent().resource.model.vertical()}">
                                <div data-bind="droppable: { data: defaultEvent(), template: false }, css: {'vertical': defaultEvent().valid && defaultEvent().resource.model.vertical()}" class="spx-preview-fixed">
                                    <!-- ko if: defaultEvent().valid-->
                                    <!--img data-bind="attr: { src: defaultEvent().resource.model.snapshots.large.src, alt: defaultEvent().title}" class="spx-preview spx-preview-fixed-item"/-->
                                    <div class="spx-preview spx-preview-fixed-item spx-preview-background" data-bind="style: { backgroundImage: 'url('+defaultEvent().resource.model.snapshots.large.src()+')'}"></div>
                                    <!-- /ko -->
                                    <div data-bind="hidden: defaultEvent().valid" class="spx-preview empthy spx-preview-fixed-item">
                                    <div ><div >
                                            <?php echo I18n::ht("Drag & drop");?><br/>
                                            <span class="fa-stack"><i class="fa fa-circle fa-stack-2x"></i><i class="fa fa-inverse fa-desktop fa-stack-1x"></i></span>
                                            <span class="fa-stack"><i class="fa fa-circle fa-stack-2x"></i><i class="fa fa-inverse fa-film fa-stack-1x"></i></span>                    
                                            <span class="fa-stack"><i class="fa fa-circle fa-stack-2x"></i><i class="fa fa-inverse fa-picture-o fa-stack-1x"></i></span>
                                            <span class="fa-stack"><i class="fa fa-circle fa-stack-2x"></i><i class="fa fa-inverse fa-video-camera fa-stack-1x"></i></span>                                            
                                        </div></div> 
                                    </div>
                                </div>
                            </div>
                        </div>                        
                        </div>
                        <div class="spx-extra-space" id="DefaultItemProps" data-bind="hidden: defaultEvent().valid">
        <?php 
        $this->widget('PropertiesInput', array(
            'src' => 'defaultProperties',
            'disabled' => !Yii::app()->user->checkAccess('editSchedule')
        )); 
        ?> 
                        </div>
                    </div>
                </div>
            </div> 
            <div class="panel collapsed" id='ActiveItem' data-bind="visible: activeEvent().valid" >
                <div class="panel-heading">
                    <div class="pull-right" >
    <?php 
    $this->widget('ActionSet', array(
        'actions' => array( 
            //array( 'preset'=> 'new', 'data-bind' => 'visible: !activeEvent().resource, click: function() { activeEvent().open(); }' ) ,
            array( 'preset'=> 'remove', 'data-bind' => 'visible: activeEvent().resource, click: function() { activeEvent().remove(); }',
                    'visible' => Yii::app()->user->checkAccess('editSchedule'),
                    'id'=>"removeActiveContent"),
            array( 'preset'=> 'edit', 'data-bind' => 'visible: activeEvent().resource && activeEvent().resource.type !== "external", click: function() { activeEvent().open(); }',
                    'visible' => Yii::app()->user->checkAccess('editPlayout'),
                    'id'=>"editActiveContent" ) 
            
        ),
        'options' => array( 
            "class" => "pull-right",            
            'data-bind' => 'visible: showActivetHelp()'
        ),
        'style' => 'icon',
        'size' => 'btn-sm'
    ));
    echo $helpActive;
    
    ?>                                        
                </div>
                    <a data-toggle="collapse" data-parent="#accordion" href="#collapseActive" data-bind="text:activeEvent().resource?activeEvent().title:'New'"></a>
                </div>
                <div id="collapseActive" class="panel-collapse collapse">
                    <div class="panel-body">
                        <div class='row'>                            
                        <div class="col-sm-offset-4 col-sm-8">
                            <div class="content" id="ActiveItemContent" data-bind="css: {'vertical': activeEvent().valid && activeEvent().resource && activeEvent().resource.model.vertical()}">
                                <div data-bind="droppable: { data: activeEvent, template: false }, css: {'vertical': activeEvent().valid && activeEvent().resource && activeEvent().resource.model.vertical()}" class="spx-preview-fixed">
                                    <!-- ko if: activeEvent().resource-->
                                    <div class="spx-preview spx-preview-fixed-item spx-preview-background" data-bind="style: { backgroundImage: 'url('+activeEvent().resource.model.snapshots.large.src()+')'}"></div>
                                    <!-- /ko -->
                                    <div data-bind="hidden: activeEvent().resource" class="spx-preview empthy spx-preview-fixed-item">
                                        <div ><div ><?php echo I18N::ht("Drag & drop");?><br/>
                                            <span class="fa-stack"><i class="fa fa-circle fa-stack-2x"></i><i class="fa fa-inverse fa-desktop fa-stack-1x"></i></span>
                                            <span class="fa-stack"><i class="fa fa-circle fa-stack-2x"></i><i class="fa fa-inverse fa-film fa-stack-1x"></i></span>                    
                                            <span class="fa-stack"><i class="fa fa-circle fa-stack-2x"></i><i class="fa fa-inverse fa-picture-o fa-stack-1x"></i></span>
                                            <span class="fa-stack"><i class="fa fa-circle fa-stack-2x"></i><i class="fa fa-inverse fa-video-camera fa-stack-1x"></i></span>                                            
                                        </div></div>                                    
                                    </div>                                
                                </div>
                            </div>
                        </div>
                        </div>
                        
                        <div class="spx-extra-space" id="ActiveItemProps" data-bind="if: activeEvent().valid, visible: activeEvent().resource">
        <?php 
        $this->widget('PropertiesInput', array(
            'src' => 'activeEvent().properties',
            'disabled' => !Yii::app()->user->checkAccess('editSchedule')
        )); 
        ?> 
                        </div>
                    </div>
                </div>
            </div>    
        </div>
    </div>    
</div>
<div class="clearfix visible-xs-block"></div>
<?php 
if ( Yii::app()->user->checkAccess('editSchedule') ){
    
    if ( $vertical ){
        echo CHtml::tag("div", array( "class" => "row"), 
            CHtml::tag("div", array( "class" => "col-lg-9 col-md-8 spx-row-border"), "" )
        );
        echo CHtml::openTag("div", array( "class" => "row"));
        echo CHtml::openTag("div", array( "class" => "col-lg-9 col-md-8", "data-bind"=>"with: resources" ) );
        //
    } else {
        echo CHtml::openTag("div", array( "class" => "row"));
        echo CHtml::openTag("div", array( "class" => "col-md-12", "data-bind"=>"with: resources" ) );
    }    
    $this->widget('AssetsSelect', array(      
        'tableOptions'=>array( "id"=>"IconViewTable" ),
        'formOptions'=>array( "id"=>"IconViewForm" )
    ));
    echo CHtml::closeTag("div");
    echo CHtml::closeTag("div");
} 
?>
<script type="text/html" id="resources-list-template">
    
</script>

<script type="text/javascript" >
//<![CDATA[
<?php
    $models = array( 'external', 'playout', 'media', 'playlist', 'project' );
    
    $resources = array();
    foreach ( $models as $model ){
        if ( Yii::app()->user->checkAccess('view'. ucfirst($model)) ) {
            $resources[] = $model;
        }        
    }
    
    $options = array(
        "newTemplateModal" => "js:$('#newTemplateModal')",
        "links" => array(
            "template" => $this->createUrl("playout/edit", array('templateId'=>"[id]") ),
            "playout" => $this->createUrl("playout/edit", array('id'=>"[id]") ),
            "playlist" => $this->createUrl("playlist/edit", array('id'=>"[id]") ),
            "media" => $this->createUrl("media/edit", array('id'=>"[id]") ),
            "project" => $this->createUrl("project/edit", array('id'=>"[id]") ),            
        ),
        'resources' => $resources,        
        'editable' => Yii::app()->user->checkAccess('editSchedule'),
        'lang' => Yii::app()->getLanguage()
    );    
?>
var model = new ScheduleEdit(<?php echo CJavaScript::encode( $options ); ?>);

$(function() {
    $('.panel-collapse', '#accordion')
        .on('show.bs.collapse', function () {
            $(this).parent().addClass('not-collapsed')
                            .removeClass('collapsed');        

        })
        .on('hidden.bs.collapse', function () {
            $(this).parent().addClass('collapsed')
                            .removeClass('not-collapsed');

        });    
});
ko.applyBindings( model );
//]]></script>
