
var PlaylistItem2 = function( args ) {
    var staticImg;
    var self = {
        id: ko.observable(),
        type: ko.observable(),
        dur: ko.observable(),        
        mediaDur: ko.observable(), 
        schedule: {},
        icon: ko.observable(),
        preview: ko.observable(),       
        placeholder: false,
    };
    
    self.dur.extend( { duration: true } );    
    self.defaultDur = ko.computed( function() {
        if ( self.mediaDur() ){
            return self.mediaDur();
        }
        if ( args.defaultDur() ){
            return args.defaultDur();       
        }
        return undefined;
    }).extend( { duration: true } );
    self.displayDur = ko.computed( function() {
        if ( self.dur() ){
            return self.dur();
        }
        return self.defaultDur();    
    }).extend( { duration: true } );
    
    self.fromJS = function( item ) {
        item.schedule = item.schedule || {};
        self.id( item.id );
        self.type( item.type );
        self.dur( item.dur );
        self.mediaDur( item.mediaDur );
        
        if ( !item.schedule.beginDate )
            item.schedule.beginDate = "";
        if ( !item.schedule.endDate )
            item.schedule.endDate = "";
        self.schedule = ko.mapping.fromJS( item.schedule );
        
         
        var model = spxapi.resources.get( self.id() );
        self.name = model.name;
        self.icon = model.snapshots.small.src;
        self.preview = model.snapshots.medium.src;
        staticImg = model.snapshots.single.src;
        self.mimeType= model.mimeType;
        
    };
    self.toJS = function(){        
        var data = {
            id: self.id(),
            type: self.type(),
            dur: self.dur(),
            schedule : ko.mapping.toJS( self.schedule )
        };
        if ( data.schedule && data.schedule.beginDate === "" )
            data.schedule.beginDate = null;
        if ( data.schedule && data.schedule.endDate === "" )
            data.schedule.endDate = null;
        return data;
    };
    self.toJSON = function(){
        return JSON.stringify( self.toJS() );
    };
    
    self.fromJS( args );
    self.name.extend( { shortStr: 20 } );
    
    self.img = ko.computed( function() {
        return staticImg();
    });
    self.editItem = ko.observable();
    self.toogleEdit = function( ){
        self.editItem( !self.editItem() );
    };
    self.schedule.beginDate.extend({ datetime: "YYYY-MM-DD"} );
    self.schedule.endDate.extend({ datetime: "YYYY-MM-DD"} );
    
    self.properties = ko.computed( function() {
        var props = [
            { name: spxapi.t('Duration'), type : 'dur', value: self.dur, default: self.defaultDur.formated  },
            { name: spxapi.t('Start'), type : 'dateclose', value: self.schedule.beginDate.date },
            { name: spxapi.t('End'), type : 'dateclose', value: self.schedule.endDate.date }         
        ];
        
        return props;
    });
    
    self.mediaType = ko.computed( function() {
        var type = self.type();
        if ( type === 'media' && self.mimeType && self.mimeType() ){
             type = self.mimeType().substr(0, self.mimeType().indexOf('/') );
        }
        return type;
    });
    self.typeIcon = ko.computed( function() {
        return spxapi.ui.iconAction({
            type: self.mediaType() 
        });
    });
    
    return self;
};

var Playlist2 = function( data, args ) {
    
    var self = this;
    args = args || {
        editName: true
    };
    self.inline = ko.observable( !args.editName );
    self.visible = ko.observable( true );
    self.show = function( show ){
        self.visible( show );
    };
    self.fromJS = function( data ) {
        var options = $.extend( {
            defaultDur : 10,
            looping: false,
            mediaFit: "slice",
            mediaAlign: "center",
            shuffle: false,
            transition: null
        }, data.options );
        self.name = ko.observable( data.name );
        self.keywords = ko.observable();
        if ( data.keywords ){
            self.keywords(data.keywords.join(","));
        }
        self.manage = data.manage;
        self.options = {
            defaultDur: ko.observable( options.defaultDur ).extend({ duration: true }),
            looping: ko.observable( options.looping ),
            shuffle: ko.observable( options.shuffle ),
            mediaFit: ko.observable( options.mediaFit ),
            mediaAlign: ko.observable( options.mediaAlign )
        };
        self.transition = {
            name: ko.observable( options.transition && options.transition.ctor || 'none'),
            direction: ko.observable( options.transition && options.transition.args.direction ),
            factor: ko.observable( options.transition && options.transition.args.factorIn ),
            dur: ko.observable( options.transition && options.transition.args.dur || '1s' )
        };
        self.transition.hideDir = ko.computed( function() {
            var name = self.transition.name();
            var valid = ['slide', 'push', 'cubeFace', 'wipe' ];
            return valid.indexOf(name) === -1;
        });
        self.transition.hideFactor = ko.computed( function() {
            var name = self.transition.name();
            var valid = ['zoom' ];
            return valid.indexOf(name) === -1;
        });
        self.transition.hideDur = ko.computed( function() {
            return self.transition.name() === 'none';
        });
    
        self.options.defaultDur.extend({ duration: true });
        self.media = ko.observableArray();
        for( var i=0; i<data.media.length; i++ ){
            data.media[i].defaultDur = self.options.defaultDur;
            self.media.push( new PlaylistItem2( data.media[i] ) );
        } 
        self.media.push( {
            placeholder: true            
        });
        if ( data.active ){
            spxapi.ui.message({
                type: 'info',
                title: spxapi.t('Live Content'),
                text: spxapi.t("This is currently displayed on the screen" )           
            });            
        }
    };
    this.fromJS( data );
    
    self.toJS = function(){
        var data = {
            name: self.name(),            
            options : {
                defaultDur: self.options.defaultDur(),
                looping: self.options.looping(),
                shuffle: self.options.shuffle(),
                mediaFit: self.options.mediaFit(),
                mediaAlign: self.options.mediaAlign(),
                transition: null
            },
            media : []
        };
        if ( self.transition.name() !== 'none' ){
            data.options.transition = {
                args: {
                    dur: self.transition.dur()
                },
                ctor: self.transition.name()
            };
            if ( !self.transition.hideDir() ){
                data.options.transition.args.direction = self.transition.direction();
            }
            if ( !self.transition.hideFactor() ){
                data.options.transition.args.factorIn = self.transition.factor();
                data.options.transition.args.factorOut = self.transition.factor();
            }
            if ( data.options.transition.ctor === 'wipe' ){
                data.options.transition.args.type = 'bar';
                data.options.transition.args.subType = data.options.transition.args.direction;
            }
            if ( data.options.transition.ctor === 'zoom' ){
                data.options.transition.args.factorIn = "5%";
                data.options.transition.args.factorOut = "5%";
                data.options.transition.args.keepZooming = true;
            }
        } 
        if ( self.keywords() ){
            data.keywords = self.keywords().split(",");
        }
        var media = self.media();
        for( var i=0; i<media.length-1; i++ ){
            data.media.push( media[i].toJS() );            
        } 
        return data;        
    };
    self.toJSON = function(){
        return JSON.stringify( self.toJS() );
    };
    /*
    ko.extenders.placeholder = function( target, options ) {        
        var result = ko.computed({
            read: target,  
            write: function( newArray ) {
                if ( options && newArray.lenght > 0 && !newArray[newArray.lenght-1].placeholder ){
                    var fixedArray = [];
                    for ( var i=0; i<newArray.lenght; i++ ){
                        if ( !newArray[i].placeholder ){
                            fixedArray.push( newArray[i] );
                        }
                        fixedArray.push( { placeholder: true} );
                    }
                } else {
                    target(newArray);
                }               
            }
        });
        result( target() );        
        return result;
    };
    self.media.extend({ placeholder: true });
    */
    self.popupPlacement = function (context, source) {
        if ( self.editProperties() ){
            return 'right';
        }
        var position = $(source).offset();
        var width = $('body').width();
        if ( position.left > width - 300 ) {
            return "left";
        } else {
            return 'right';
        }
    }
    self.media.subscribe( function(changes) {
       if ( changes.length === 1 && changes[0].status === 'added' ){
           // is this added at the end ? 
           var l = self.media().length;
           if ( changes[0].index === l-1 && !changes[0].value.placeholder ){
               // remove the placeholder and put it back at the end
               self.media.splice( l-2, 1 );
               self.media.push( { placeholder: true } );
           }
       }
    }, null, "arrayChange");
   self.preview = ko.computed( function() {
        var id;
        var media = self.media();        
        for ( var idx = media.length-1; !id && idx >= 0; idx-- ){
            if ( !media[idx].placeholder ){
                id = media[idx].id();  
            }            
        }        
        var model = spxapi.resources.get( id );
        
        return model.snapshots.single.src();
    }).extend({ rateLimit: 0 });;
    
    this.properties = [ ];
    if ( args.editName ){
        this.properties.push( { name: spxapi.t('Name'), type : 'string', value: self.name } );        
        this.properties.push( { name: spxapi.t('Keywords'), type : 'tags', value: self.keywords, options: { tags: keywordsMemory().get() } } );
    }
    this.properties.push( { name: spxapi.t('Default duration'), type : 'dur', value: self.options.defaultDur } );
    
    if ( !args.editName ){
        //this.properties.push( { name: 'Shuffle', type : 'boolean', value: self.options.shuffle }
        this.properties.push( { name: spxapi.t('Transition'), type : 'choice', value: self.transition.name,
                                select: [ 
                                    { name: spxapi.t('No transition'), value: 'none' },
                                    { name: spxapi.t('Cross fade'), value: 'crossFade' },
                                    { name: spxapi.t('Page'), value: 'page' },
                                    { name: spxapi.t('Zoom'), value: 'zoom' },
                                    { name: spxapi.t('Slide'), value: 'slide' },
                                    { name: spxapi.t('Push'), value: 'push' },
                                    { name: spxapi.t('Cube'), value: 'cubeFace' },
                                    { name: spxapi.t('Wipe'), value: 'wipe' }                               
                                ]} );
                                
        this.properties.push( { name: spxapi.t('Direction'), type : 'choice', value: self.transition.direction,
                                select: [
                                    { name: spxapi.t('Left to right'), value: 'leftToRight' },
                                    { name: spxapi.t('Right to left'), value: 'rightToLeft' },
                                    { name: spxapi.t('Top to bottom'), value: 'topToBottom' },
                                    { name: spxapi.t('Bottom to top'), value: 'bottomToTop' }
                                ],
                                hidden: self.transition.hideDir } );
        this.properties.push( { name: spxapi.t('Factor'), type : 'choice', value: self.transition.factor,
                                select: [
                                    { name: spxapi.t('Small (5%)'), value: '5%' },
                                    { name: spxapi.t('Medium (10%)'), value: '10%' },
                                    { name: spxapi.t('Large (15%)'), value: '15%' }
                                ],
                                hidden:  self.transition.hideFactor } );
        this.properties.push( { name: spxapi.t('Duration'), type : 'dur', value: self.transition.dur,
                                hidden: self.transition.hideDur } );
    }
    this.propertiesEdit = [ ];
    this.propertiesEdit.push( { name: spxapi.t('Media fit'), type : 'choice', value: self.options.mediaFit,
                                select: [ 
                                    { name: spxapi.t('Slice'), value: 'slice' },
                                    { name: spxapi.t('Meet'), value: 'meet' },
                                    { name: spxapi.t('Fill'), value: 'fill' }
                                ]} );
    self.options.hideAllign = ko.computed( function() {
        return self.options.mediaFit() === 'fill';
    });
    this.propertiesEdit.push( { name: spxapi.t('Media align'), type : 'choice', value: self.options.mediaAlign,
                                select: [ 
                                    { name: spxapi.t('Center'), value: 'center' },
                                    { name: spxapi.t('Left'), value: 'midLeft' },
                                    { name: spxapi.t('Right'), value: 'midRight' },
                                    { name: spxapi.t('Top'), value: 'topMid' },
                                    { name: spxapi.t('Bottom'), value: 'bottomMid' }
                                ],
                                hidden: self.options.hideAllign} );
    
    this.createPlaylistItem = function ( item, event, ui ) {
        
        var type = item.type || "media";
        return new PlaylistItem2( {
            id: item.id,
            type: type,
            mediaDur: item.dur,
            defaultDur: self.options.defaultDur
        });
    };
    this.remove = function( media ){
        self.media.remove( media );
    };
    this.push = function( media ){
        self.media.splice( self.media().length-1, 0, media );
    };
    this.set = function( media ){
        if ( $.type(media) === 'array' ){
            self.media( media );        
        } else {
            self.media( [media] );
        }
        self.media.push( {
            placeholder: true            
        });
    };
    
    this.breadcrumbs = ko.observableArray([ { 
        name: self.name,
        active: ko.observable( true )
    } ]).extend({ rateLimit: 0 });

    this.editProperties = ko.observable( false );
    
};

function PlaylistEdit( args ) {
    
    args = args || {};
    var self = this;
    
    self.playlist = ko.observable( new Playlist2({
        name: spxapi.t("New Playlist"),
        media: [],
        options: {
            defaultDur: 30*60,
            shuffle: false
        }
    }));
    self.media = resourcesSelect({
        resources: args.resources || [ 'media', 'playout', 'project' ],
        draggable : true
    });
    
    iconView( self.media, { 
        draggable : true 
    } );
    
    self.id = ko.observable( args.id );
    self.status = new ko.dirtyFlag( self.playlist, true );
    
    spxapi.ui.resourceLoadingInfo.start();
    self.load = function(){
        if ( self.id() ){
            spxapi.ui.resourceLoadingInfo.toLoad++;
            self.playlist().name( spxapi.t("Loading ...") );
            spxapi.playlist.get( spxapi.playlist.uri + self.id() + "/" )
            .done( function( data ){
                self.playlist( new Playlist2( data ));
                self.status.reset();
            }).always(function( data ) {
                spxapi.ui.resourceLoadingInfo.finished();                
            }); 
        } else {
            self.status.reset();
        }
    };
    self.load();
     
    self.saving = ko.observable();
    self.apply = function ( data, event ) {
        spxapi.ui.loading(event.target);
        var params = self.playlist().toJS();
        if( self.id() ) {
            return spxapi.playlist.update( self.playlist().manage, params ).done(function(){
                self.status.reset();                
            }).always( function() {
                spxapi.ui.reset(event.target);
            });
        } else {
            return spxapi.playlist.create( params ).done(function( data ){
                self.status.reset();
                self.id( data.id );
                self.playlist().manage = data.manage;                
                // if this is a new item, then we complete it
                var memory = spxapi.storage.get("spx-calendar-new-item" );
                if ( memory ){
                    var newItem = JSON.parse( memory );
                    newItem.title = data.name;
                    newItem.resource = {
                        id: data.id,
                        type: data.type
                    };                    
                    spxapi.storage.set("spx-calendar-new-item", JSON.stringify( newItem ) );
                }                
            }).always( function() {
                spxapi.ui.reset(event.target);
            });
        }
    };
    self.cancel = function ( data, event ) { 
        location.href = document.referrer; 
    };
    self.save = function ( data, event ) {
        self.apply( data, event ).done( function() {
            self.cancel( data, event );
        });
    };
    self.copy = function ( data, event ) {
        self.id( null );
        self.playlist().name( spxapi.t("{name} - Copy", { "{name}": self.playlist().name()}) ); 
        self.playlist().editProperties( true );
    };
    self.addMediaFile = function( data ) {
        // add a new media to the list of media
        self.media.add( data );
        // add the media to the playlist itself
        self.playlist().push( 
                self.playlist().createPlaylistItem( data )
        );
    };

    self.breadcrumbs = ko.computed( function() {
        if ( !self.playlist() )
            return [];
        return self.playlist().breadcrumbs();
    });  
    
    // Prevent leaving the page with changes
    $(window).bind('beforeunload', function(e){
        if ( self.status.isDirty() ) {
            return spxapi.t("Some changes have not been saved.");
        } else {
            return;
        }
    });
};
