<?php
/* @var $this ConfigController */

$nr_servers = $ntpSettings->loadStats();

$level = "";
$desc = "";

if ( $ntpSettings->message ){
    if ( strpos( $ntpSettings->message, "Warning")!==false ) {
        $level = "warning";       
    } else {
        $level = "info";                
    }
    $desc = $ntpSettings->message;  
}
    
if ( $ntpSettings->active && $nr_servers >= 0 && $nr_servers < $ntpSettings->nr_servers) {
    $desc = "";
    if ($nr_servers == 0) {
        $desc = "The table shows no servers,\n";
    } else {
        $desc = "The table shows fewer servers than what are configured,\n";
    }
    $desc .=    "probably due to network name(s) which cannot be resolved to IP addresses. " .
                "The cause can be a mistyped server name, a retired server name or an " .
                "unreachable DNS server. Please check your NTP and network configuration. " .
                "If the failure is transient the system will recover in a few hours ".
                "without the need for any user intervention.";    
    $level = "info";
}


$formConfig = $this->beginWidget('SimpleForm', array( 
    'title' => "NTP",
    'id' => "NTP",
    'button' => "Apply",
    'action' => array ( 'post' => array() )
) );
    $formConfig->errorSummary( $ntpSettings );

    $headers = array(
        "Server IP", "Stratum", "Status", "Reach", "Time offset", "Delay", "Dispersion", array( "Poll interval", array( "class"=>"hidden-xs hidden-sm"))
    );
    $table = array();
    foreach ( $ntpSettings->stats as $server ){
        $table[] = array(
            $server['server_ip'],
            $server['stratum'],
            $server['status'],
            $server['reach']. " %",
            $server['offset'],
            $server['delay'],
            $server['dispersion'],
            array( $server['poll']." s", array( "class"=>"hidden-xs hidden-sm") )
        );        
    }
    echo BsHtml::alert( BsHtml::ALERT_COLOR_INFO, 
            $formConfig->table( $headers, $table, array(
                "sizes" => array( "col-sm-3", "", "", "", "", "", "", "" ),
                "sizes" => array( "col-sm-3", "", "", "", "", "", "", "" )
            ) ) , 
            array( 'closeText' => false , 'class' => 'table-responsive' )
    );
    if ( Yii::app()->request->isPostRequest  ){
        // this is a hack to prevent browser from opening a popup in case the last action was a POST.
        $script = 'location.assign("'.$this->createUrl( '/controlcenter/main/network', array("re"=>"load", '#'=>'NTP') ).'");';
    } else {
        $script = 'location.reload()';
    }
    $this->widget( 'DialogButton' , array(
        'label' => "Refresh",
        'script' => $script,
        'content' => false
    ));
    echo "<br/>";
    
    if ( !empty($level) ){
        echo BsHtml::alert( 
            $level === "info" ? BsHtml::ALERT_COLOR_INFO : BsHtml::ALERT_COLOR_WARNING, 
            $desc,
            array( 'closeText' => false )
        );  
    }
    for ($i=1; $i<6; $i++ ) {
        echo $formConfig->activeItem( $ntpSettings, "ntpserver".$i, 
            BsHtml::activeTextField( $ntpSettings, "ntpserver".$i, array(
                'append' => CHtml::activeCheckBox( $ntpSettings, "ntpnosel".$i, array( 
                                'value'=>'yes',
                                "data-toggle" => "tooltip", 
                                "data-placement" => "top",
                                "title" => "Monitor only"
                            ) )
            ))
        ); 
    }
    echo $formConfig->activeDropDownList( $ntpSettings, "bootdelay", $ntpSettings->ntpdelayList );
    
$this->endWidget();

