#!/bin/sh

REBOOT_DELAY=5

function is_nfsroot() {
    grep -q '\bnfsroot=' /proc/cmdline
}

function do_fsck() {
    local ret mnt_list mnt need_reboot

    # We check only journalled filesystems, to recover from benign problems only, the root fs is always journalled

    # Check root fs first, should have been mounted read-only
    fsck -a /
    ret=$?
    if [ $ret -gt 3 ]; then
        echo "ERROR: root filesystem check failed" >&2
        return 1
    elif [ $ret -gt 1 ]; then
        echo "WARNING: root filesystem errors repaired but system needs to reboot" >&2
        need_reboot=1
    elif [ $ret -ne 0 ]; then
        echo "INFO: root filesystem successfully repaired" >&2
    fi

    # Get the list of ext4 filesystem mountpoints which are not the root fs
    mnt_list="$(awk '$0 !~ /^[[:space:]]*#/ { if ($3 == "ext4" && $2 != "/") print $2 }' /etc/fstab)"

    # for each one run the filesystem check in automatic repair mode
    # none of these filesystems should be mounted at this point
    for mnt in $mnt_list; do
        fsck -a "$mnt"
        ret=$?
        if [ $ret -gt 3 ]; then
            echo "ERROR: $mnt filesystem check failed" >&2
        elif [ $ret -gt 1 ]; then
            echo "WARNING: $mnt filesystem errors repaired but system needs to reboot" >&2
            need_reboot=1
        elif [ $ret -ne 0 ]; then
            echo "INFO: $mnt filesystem successfully repaired" >&2
        fi
    done

    if [ -n "$need_reboot" ]; then
        echo "INFO: rebooting system after filesystem repair in $REBOOT_DELAY seconds"
        sleep $REBOOT_DELAY
        reboot -f
        # hang in here util system reboots
        while true; do sleep 3600; done
    fi
}

# Do nothing on NFS-root systems
is_nfsroot && exit 0

do_fsck < /dev/null
