<?php
class TimeSettings extends CFormModel {
	
    var $tzarea='Etc';
    var $tzcity=null;
    
	private $path = "/usr/share/zoneinfo/";
	private $tzfile = "/etc/timezone";
    private $phpini;
    
    var $tzmap=array("Africa" => "Africa", "America" => "America", "US" => "US time zones", "Canada" => "Canada time zones",
                 "Asia" => "Asia", "Atlantic" => "Atlantic Ocean", "Australia" => "Australia", "Europe" => "Europe",
                 "Indian" => "Indian Ocean", "Pacific" => "Pacific Ocean", "Etc" => "GMT Offset");
             
    public function init() {
        parent::init();
        if( PHP_OS == "WINNT" ) {
            $this->phpini = "C:/NetBean/UniServer/usr/local/php/php.ini";
            return;
        }
        $this->phpini = file_exists("/etc/php/conf.d") ?
            "/etc/php/conf.d/timezone.ini" : "/etc/php.d/timezone.ini";
    }

    /**
	 * @return array validation rules for model attributes.
	 */
	public function rules() {
		return array(
			array('shortlink', 'checkLink', 'on'=>'timezone'),            
		);
	}
    
    public function attributeLabels()
	{
		return array(
            'tzcity'=>'Use this interface for the network: ',
            'time'=>'Local time',
            'shortlink'=>'Time Zone',        
    	);
	}
    
    public function checkLink( $attribute ){
        $value = $this->$attribute;
        if ( empty($value) || !file_exists( $this->path.$value ) ){
            $this->addError($attribute, "Timezone ('".htmlspecialchars($value)."') is not valid.");
            return false;
		}
        return true;
    }
    
    function getShortlink(){
		return $this->tzarea."/".$this->tzcity;
	}
	function setShortlink( $link ){
		$this->parseLink( $link );
	}
    function parseLink( $link ){
        $inf = explode( "/", $link, 2 );		
        if ( count($inf)>=2 ) {
			$this->tzarea = $inf[0];
			$this->tzcity = $inf[1];
		} else if ( count($inf) == 1 && $inf[0] == 'UTC' ) {
            $this->tzarea = "Etc";
			$this->tzcity = "GMT";
        } else {
			$this->addError('shortlink', "Timezone ('".htmlspecialchars($link)."') is not valid.");
		}  
    }
    function load() {        		
        $this->parseLink( date_default_timezone_get() );                
    }
    
    function getTimeZoneString() {
        if ( $this->tzarea=="Etc" )
            return "GMT".date("P");
        else
            return $this->tzarea."/".$this->tzcity." GMT".date("P");
    }
    function getTimezones( $select2 = false ) {
        
        $filelist = "zone.tab";
		$list = explode("\n", file_get_contents($this->path.$filelist));
		$timezones = array();
		foreach( $list as $line ) {
			if (strlen($line)==0 || $line[0]=="#" ) continue;
			$data = explode("\t", trim($line), 4);
			if ( count($data)<3 ) continue;
			$tz = explode("/", $data[2], 3);
            $name = "";
			if ( count($data)==4 ){
                if ( substr( $data[3],0,6)=="Moscow" )
                    $data[3] = substr( $data[3],12 );
				if ( count($tz)>2 ) {				
                    if ( strpos($data[3], $tz[2])===false )
					    $name = $tz[1]." : ".$tz[2]." (".$data[3].")";
                    else
                        $name = $tz[1]." : ".$data[3];
				} else {
                    if ( strpos($data[3], $tz[1])===false )
					    $name = $tz[1]." (".$data[3].")";
                    else
                        $name = $data[3];
                }
                if ( strlen( $name ) > 30 )
                    $name = ""; // reset the name without the comment when to total string is too long
			}         
            if ( $name=="" ) {
				if ( count($tz)>2 )				
					$name = $tz[1]." : ".$tz[2];
				else
					$name = $tz[1];
			}			
            if ( $select2 ) {
                $timezones[ $tz[0] ][ $data[2] ] = $name;
            } else {
                $timezones[ $tz[0] ][ $name ] = $data[2];
            }
		}		
		// must add GMT offsets
		for( $i= -12; $i<=14; $i++ ) {
			$timezones[ 'Etc' ][ "GMT".($i<0?$i:($i>0?"+".$i:"")) ] = "Etc/GMT".($i<0?"+".(-$i):($i>0?-$i:""));
		}
		foreach ($timezones as $name=>$val ) {
			natsort( $timezones[$name] );
		}
        
        return $timezones;
    }
    
    function save() {
        // check the link
        $link = $this->getShortlink();
		if ( strpos($link, ".")===false && file_exists( $this->path.$link ) ) {
            
            if ( date_default_timezone_get() != $link ) {
			    Tools::save_symlink( $this->path.$link, "/etc/localtime" );
                file_put_contents( $this->tzfile, $link );
			    
                $phpsetup = file_get_contents( $this->phpini );
                if ( $phpsetup == "" ) {
                    $phpsetup = "date.timezone = \"".$link."\"";
                } else {
                    $phpsetup = preg_replace("/^date.timezone =.*/m","date.timezone = \"".$link."\"",$phpsetup);
                }
                file_put_contents( $this->phpini, $phpsetup );
                date_default_timezone_set( $link );
            }
		} else {
			$this->addError('shortlink', "Invalid timezone link");
        }
    }    
}
