<?php

class Wizard extends CFormModel {

    protected $ccconfig;
    protected $job;
    public function init() {
        parent::init();
        $this->job = new MaintenanceJobs;        
    }

    public function rules() {
		$res = array(
            array ( "active, eula", 'safe' ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
        $labels = array(
            'active'=>'Enable Configuration Wizard',
            'eula'=>'I accept the terms in the License Agreement',
            );
        return $labels;
    }
    function clearConfigured() {
		$this->job->clearConfigured();	
    }
    function getWelcome() {
    	return $this->job->isNotConfigured();
    }
    function getEula() {
		return !$this->getActive();
    }
    function setEula( $accept = false ) {
		return $this->setActive( !$accept );
    }
    
    function getActive() {
		return $this->job->getWizard();
        
    }
    function setActive( $useWizard=false ) {
		return $this->job->setWizard( $useWizard );
    }
}
