function extendModelFirmware( yiiModel, config ){
    if ( !( 'ipChecked' in yiiModel ) ) {        
        
        function showFirmwareInfo( args ){
            if ( config.infoTarget ){
                args.type = args.type || "info";
                args.body = args.body || args.text || false;
                var cnt = "";
                if ( args.title && args.body ){
                    cnt = '<h4>'+args.title+'</h4><div>'+args.body+'</div>';
                } else if ( args.title ){
                    cnt = args.title;
                } else {
                    cnt = args.body;
                }
                $(config.infoTarget).html('<div class="alert alert-'+args.type+'" role="alert">'+cnt+'</div>');
            } else {
                return spxapi.ui.message( args );
            }
        }
        function clearFirmwareInfo( id ){
            if ( config.infoTarget ){
                $(config.infoTarget).html("");
            } else {
                spxapi.ui.removeMessage( id );
            }
        }
        yiiModel.ipChecked = ko.observable( { executed: false } );
        yiiModel.checkIp = function ( ) {
            yiiModel.ipChecked( { executed: false } );
            $.getJSON( config.urlNetCheck, function( data ){
                data.executed = true;
                yiiModel.ipChecked( data );
            }).fail(function( jqXHR, textStatus, errorThrown ) {                
                yiiModel.ipChecked( {"success":false, "executed": true, "reason": errorThrown } );
            });    
        };
        yiiModel.firmwareSource = ko.observable( config.source || 'base' );
        
        var firmwareUpdateStartedId = null;
        yiiModel.firmwareInfo = ko.observable( { executed: false } );
        yiiModel.firwareInfoTitle = ko.computed( function(){
            var info = yiiModel.firmwareInfo();
            if ( !info.executed ) {
                return 'Updates Check';
            }
            if ( info.reason ) {
                return 'Updates Check Error';
            }
            if ( !info.updates) {
                return "Updates Checked";
            }
            return "Firmware";
        });
        yiiModel.firwareInfoText = ko.computed( function(){
            var info = yiiModel.firmwareInfo();
            if ( info.canceled ) {
                return 'Cannot check firmware from Internet';
            }
            if ( !info.executed ) {
                return 'Checking for new firmware version';
            }
            if ( info.reason ) {
                return info.reason;
            }
            if ( !info.updates) {
                return "Firmware is up to date.";        
            }
            return "Updates available.<br/>" + yiiModel.firmwareMsg( info );
        });
        yiiModel.firmwareStatus = ko.observable( { started: false } );
        yiiModel.firmwareStatus.subscribe( function( newValue ) {    
            if ( newValue.reason ) {
                showFirmwareInfo( { 
                    type: 'warning', 
                    title: "Firmware Update Error",
                    sticky: true,
                    text: newValue.reason
                } );
            }
        });
        yiiModel._firmwareUpdateConfig;
        function getUpdateOptions(source, checkOnly) {
            const options = { 
                max_wait: 5
            };
            if ( source == 'base' || source == 'local-usb' ){
                options.repo_id = [ source ];
            } else {
                options.repo_id = [ "custom" ];
                options.repo_uri = [ { id: "custom", "uri": source }];
            }
            if (checkOnly) {
                options.check_only = true;
            }
            return options;
        }
        function updateCheckStatus(source, handle, logs) {
            var options = {
                include_log: true
            };
            spxapi.rpc.call("firmware_update_status", [handle, options]).done(function(data) {
                if ( !data.error && data.result.exit && data.result.exit != 'ok' ){
                    if ( data.result.exit == 'fatal' ){
                        data.error = "Firmware is corrupted.";
                    } else {
                        data.error = "Check for update failed. Please check " +
                            "the logs for more details.";
                    }
                    logs = data.result.log.split("\n");
                }
                if ( !data.error ){
                    logs = data.result.log.split("\n");
                    if ( !data.result.exit ) {
                        setTimeout(updateCheckStatus, 1 * 1000, source, 
                            handle, logs);
                    } else {
                        yiiModel.firmwareInfo( {"success": true, 
                            "executed": true,
                            "updates": data.result.packages,
                            "type": data.result.type,
                            "version": data.result.version,
                            "logs": logs} );
                        yiiModel.firmwareSource( source );
                    }
                } else {
                    yiiModel.firmwareInfo({"success": false, "executed": true, 
                        "reason": data.error, "logs": logs});
                }
            });
        }
        yiiModel.updateCheck = function ( source, forceCheck, status ) {
            if (!forceCheck && status != null) {
                yiiModel.firmwareInfo( {"success": status['success'],
                    "executed": true, "reason": status['reason'] } );
                return;
            }
            const options = getUpdateOptions(source, true);
            spxapi.rpc.call("firmware_update", [options]).done(function(data) {
                if ( !data.error ) {
                    setTimeout(updateCheckStatus, 
                        (options.max_wait + 1) * 1000, source, data.result);
                } else {
                    console.log( data );
                    yiiModel.firmwareInfo({"success":false, "executed": true, 
                        "reason": data.error});
                }
            });
        };
        yiiModel.checkFirmware = function ( source, forceCheck, status, ipCheck ) {
            yiiModel.firmwareInfo( { executed: false } );     
            yiiModel.firmwareStatus( { started: false } );
            if ( source !== "base" || !ipCheck ){
                yiiModel.updateCheck( source, forceCheck, status );
            } else {
                var sub = yiiModel.ipChecked.subscribe( function( newValue ) {
                    if ( newValue.executed ){
                        if ( newValue.success ) {
                            yiiModel.updateCheck( source, forceCheck, status );
                        } else {
                            yiiModel.firmwareInfo( { canceled: true } );
                        }
                        sub.dispose();
                    }
                });
                if ( !yiiModel.ipChecked().executed ){
                    yiiModel.checkIp();
                } else {
                    // trigger the update of the data again
                    yiiModel.ipChecked( yiiModel.ipChecked() );                    
                }
            }
        };
        yiiModel.firmwareMsg = function( data ){
            var version = data.version;
            var build = data.build;
            if ( version && !build ){
                var sp = version.split("-");
                if ( sp.length == 2 ){
                    version = sp[0];
                    build = sp[1];
                }
            }
            var msg = {
                'firmware': "firmware version " + version + " (build "+build+")",
                'updater': "updater version " + version + " (build "+build+")",
                'minor components': "minor components",
                'minor': "minor components"
            }; 
            return msg[data.type];
        };
        yiiModel.updateStatus = function () {    
            var options = {
                include_log: true
            };
            spxapi.rpc.call("firmware_update_status", [ yiiModel._firmwareUpdateConfig.handle, options ] ).done( function( data ) {
                var logs = yiiModel.firmwareStatus().logs;
                if ( !data.error && data.result.exit && data.result.exit != 'ok' ){
                    if ( data.result.exit == 'fatal' ){
                        data.error = "Firmware is corrupted" ;
                    } else {
                        data.error = "Please check the logs and try again";
                    }
                    logs = data.result.log.split("\n");
                }
                if ( !data.error ){                    
                    var status = data.result;
                    if ( status.handle ) {
                        yiiModel._firmwareUpdateConfig.handle = status.handle;
                    }
                    status.started = true;
                    if ( status.log ){
                        status.logs = status.log.split("\n");
                    }
                    status.running = !status.exit;
                    yiiModel.firmwareStatus( status );
                    if ( !status.exit ) {
                        yiiModel._firmwareUpdateConfig.idx++;
                        setTimeout( yiiModel.updateStatus ,30*1000 );
                        // could update the notification dialog
                    } else {
                        clearFirmwareInfo( firmwareUpdateStartedId );
                        firmwareUpdateStartedId = null;   
                                                
                        var body = "<p>" + "Installed " + yiiModel.firmwareMsg(status) + "." + "</p>";                        
                        if ( status.complete ){
                        	if ( status.applied_on_reboot ) {
                                body += "<p id='rebootMsg' >" + "Device is restarting to complete the update, it may take a few minutes to complete and restart multiple times, please wait." + "</p>";
                        	} else {
                        		body += "<p id='rebootMsg' >" + "Device is restarting, please wait." + "</p>";
                        	}
                        } else {
                            body += "<p>"+"Other updates are still awaiting installation, another update will be perfomed in order to have an up to date firmware."+"</p>";
                            var startAgain = yiiModel.reboot.subscribe(function( newVal ){
                                if ( !newVal ){
                                    yiiModel.updateStart();
                                    startAgain.dispose();
                                }
                            });
                        } 
                        showFirmwareInfo( { 
                             type: 'info', 
                             title: "Firmware Updated",
                             sticky: true,
                             body: body                             
                        } );                     
                        yiiModel.reboot( true );                        
                    }
                } else {
                    yiiModel.firmwareStatus( {
                        started: false,
                        success: false,
                        reason: data.error,
                        logs: logs
                    } );                    
                }
            });
        };
        
        yiiModel.updateStart = function () {  
            firmwareUpdateStartedId = showFirmwareInfo( { 
                type: 'info', 
                title: "Firmware Update Started",
                sticky: true,
                text: "This operation might take some time. The player will automatically restart at the end of the update."
            } );
            yiiModel.firmwareInfo( { executed: false } );            
            yiiModel.firmwareStatus( { started: true, running: true } );
            spxapi.rpc.call("firmware_update", [ getUpdateOptions(yiiModel.firmwareSource()) ] ).done( function( data ) {
                if ( !data.error ){                         
                    yiiModel._firmwareUpdateConfig = { handle: data.result, idx: 0 };    
                    if ( config && config.urlFirmwareStatus ) {
                        location.assign( config.urlFirmwareStatus.replace( "SRC", data.result ).replace( "SOURCE", yiiModel.firmwareSource() ) );
                    } else {
                        yiiModel.firmwareStatus( { started: true, running: true } );
                        yiiModel.updateStatus();
                    }
                } else {
                    console.log( data );
                    yiiModel.firmwareStatus( {
                        started: false,
                        success: false,
                        reason: data.error
                    } );                    
                }
            });
        };
        
        if ( config.handle ){
            firmwareUpdateStartedId = showFirmwareInfo( { 
                type: 'info', 
                title: "Firmware Update in progress",
                sticky: true,
                text: "This operation might take some time. The player will automatically restart at the end of the update."
            } );
            yiiModel.firmwareStatus( { started: true, running: true } );
            yiiModel._firmwareUpdateConfig = { handle: config.handle===true ? "" : config.handle, idx: 0 }; 
            
            yiiModel.updateStatus();
        }
    }
}