<?php
class MySysLogRoute extends CSysLogRoute {
    public function init()
	{
        // always open the syslog with the proper settings
        openlog($this->identity,LOG_ODELAY | LOG_PERROR | LOG_PID,$this->facility);
	}
    protected function processLogs($logs)
	{
		static $syslogLevels=array(
			CLogger::LEVEL_TRACE=>LOG_DEBUG,
			CLogger::LEVEL_WARNING=>LOG_WARNING,
			CLogger::LEVEL_ERROR=>LOG_ERR,
			CLogger::LEVEL_INFO=>LOG_INFO,
			CLogger::LEVEL_PROFILE=>LOG_DEBUG,
		);
		openlog($this->identity,LOG_ODELAY | LOG_PERROR | LOG_PID,$this->facility);
		foreach($logs as $log)
			syslog($syslogLevels[$log[1]],$this->formatLogMessage(str_replace("\n",', ',$log[0]),$log[1],$log[2],$log[3]));
		closelog();
	}
}