<?php

class SPXWizard extends CWidget
{
    var $title;    
    var $pages = array();
    var $success = null;
    var $error = null;
    var $failure = null;
    var $options;
    var $submit = false;
    var $ajax = false;
    var $wizardName = "yiiWizard";
    protected function registerClientScript()
    {        
        $cs=Yii::app()->clientScript;
        if ( $this->options ){
            $jsOption = CJavaScript::encode( $this->options );
        } else {
            $jsOption = "{}";
        }
        if ( $this->ajax ){
            $csrfToken = CJavaScript::quote(Yii::app()->request->csrfToken);
            $csrfTokenName = Yii::app()->request->csrfTokenName;
            if ( !isset($this->ajax['data']) ){
                $this->ajax['data'] = 'js:formData';
                $this->ajax['processData'] = false;
                $this->ajax['contentType'] = false;
            }
            $successFunction = "";
            if ( isset($this->ajax['successFunction'])){
                $successFunction = $this->ajax['successFunction']."( response, textStatus, jqXHR );";
                unset($this->ajax['successFunction']);
            }
            $failFunction = "";
            if ( isset($this->ajax['failFunction'])){
                $failFunction = $this->ajax['failFunction']."( jqXHR, textStatus, errorThrown );";
                unset($this->ajax['failFunction']);
            }
            if (isset($this->ajax['doneFunction'])){
                $doneFunction = $this->ajax['doneFunction'];
                unset($this->ajax['doneFunction']);
            } else {
                $doneFunction = <<<JSSCRIPT
function(response, textStatus, jqXHR) {
    wizard.submitSuccess();
    wizard.close();
    wizard.hideButtons();
    wizard.updateProgressBar(0);
    $successFunction
    wizard.reset();
}
JSSCRIPT;             
            }
            $jsAjax = CJavaScript::encode( $this->ajax );
            $submit = <<<JSSCRIPT
function( wizard ) {
        var formData = new FormData(wizard.form[0]);
        formData.append('$csrfTokenName','$csrfToken');    
        $.ajax( $jsAjax ).done($doneFunction).fail(function( jqXHR, textStatus, errorThrown ) {
            wizard.submitFailure();
            wizard.hideButtons();
            $failFunction
        });
    } 
JSSCRIPT;
        } else {
            $submit = $this->submit;
        }
        if ( $submit ) {
            $submit = "$this->wizardName.on( 'submit', $submit );\n";
        }
        $id = $this->id;
        $script = <<<JSSCRIPT
var $this->wizardName;
$(function(){        
    $this->wizardName = $('#$id').wizard( $jsOption );
    $submit
    $this->wizardName.setCard( 0 );
    $this->wizardName.on("readySubmit", function( w ) { w.changeNextButton( w.args.buttons.submitText, "btn-primary") });
});
JSSCRIPT;
        $cs->registerScript( 
            $this->wizardName, $script, CClientScript::POS_BEGIN
        );     
    }
    
    public function open( $title ){
        return CHtml::openTag("div", array( 
            "class" => "wizard",
            "id" => $this->id,
            "data-title" => $title
        ) )."\n";        
    }
    public function page( $idx, $title, $content, $validate = null ){
        $ret = "";
        $options = array( 
            "class" => "wizard-card",
            "data-cardname" => "card" . $idx
        );
        if ( $validate ){
            $options["data-validate"] = $validate;
        }
        
        $ret .= CHtml::openTag("div", $options )."\n"; 
        $ret .= CHtml::tag("h3", array( 'class' => 'hidden' ), $title )."\n";
        
        $ret .= CHtml::openTag("div", array() )."\n";        
        $ret .= $content;
        $ret .= CHtml::closeTag("div") ."\n";
        $ret .= CHtml::closeTag("div") ."\n";
        return $ret;
    }
    public function group( $type, $content ){
        $ret  = CHtml::openTag("div", array( 
            "class" => "wizard-$type"
        ) );
        $ret .= $content;
        $ret .= CHtml::closeTag("div") ."\n";
        return $ret;
    }
    
    public function close( ){
        return CHtml::closeTag("div")."\n";
    }
    public function init()
    {
        //ob_start();
    }
    public function run()
    {
        $this->registerClientScript();
        echo $this->open( $this->title );
        foreach ( $this->pages as $idx => $page ){ 
            if (isset( $page['visible']) && !$page['visible'] ){
                continue;
            }
            $validate = null;
            $title = null;
            if ( is_array($page) ){
                $title = $page['title'];
                $content = $page['content'];
                if (isset( $page['validate'] )){
                    $validate = $page['validate'];
                }
                
            } else {                
                $title = "Step " .$idx;
                $content = $page;
            }
            echo $this->page( $idx, $title, $content, $validate );
        }
        if( $this->success ) {
            echo $this->group( 'success', $this->success );            
        }
        if( $this->error ) {
            echo $this->group( 'error', $this->error );            
        }
        if( $this->failure ) {
            echo $this->group( 'failure', $this->failure );            
        }
        echo $this->close( ); 
    }
}
