<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');

$models = "media|playlist|playout|template|apps|external|project";
// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
$config = array(
	'basePath'=>dirname(__FILE__).DIRECTORY_SEPARATOR.'..',
    'runtimePath' => '/var/cache/spxmanage/yii-runtime',
	'name'=>'SpinetiX',    
    
    'defaultController' => 'main',
    'sourceLanguage'=>'en',
    
	// preloading 'log' component
	'preload'=>array(
        'log'
    ),
    'aliases' => array(
        'bootstrap' => 'application.ext.bootstrap',
        'controlcenter' => 'application.modules.controlcenter',
        'api' => 'application.modules.api',
    ),
	// autoloading model and component classes
	'import'=>array(
		'application.models.*',
		'application.components.*',
        'application.utils.*',
        'controlcenter.models.*',
        'controlcenter.controllers.*',
        'controlcenter.components.*',
        'api.models.*',
        'api.components.*',
        'bootstrap.behaviors.*',
        'bootstrap.helpers.*',
        'bootstrap.widgets.*'
	),

	'modules'=>array(
		'api' => array(
            'defaultController' => 'media',
        ),
        'assets'=> array(
            'defaultController' => 'media',
        ),
        'controlcenter'=> array(
            'defaultController' => 'main',
        ),		
	),
    
	// application components
	'components'=>array(
        'session'=>array(
		 	'sessionName'=>'uisess',
            'cookieParams' => array('httponly' => true, 'samesite' => 'Lax')
		),
		'urlManager'=>array(
			'urlFormat'=>'path',
            'showScriptName' =>false, 
			'rules'=>array(
                array('api/api/option', 'pattern'=>'api/<detail:.*>', 'verb'=>'OPTIONS'),
                
                array('api/api/list', 'pattern'=>"api/<model:(resource|schedule|$models)>/", 'verb'=>'GET'),
                array('api/api/set', 'pattern'=>"api/<model:(schedule)>/", 'verb'=>'PUT'),
                array('api/api/create', 'pattern'=>"api/<model:($models)>/", 'verb'=>'POST'),
                array('api/api/clear', 'pattern'=>"api/<model:(schedule)>/", 'verb'=>'DELETE'),
                
                array('api/api/get', 'pattern'=>"api/<model:($models)>/<id:\d+>", 'verb'=>'GET'),
                array('api/api/update', 'pattern'=>"api/<model:($models)>/<id:\d+>", 'verb'=>'PUT'),
                array('api/api/delete', 'pattern'=>"api/<model:($models)>/<id:\d+>", 'verb'=>'DELETE'),
                
                array('api/api/update', 'pattern'=>'api/<model:(media)>/<id:\d+>/<detail:\w+>', 'verb'=>'PUT'),
                
                array('api/api/post', 'pattern'=>'api/<model:(media)>/<id:\d+>/', 'verb'=>'POST'),
                
                array('api/apps/<action>/', 'pattern'=>'api/apps/<id:\d+>/<action:\w+>', 'verb'=>'GET'),

                'main/go/*' => 'main/go',
                
                '<module:\w+>/<controller:\w+>/<action:\w+>'=>'<module>/<controller>/<action>',
                'assets/<controller:\w+>/<action:\w+>/<id:\w+>'=>'assets/<controller>/<action>'
                
			),
		),
		'request'=>array(
            'class'=>'MyHttpRequest',
            'enableCsrfValidation'=>true,
        ),
		'db'=>array(
			'connectionString' => 'sqlite:/var/lib/spxmanage/ui/ui.db'
		),
        'dbassets'=>array(
			'connectionString' => 'sqlite:/srv/raperca/interface/protected/assets.db',
            'class'            => 'CDbConnection',
            'initSQLs' => array( 'PRAGMA synchronous = NORMAL;' )
		),
        
        
        'authManager'=>array( 
            'class'=>'CDbAuthManager',
            'defaultRoles'=>array('authenticated', 'guest'),
        ),
		'user'=>array(
			'class'=>'application.components.WebUser', // using custom WebUser class
            'allowAutoLogin'=>true,
            'absoluteAuthTimeout' => 8 * 60 * 60,
            'loginUrl' => array('/user/login'),
            'loginRequiredAjaxResponse' => json_encode( array(
                'success' => false,
                'errors' => array( 'Credential missing' ),
                'redirect' => '/',
            ) )
		),
        'messages'=>array(
			'class'=>'CGettextMessageSource',
            'catalog' => "app",
			'useMoFile'=>false,
		),
/*        
        'errorHandler'=>array(
			// use 'site/error' action to display errors
			'errorAction'=>'error/main',
		),
 */
		'log'=>array(
			'class'=>'CLogRouter',
			'routes'=>array(
				array(
					'class'=>'MySysLogRoute',
					'levels'=> defined('YII_DEBUG') && YII_DEBUG ? 'trace, info, warning, error' : 'warning, error',
                    'identity'=> 'spxmanage.yii',
                    'facility'=> LOG_USER
				)                
			),
		),
        'bootstrap' => array(
            'class' => 'bootstrap.components.BsApi'
        )
	),

	// application-level parameters that can be accessed
	// using Yii::app()->params['paramName']
	'params'=>array(
		// this is used in contact page
		'adminEmail'=>'support@spinetix.com',
	),    
    'onBeginRequest'=>array('FirmwareUpdate', 'updateInProgress'),
);
return $config;
