<?php

class checkIP extends CValidator  {
    public $allowEmpty = true;
    public function validateAttribute( $object, $attribute ){
        $value = $object->$attribute;
        if ( $this->allowEmpty && trim( $value ) =="" ) return true;
        
        if ( !filter_var( $value, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6 | FILTER_FLAG_IPV4) ) {
            $object->addError($attribute,'Invalid IP format');
            return false;
        } else {
            return true;
        }        
    }
}