<?php
/* @var $this OperationController */
    
$this->beginWidget('SimpleForm', array( 
    'title' => "Maintenance",
    'id' => "Maintenance"
) );
    $this->widget( 'DialogButton' , array(
        'label' => "Restart Now",
        'link' => array("operation/reboot", 'reboot'=>true, ),
        'ko' => 'doShutdown',
        'content' => false
    ));
    if ( Yii::app()->device->model!='Bonsai' ){
        $txt = "pressing the push button or physically disconnecting and reconnecting the device from electrical power.";	
    } else {
        $txt = "physically disconnecting and reconnecting the device from electrical power.";
    }
    $this->widget( 'DialogButton' , array(
        'label' => "Shutdown Now",
        'link' => array("operation/reboot", 'shutdown'=>true, ),
        'ko' => 'doShutdown',
        'level' => BsHtml::ALERT_COLOR_WARNING,
        'content' => "After shutdown the device can only be restarted by ".$txt
    ));

    $state = Tools::checkRecoverySate();
    $desc = "Pressing 'Start Recovery Mode' will restart the ".Yii::app()->branding->product." in recovery mode where diagnostics can be run and the firmware re-installed.";
    $recTxt = "";
    if ( $state == "bonjour" ) {
        $inf = new BasicInfo;
        $redirect = "http://".$inf->hostname.".local/";	        
        $recTxt .= "The unit is always reachable at <a href='http://".$inf->hostname.".local/'>http://".$inf->hostname.".local</a> from Zeroconf enabled computers on the local network.</p>";
        $recTxt .= CHtml::tag("p", array(),  "Please use the <a href='http://".$inf->hostname.".local/'>following link</a> to refresh the interface."). "\n";

        $desc .= ". The unit is always reachable at <a href='http://".$inf->hostname.".local/'>http://".$inf->hostname.".local</a> from Zeroconf enabled computers on the local network.<br/>\n";
    } elseif ( $state == "current" ) {
        $redirect = "/";
        $recTxt .=  "The network address should be the same as the one currently.</p>";
        $recTxt .= CHtml::tag("p", array(),  "Please use the <a href='/'>following link</a> to refresh the interface."). "\n";

        $desc .= " with the same network address.<br/>\n";
    }else{
        $redirect = "http://192.168.1.11/";
        $recTxt .= "The network address will be in the range 192.168.1.11 to 192.168.1.29.</p>";
        $recTxt .= "<p>Please use one of the following link to refresh the interface: ";
        $recTxt .= "<a href='http://192.168.1.11/'>http://192.168.1.11/</a>, <a href='http://192.168.1.12/'>http://192.168.1.12/</a>, <a href='http://192.168.1.13/'>http://192.168.1.13/</a> and so on.</p>\n";

        $desc .= " with a free IP address in the range of 192.168.1.11 to 192.168.1.29 otherwise.<br/>\n";
    }
    /*
    $this->widget("BootstrapAlert", array(
        'visible' => 'recoveryMode',
        'level' => 'info',
        'title' => "The system will reboot in recovery mode",
        'desc' =>   $recTxt
    ));
    */
    $this->widget( 'DialogButton' , array(
        'label' => "Start Recovery Mode",
        'link' => array("operation/reboot", 'rebootrecovery'=>true, ),
        'ko' => 'doShutdown',
        'level' => BsHtml::ALERT_COLOR_WARNING,
        'content' => $desc
    ));
    
$this->endWidget();
    
$this->observable('shutdown', false );
?>
<script type="text/javascript" >
//<![CDATA[


yiiModel.doShutdown = function( model, ev ) {
    var self = this;
    this.doAjaxButton( model, ev, 
        function( ev, response ) {
            if ( response.data.recoveryMode ){
                yiiModel.redirect = <?php echo CJavaScript::encode($redirect); ?>;
                spxapi.ui.message( { 
                    type: 'info', 
                    title: "Recovery Mode",
                    sticky: true,
                    text: <?php echo CJavaScript::encode($recTxt); ?>
                } );
            }
            if ( response.data.shutdown ){
                spxapi.ui.message( { 
                    type: 'warning', 
                    title: "Shutdown in Progress",
                    sticky: true,
                    text: "When finished, you can safely unplug it from the power"
                } );
            }            
        }
    );
};

//]]></script>