<?php
class SimpleForm extends CWidget
{
    var $title = false;    
    var $button = false;
    var $moreButtons = array();
    
    var $action;
    var $desc = null;
    var $useForm = null;
    var $dataBind = null;
    var $clearfix = true;
    var $hide = false;
    var $nbBox = 1;
    
    var $labelSize = 6;
    var $inputSize = 6;
    var $buttonSize = 3;
    var $classes = array( 1=>"", 2=>"col-sm-6", 3=>"col-sm-4" );
    var $defaultClass = "btn btn-primary";
    var $contentClass = "content";
    var $formClass = "form-horizontal";
    var $noLabel = false;
    protected $_useFileupload = false;
    
    protected function registerClientScript()
    {        
        $cs=Yii::app()->clientScript;
        $cs->registerScript( 
            'yiiErrors', "var yiiErrors = [];", CClientScript::POS_BEGIN
        );      
        $csrfTokenName = Yii::app()->request->csrfTokenName;
        $csrfToken = CJavaScript::quote(Yii::app()->request->csrfToken);
        
        $script = <<<JSSCRIPT
ko.bindingHandlers.submitFileUpload = {
    init: function (element, valueAccessor, allBindings ) {
        var button = $(element).parent();
        var args = {} ;
        if ( typeof valueAccessor() === 'string' ){
            args.url = valueAccessor();
        } else {
            $.extend( args, valueAccessor() );
        }
        if ( args.done ) {
            args.inputDone = args.done;
        }
        if ( !args.formData ) {
            args.formData = {};
        }
        args.formData['$csrfTokenName'] = '$csrfToken';
        args.done = function (e, data) {
            button.button('reset');
            setTimeout( function() { 
                // muste re-apply the fileupload, as the loading/reset destry the element            
                button.children('input').fileupload( args );
            }, 0 );
            yiiModel.updatePlayerResponse( data.result );
            if ( args.inputDone ){
                args.inputDone( e, data );                
            }
        };
        if ( args.fail ) {
            args.inputFail = args.fail;
        }
        args.fail = function (e, data) {
            button.button('reset');
            setTimeout( function() { 
                // muste re-apply the fileupload, as the loading/reset destry the element            
                button.children('input').fileupload( args );
            }, 0 );
            var r;
            try {
                r = JSON.parse( data.jqXHR.responseText );
            } catch ( e ) {      
                r = { errors : [ "Some error occured: " + data.errorThrown ] };
            }            
            yiiModel.updatePlayerResponse( r );
            if ( args.inputFail ){
                args.inputFail( e, data );                
            }            
        };
        if ( args.submit ) {
            args.inputSubmit = args.submit;
        }
        args.submit = function (e, data) {
            button.button('loading');
            if ( args.inputSubmit ){
                args.inputSubmit( e, data );                
            }
        };
        $(element).fileupload( args );
    }
};
JSSCRIPT;
        $cs->registerScript( 
            'fileUploadBinding', $script, CClientScript::POS_BEGIN
        );        
    }
    public function errorSummary( $model ) {
        if ( !$model || !is_object($model)){
            throw new Exception("Model not defined");
        }
        Yii::app()->clientScript ->registerScript( 
            'yiiErrors', "var yiiErrors = [];", CClientScript::POS_BEGIN
        );
        if ( count( $model->getErrors()) > 0 ){
            $script = "";
            foreach ( $model->getErrors() as $attribute => $errors ){
                foreach ( $errors as $error) {
                    $script .= "yiiErrors.push( ".CJavaScript::encode($error)." );\n";
                }
            }
            echo CHtml::script( $script )."\n";
        }
    }
    
    public function activeObservable( $model, $attribute, $options, $base = null, $bindings = "value" ){
        $this->controller->activeObservable( $model, $attribute, $base );
        $this->controller->addDatabind($options, $bindings.": ".$attribute);        
        return $options;
    }
    public function activeFileField( $model, $attribute, $options = array(), $observable = false ){        
        if ( !$observable ){
            $observable = true;
        }
        if ( $observable ){
            $options = $this->activeObservable($model, $attribute, $options, $observable);
        }  
        return $this->activeItem( $model, $attribute, 
            CHtml::tag("div", array( "class" => "btn btn-default btn-block fileinput-button" ), 
                CHtml::tag("span", array( "data-bind" => "text: $attribute() ? $attribute().replace(/^.*[\\\\\\/]/, '') : 'Select File'" ), "" ) .
                CHtml::activeFileField($model, $attribute, $options )
            )
        );
    }
    public function activeDropDownList( $model, $attribute, $data, $options = array(), $observable = false ){
        
        if ( $observable )
            $options = $this->activeObservable($model, $attribute, $options, $observable );
        
        if ( isset( $options['data-bind']) && strpos($options['data-bind'], "value:") !== false) {
            $options['data-bind'] = str_replace("value:", "bootstrapSelect:", $options['data-bind']);            
        } 
        if ( !isset( $options['data-bind']) || strpos($options['data-bind'], "bootstrapSelect:") === false) {
            $this->controller->addClass($options, "selectpicker");            
        }
        return $this->activeItem( $model, $attribute, 
            CHtml::activeDropDownList($model, $attribute, $data, $this->itemOptions($options) )
        );
    }
    public function activeSelect2( $model, $attribute, $data, $options = array(), $observable = false ){
        
        if ( $observable )
            $options = $this->activeObservable($model, $attribute, $options, $observable );
        
        if ( isset( $options['data-bind']) && strpos($options['data-bind'], "value:") !== false) {
            $options['data-bind'] = str_replace("value:", "select2:", $options['data-bind']);            
        } else {
            $this->controller->addClass($options, "select2");            
        }
        return $this->activeItem( $model, $attribute, 
            CHtml::activeDropDownList($model, $attribute, $data, $options )
        );
    }
    public function activeTimezone( $model, $attribute, $data, $options = array(), $observable = false ){
        
        if ( $observable ){
            $options = $this->activeObservable($model, $attribute, $options, $observable );
        }
        if ( isset( $options['data-bind']) && strpos($options['data-bind'], "value:") !== false) {
            $options['data-bind'] = str_replace("value:", "timezonepicker:", $options['data-bind']);            
        } else {
            $this->controller->addClass($options, "timezonepicker");             
        }        
        if ( isset($options["auto"]) ){
            unset($options["auto"]); 
        } else {
        $options["data-default"] = $model->$attribute;            
        }
        
        return $this->activeItem( $model, $attribute, 
            CHtml::activeDropDownList($model, $attribute, $data, $options )
        );
    }
    public function activeTextField( $model, $attribute, $options = array(), $observable = false ){
        
        if ( $observable )
            $options = $this->activeObservable($model, $attribute, $options, $observable );
        
        return $this->activeItem( $model, $attribute,
            CHtml::activeTextField($model, $attribute, $this->itemOptions($options) )
        );
    }
    public function activeHiddenField( $model, $attribute, $options = array(), $observable = false ){
        
        if ( $observable )
            $options = $this->activeObservable($model, $attribute, $options, $observable );
        
        return CHtml::activeHiddenField($model, $attribute, $options );        
    }
    public function activePasswordField( $model, $attribute, $options = array(), $observable = false ){
        
        if ( $observable )
            $options = $this->activeObservable($model, $attribute, $options, $observable );
        
        return $this->activeItem( $model, $attribute,
            CHtml::activePasswordField($model, $attribute, $this->itemOptions($options) )
        );
    }
    public function activeRadioButtonList( $model, $attribute, $data, $options = array(), $observable = false ){
        
        if ( $observable )
            $options = $this->activeObservable($model, $attribute, $options, $observable , "checked");
        
        if ( isset( $options['data-bind']) && strpos($options['data-bind'], "checked:") !== false) {
            $options['data-bind'] = str_replace("checked:", "iCheck:", $options['data-bind']);
        } else {
            $this->controller->addClass($options, "icheck");            
        }
        $options['uncheckValue'] = null;
        if ( !isset( $options['separator']) )
            $options['separator'] = " ";
        if ( !isset( $options['template']) )
            $options['template'] = "<div class='col-sm-3' >{input} {label}</div>";
        return $this->activeItem( $model, $attribute, 
                CHtml::activeRadioButtonList($model, $attribute, $data, $this->itemOptions($options) )
        );     
    }
    public function activeSwitch( $model, $attribute, $options = array(), $observable = false ){
        
        if ( $observable )
            $options = $this->activeObservable($model, $attribute, $options, $observable , "checked");            
        
        if ( isset( $options['data-bind']) && strpos($options['data-bind'], "checked:") !== false ) {
            $options['data-bind'] = str_replace("checked:", "bootstrapSwitch:", $options['data-bind']);
        } else {
            $this->controller->addClass($options, "switch");            
        }
        return $this->activeItem( $model, $attribute, 
                CHtml::activeCheckBox($model, $attribute, $this->itemOptions($options) )
        ); 
    }
    
    public function activeCheckBox( $model, $attribute, $options = array(), $observable = false, $revert = false ){
        $class = "form-group";
        $offset = $this->labelSize;
        $size = $this->inputSize;
        if ( isset( $options['offset']) ){
            $offset = $options['offset'];
            $size = $this->labelSize + $this->inputSize - $offset;
            unset( $options['offset'] );
        }
        if( $model->hasErrors($attribute) )
            $class .= " has-error";
        if ( $observable )
            $options = $this->activeObservable($model, $attribute, $options, $observable , "checked");            
        
        if ( isset( $options['data-bind']) && strpos($options['data-bind'], "checked:") !== false ) {
            $options['data-bind'] = str_replace("checked:", "iCheck:", $options['data-bind']);
        } else {
            $this->controller->addClass($options, "icheck");
        }
        if ( $revert ){
            return CHtml::tag("div", array("class" => $class),  
                    CHtml::tag("div", array("class" => "col-sm-offset-$offset col-sm-$size"), 
                        CHtml::tag("div", array("class" => "checkbox"),
                            CHtml::activeCheckBox(
                                    $model, $attribute, $options
                            ).
                            CHtml::tag("label", array( ),
                                $model->getAttributeLabel($attribute)
                            )
                        )
                     )
            ) . "\n";    
        }
        return $this->activeItem( $model, $attribute, 
                CHtml::activeCheckBox($model, $attribute, $this->itemOptions($options) )
        ); 
    }
    public function checkBox( $label, $name, $checked=false, $options = array() ){
        
        if ( isset( $options['data-bind']) && strpos($options['data-bind'], "checked:") !== false ) {
            $options['data-bind'] = str_replace("checked:", "iCheck:", $options['data-bind']);
        } else {
            $this->controller->addClass($options, "icheck");            
        }
        return  CHtml::tag("div", array("class" => "checkbox"),
                    CHtml::tag("label", array( ),
                        CHtml::checkBox(
                            $name, $checked, $options
                        ) . $label
                    )
                ). "\n";    
        
    }
    public function formGroup( $items, $size = 0 ){
        if ( $size == 0 ){
            $size = floor( 12 / count( $items ) );
        }
        $result =  CHtml::openTag("div", array( 'class' => "form-group" ) );  
        foreach ( $items as $item ){
            $result .= CHtml::tag("div", array( 'class' => "col-sm-".$size ), $item );
        }
        $result .= CHtml::closeTag("div" );
        return $result;
    }
    public function itemOptions( $options = array() ){
        $this->controller->addClass($options, "form-control");        
        return $options;        
    }
    
    public function activeItemValue( $model, $attribute, $options = array(), $observable = false ){
        
        if ( $observable )
            $options = $this->activeObservable($model, $attribute, $options, $observable , "text");
        $this->controller->addClass($options, 'help-block');
        return $this->activeItem( $model, $attribute, 
                CHtml::tag("span", $options, $model->$attribute ) 
        );             
    }
    
    public function activeItem( $model, $attribute, $item ){
        $class = "form-group clearfix";
        if( $model->hasErrors($attribute) )
            $class .= " has-error";
        if ( $this->noLabel ){
            return $item . "\n";
        } else {
            return CHtml::tag("div", array("class" => $class ), 
                    CHtml::activeLabel($model, $attribute, array("class" => "col-sm-{$this->labelSize} control-label") ). "\n".
                    CHtml::tag("div", array("class" => "col-sm-{$this->inputSize}"), $item ). "\n"
            ) . "\n";           
        }
    }
    protected function getSizes( $items, $label = true ){
        $newSizes = array();
        
        $nbItems = count($items);
        if ( !$label ){
            if ( $nbItems < 12 - $this->labelSize ){
                $newSizes[] = "col-sm-".$this->labelSize;
                $left = 12-$this->labelSize;
            } else {
                $newSizes[] = "col-sm-".(12-$nbItems+1);
                $left = $nbItems-1;
            }
            $nbItems--;
        } else {
            $left = 12-$this->labelSize;
        }
        if ( $nbItems == 1 ){
            $newSizes[] = "col-sm-". $this->inputSize;
            return $newSizes;
        }
        if ( $nbItems == 2 ){
            $newSizes[] = "col-sm-". $this->inputSize/2;
            $newSizes[] = "col-sm-". $this->inputSize/2;
            return $newSizes;
        }
        
        
        $size = round( $left / $nbItems );
        
        for ( $i=0; $i < $nbItems; $i++ ){
            $s = $size;
            if ( $s > $this->inputSize )
                $s = $this->inputSize;
            else if ( $s > $left )
                $s = $left;
            $left -= $s;
            $newSizes[] = "col-sm-$s";
        } 
        return $newSizes;
    }
    public function tableLabel( $labels, $sizes = false ){
        $result = "";
        
        if ( !$labels )
            return $result;
        
        $result .= CHtml::openTag("thead", array( "class" => "no-border" ) );
        $result .= CHtml::openTag("tr" ) ."\n";
        if ( $sizes === false )
            $sizes = $this->getSizes( $labels, false );
            
        foreach( $labels as $idx => $label ){            
            if ( is_array($label) ){
                $l = $label[0];
                $options = $label[1];
                $this->controller->addClass($options, $sizes[$idx]);                
                $result .= CHtml::tag("th", $options, $l );
            } else
                $result .= CHtml::tag("th", array( "class" => $sizes[$idx] ), $label );
        }
        $result .= CHtml::closeTag("tr" ) ."\n";
        $result .= CHtml::closeTag("thead" ) ."\n";
        return $result;
    }
    public function table( $labels, $table, $options = array(), $tableOptions = array(), $rowOptions = array() ){
        $result = "";
        if ( isset( $options['sizes']) ){
            $sizes = $options['sizes'];
            unset( $options['sizes'] );
        } else 
            $sizes = false;
        $this->controller->addClass( $tableOptions, "no-border" );
        
        $result .= CHtml::openTag("table", $tableOptions ) ."\n";
        $result .= $this->tableLabel( $labels, $sizes );
        if ( isset( $options['class'] ) )
            $options['class'] .= " no-border-y";
        else
            $options['class'] = "no-border-y";
        $result .= CHtml::openTag("tbody", $options );            
        foreach( $table as $row ){
            if ( $sizes === false )
                $newSizes = $this->getSizes( $row, false );
            else
                $newSizes = $sizes;
            
            $result .= CHtml::openTag("tr", $rowOptions ) ."\n";
            foreach( $row as $idx => $cell ){                
                if ( is_array($cell) ){
                    $label = $cell[0];
                    $options = $cell[1];
                    $this->controller->addClass($options, $newSizes[$idx]);
                    
                    $result .= CHtml::tag("td", $options, $label );
                } else {
                    $result .= CHtml::tag("td", array( "class" => $newSizes[$idx] ), $cell );
                    
                }
            }
            $result .= CHtml::closeTag("tr" ) ."\n";
        }
        $result .= CHtml::closeTag("tbody" ) ."\n";
        $result .= CHtml::closeTag("table" ) ."\n";
        return $result;
    }
    
    public function items( $label, $items, $sizes = array() ){
        return $this->activeItems( $label, null, $items, $sizes );
    }
    public function activeItems( $model, $attribute, $items, $sizes = array() ){
        $class = "form-group clearfix";
        if( $attribute !== null && $model->hasErrors($attribute) )
            $class .= " has-error";
        if ( count($sizes) == 0 ){
            $newSizes = $this->getSizes( $items , !is_null($model) );                                   
        } else {
            $newSizes = $sizes;                        
        }
        $ret = CHtml::openTag("div", array("class" => $class )) ."\n";
        if ( $attribute !== null ){
            $ret .= CHtml::activeLabel($model, $attribute, array("class" => "col-sm-{$this->labelSize} control-label") );
        } else if (is_object($model) ){
            $newSizes[$idx] .= " col-md-offset-{$this->labelSize}";            
        } else if ( !is_null($model) ){
            $ret .= CHtml::label($model, false, array("class" => "col-sm-{$this->labelSize} control-label") );
        }
        foreach( $items as $idx => $item ){
            $ret .= CHtml::tag("div", array("class" => $newSizes[$idx]. " help-block"), $item );
        }        
        $ret .= CHtml::closeTag("div") . "\n";
        return $ret;                 
    }
    public function formItem( $label, $input, $echo = true ){
        $txt = CHtml::tag("div", array("class" => "form-group"), 
            CHtml::tag("div", array("class" => "col-sm-{$this->labelSize}"), $label ).
            CHtml::tag("div", array("class" => "col-sm-{$this->inputSize}"), $input )            
        ) . "\n";
        if ( $echo )
            echo $txt;
        else
            return $txt;        
    }
    public function tag( $name, $value = "", $options = array(), $close = false ){
        if ( is_array($value) ){
            $this->controller->addOptions($options, $value[1]);
            $value = $value[0];
        }
        $txt =  CHtml::openTag($name, $options ); 
        if ( $value !== "" ){
            $txt .= $value;
        }
        if ( $close  ){
            $txt .= CHtml::closeTag( $name ); ;
        }
        return $txt;
    }
    public function init()
    {
        if ( $this->nbBox == "alert" ){
            $this->nbBox = null;
            $this->labelSize = 8;
            $this->inputSize = 4;
            if ( $this->useForm === null )
                $this->useForm = false;
        } else if ( $this->nbBox && $this->nbBox > 1 ){
            $this->inputSize = 12 - $this->labelSize;
            if ( $this->useForm === null )
                $this->useForm = false;
        }
        if ( $this->useForm === null )
            $this->useForm = true;
        
        if ( $this->desc === null )
            ob_start();
    }
    public function run()
    {
        $idShown = false;
        $useForm = $this->useForm;
        if ( $this->_useFileupload )
            $useForm = true;
        
        if ( $this->desc === null ) {
            $this->desc = ob_get_contents ( );
            ob_end_clean();
        }
        $class = $this->defaultClass;

        if ( $this->dataBind ){
            echo CHtml::openTag("div", array("data-bind"=>$this->dataBind) )."\n";
        }    
        if ( isset( $this->action['post'] ) ) {
            $postOptions = array( 'class' => "");
            if ( is_array( $this->action['post'] ) && isset($this->action['post']['enctype']) ){
                $postOptions['enctype'] = $this->action['post']['enctype'];
                unset( $this->action['post']['enctype'] );
            }
            
            if ( is_array( $this->action['post'] ) && count($this->action['post'])==0 ){
                $this->action['post'] = array( '', '#' => $this->id );
            }
           
            echo CHtml::beginForm(  $this->action['post'], "POST", $postOptions )."\n";
            $useForm = true;
            echo CHtml::hiddenField('SimpleFormId', $this->id )."\n";
        }
        
        if ( $this->nbBox ){       
            $idShown = true;
            echo CHtml::openTag("div", array( "class"=>$this->classes[$this->nbBox], 'id' => $this->id) )."\n";
            echo CHtml::openTag("div", array("class"=>"block-flat widget-block" ))."\n";
        }
        
        
        if ( $this->title ) {
            if ( $this->nbBox ){
                echo CHtml::openTag("div", array( "class" => "header") )."\n";
            } 
            $options = array();
            if ( !$idShown ){
                $options['id'] = $this->id;
            }
            echo $this->tag( "h4", $this->title, $options )."\n";            
            if ( $this->hide ) {                
                echo CHtml::tag("span", array( 
                            'class'=>'btn btn-default btn-sm col-sm-offset-2',
                            'data-toggle' => "collapse",                            
                            'data-target' => "#main".$this->id,
                            'data-toogle-text' => "hide",
                            'onclick' => "var t = $(this).text(); $(this).text( $(this).attr('data-toogle-text') ); $(this).attr('data-toogle-text', t); return true;"
                    ), "show" );
                $useForm = true;
            }            
            echo CHtml::closeTag("h4" )."\n";
            if ( $this->nbBox ){
                echo CHtml::closeTag("div" )."\n";
            }
        }
        if ( $useForm ) {
            echo CHtml::openTag("div", array( 
                "id"=>"main".$this->id,
                'class' => $this->formClass . 
                            ($this->hide?" collapse":"") .
                            ($this->_useFileupload?" fileupload":"")
            ))."\n"; 
        }
        if ( $this->nbBox ){
            echo CHtml::openTag("div", array( "class" => $this->contentClass) )."\n";
        }        
        if ( $this->desc!=="" ) {
            echo CHtml::tag("div", array( ), $this->desc )."\n";
        }
        if ( $this->nbBox && $this->nbBox > 1 ){
            echo CHtml::closeTag("div" )."\n";
        }
        
        if ( $this->button ) {
            $class .= " btn-block";
            echo CHtml::openTag("div", array( 
                'class' => "form-group"
            ));
            if ( $this->nbBox > 1 ) {
                $wrapperClass = "";                
            } else {
                $buttonXS = $this->buttonSize*2;
                $offsetXS = 12 - $buttonXS*(1+ count($this->moreButtons));
                $offsetMD = 12 - $this->buttonSize*(1+ count($this->moreButtons));
                foreach ($this->moreButtons as $button ){
                    $wrapperClass = "col-sm-{$buttonXS} col-md-{$this->buttonSize}";            
                    if ( $offsetMD > 0 ){
                        $wrapperClass .= " col-sm-offset-{$offsetXS} col-md-offset-{$offsetMD}"; 
                    }
                    echo CHtml::tag("div", array( 'class' => $wrapperClass ), $button);                
                    $offsetMD = 0;
                }
                $wrapperClass = "col-sm-{$buttonXS} col-md-{$this->buttonSize}";            
                if ( $offsetMD > 0 ){
                    $wrapperClass .= " col-sm-offset-{$offsetXS} col-md-offset-{$offsetMD}";                     
                }
            }
            echo CHtml::openTag("div", array( 'class' => $wrapperClass ));
             
            if ( is_array( $this->button ) ){
                $label = $this->button[0];
                $options = $this->button[1];
            } else {
                $label = $this->button;
                $options = array();
            }
            $this->controller->addClass( $options, $class );
            
            if ( isset( $this->action['ko'] ) ){
                $ko = 'click: '.$this->action['ko'];
                $this->controller->addDatabind( $options, $ko );                
                if ( isset( $this->action['link'] ) )
                    echo CHtml::link($label, $this->action['link'], $options ) ;
                else 
                    echo CHtml::tag("div", $options, $label ) ;
            } else if ( isset( $this->action['post'] ) ){      
                $options['onclick'] = '$(this).parents("form")[0].submit(); loadButtonWithCheck( $(this) );';
                echo CHtml::tag("div", $options, $label ) ;
            } else if ( isset( $this->action['file'] ) && isset( $this->action['link']) ){
                $options['class'] .= " fileinput-button";                
                $this->registerClientScript();
                echo CHtml::tag("div", $options, 
                        $label . 
                        CHtml::fileField( $this->action['file'], "", array( 
                            "data-bind" => "submitFileUpload: '". CHtml::normalizeUrl( $this->action['link']) ."'"                 
                        ) ) 
                );
            } else if ( isset( $this->action['file'] ) && isset( $this->action['args']) ){
                $options['class'] .= " fileinput-button";                
                $this->registerClientScript();
                echo CHtml::tag("div", $options, 
                        $label . 
                        CHtml::fileField( $this->action['file'], "", array( 
                            "data-bind" => "submitFileUpload: ". $this->action['args']                 
                        ) ) 
                );
            } else if ( isset( $this->action['link'] ) ){
                $options['onclick'] = 'loadButtonWithCheck( $(this) ); return true;';
                echo CHtml::link($label, $this->action['link'], $options ) ;
            } else if ( isset( $this->action['script'] ) ){
                $options['onclick'] = $this->action['script'];
                echo CHtml::tag("div", $options, $label ) ;
            }
            echo CHtml::closeTag("div");
            echo CHtml::closeTag("div");    
            
            if ( $this->clearfix )
                echo CHtml::tag("div", array( 'class'=>'clearfix'), " ");
            
        }
        if ( $this->nbBox === 1 ){
            echo CHtml::closeTag("div" );
        }
        
        if ( $useForm ) {
            echo CHtml::closeTag("div" );
        }
        if ( $this->nbBox ){
            echo CHtml::closeTag("div" );
            echo CHtml::closeTag("div" );
        }
        if ( isset( $this->action['post'] ) ){      
            echo CHtml::endForm();                    
        }
        if ( $this->dataBind ){
             echo CHtml::closeTag("div" );
        }
    }
}
