<?php

/**
 * URLValidator class file.
 */

class SimpleURLValidator extends CValidator {

    /**
     * @var boolean whether the attribute value can be null or empty. Defaults to true,
     * meaning that if the attribute is empty, it is considered valid.
     */
    public $allowEmpty = true;

   /**
    * @var array list of URI schemes which should be considered valid. By default, http and https
    * are considered to be valid schemes.
    **/
    public $validSchemes=array('http','https');
    /**
     * @var boolean whether the attribute value can be a relative path. Defaults to false,
     * meaning that if the attribute is relative path, it is considered not valid.
     */
    public $relativePath = false;

    /**
     * Validates the attribute of the object.
     * If there is any error, the error message is added to the object.
     * @param CModel $object the object being validated
     * @param string $attribute the attribute being validated
     */
    protected function validateAttribute($object, $attribute) {
        $value = $object->$attribute;
        if ($this->allowEmpty && $this->isEmpty($value))
            return;
        if ( $this->isEmpty($value) ){
            $this->addError($object, $attribute, Yii::t('yii','{attribute} cannot be blank.'));
            return false;
        }
        /*
        if ( !filter_var($value, FILTER_VALIDATE_URL) ){
            $this->addError($object, $attribute, '{attribute} is not a valid URL.');
        }
        */
        if ( $this->relativePath ){
            $path = "";
            if ( preg_match("/^[\w\d-]+\/?$/", $value ) ){
                return true;
            }
        }
        if ( $this->validSchemes!==false ) {
            $matches = null;
            $scheme = '/^('.implode('|',$this->validSchemes).'):\/\/([^\[\/:]+|\[[a-fA-F0-9:]+\])(?::\d+)?\/?(.*)/';
            if ( !preg_match($scheme, $value, $matches ) ) {
                $this->addError($object, $attribute, "Scheme of {attribute} is not valid. ( $scheme, $value )");
                return false;                
            } else {
                $host = $matches[2];
                if ( count($matches)>3 ) 
                    $path = $matches[3];
                else
                    $path = "";

                if ( preg_match("/^\[([a-fA-F0-9:]*)\](?::\d*)?$/", $host, $IPv6Match ) ) {
                    if ( !filter_var( $IPv6Match[1], FILTER_VALIDATE_IP, FILTER_FLAG_IPV6) ) {
                        $this->addError($attribute,'Invalid IPv6 format');
                        return false;
                    }
                } else {     
                    $valid = preg_match("/^([a-z\d](-*[a-z\d])*)(\.([a-z\d](-*[a-z\d])*))*\.?$/i", $host) //valid chars check
                    && preg_match("/^.{1,253}$/", $host) //overall length check
                    && preg_match("/^[^\.]{1,63}(\.[^\.]{1,63})*\.?$/", $host); //length of each label
        
                    if ( !$valid && !filter_var( $host, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4) ) {
                        $this->addError($object, $attribute, "Host of {attribute} is not valid.");
                        return false;
                    }
                }                
            }
        } else {
            $path = $value;
        }
        if ( preg_match("/[^\]\-[:\/?&#@*+,;=a-zA-Z0-9._~%!$'\(\)]/",$path ) ){
            $this->addError($object, $attribute, "Path of {attribute} is not valid.");
        }
        
        
    }

}