<?php
class NetworkAction extends CAction
{
    protected function network($ipConfig = null)
    {
        if (!$ipConfig) {
            $ipConfig = new IPConfig();
        }

        if (isset($_POST['IPConfig']['dhcp'])) {
            $ipConfig->setAttributes($_POST['IPConfig']);
            if ($ipConfig->validate() && $ipConfig->checkConfig()) {
                $ipConfig->save();
            }
        } else {
            $ipConfig->load();
        }
        return array(
            'ipConfig' => $ipConfig,
        );
    }
    protected function wifi()
    {
        if (!Yii::app()->branding->hasRight('WIFI')) {
            return array();
        }
        $wifiInfo = new WifiInfo();
        $wifiInfo->load();
        return array(
            'wifiInfo' => $wifiInfo,
        );
    }
    protected function proxy()
    {
        $proxyConfig = new ProxyConfig();
        $proxyConfig->load();
        if (isset($_POST['ProxyConfig'])) {
            $proxyConfig->setAttributes($_POST['ProxyConfig']);
            if ($proxyConfig->validate()) {
                $proxyConfig->save();
            }
        }
        return array(
            'proxyConfig' => $proxyConfig,
        );
    }
    protected function https($playerConfig = null, $simpleFormId = "HTTPS")
    {
        if (!$playerConfig) {
            $playerConfig = new PlayerConfig();
        }

        if ($simpleFormId == "HTTPS" && isset($_POST['PlayerConfig'])) {
            $playerConfig->setScenario('https');

            $playerConfig->setAttributes($_POST['PlayerConfig']);
            if ($playerConfig->validate()) {
                $playerConfig->saveConfig();
            }
        }

        return array(
            'playerConfig' => $playerConfig,
        );
    }
    protected function ssl()
    {
        $sslConfig = new SSLConfig();

        return array(
            'sslConfig' => $sslConfig,
        );
    }
    protected function serverCertificates()
    {
        $serverCertificates = new ServerCertificates();
        if (isset($_POST['ServerCertificates'])) {
            $serverCertificates->setAttributes($_POST['ServerCertificates']);
            $serverCertificates->handleFiles();
        }
        return array(
            'serverCertificates' => $serverCertificates,
        );
    }
    protected function serverSecurity()
    {
        $serverSecurity = new ServerSecurity();
        if (isset($_POST['ServerSecurity'])) {
            $serverSecurity->setAttributes($_POST['ServerSecurity']);
            $serverSecurity->save();
        } else {
            $serverSecurity->load();
        }
        return array(
            'serverSecurity' => $serverSecurity,
        );
    }
    protected function watchdog()
    {
        if (!Yii::app()->branding->hasRight('networkWatchdog')) {
            return array();
        }
        $watchdog = new NetworkWatchdog();
        if (isset($_POST['NetworkWatchdog'])) {
            $watchdog->setAttributes($_POST['NetworkWatchdog']);
            if ($watchdog->validate()) {
                $watchdog->save();
            }
        } else {
            $watchdog->load();
        }
        return array('watchdog' => $watchdog);
    }
    protected function upnp()
    {
        $UPnPConfig = new UPnPConfig();
        if (isset($_POST['UPnPConfig'])) {
            $UPnPConfig->setAttributes($_POST['UPnPConfig']);
            if ($UPnPConfig->validate()) {
                $UPnPConfig->save();
            }
        } else {
            $UPnPConfig->load();
        }
        return array(
            'UPnPConfig' => $UPnPConfig,
        );
    }
    protected function llmnr()
    {
        $LLMNRConfig = new LLMNRConfig();
        if (isset($_POST['LLMNRConfig'])) {
            $LLMNRConfig->setAttributes($_POST['LLMNRConfig']);
            if ($LLMNRConfig->validate()) {
                $LLMNRConfig->save();
            }
        } else {
            $LLMNRConfig->load();
        }
        return array(
            'LLMNRConfig' => $LLMNRConfig,
        );
    }
    protected function bonjour()
    {
        $bonjourConfig = new BonjourConfig();
        if (isset($_POST['BonjourConfig'])) {
            $bonjourConfig->setAttributes($_POST['BonjourConfig']);
            if ($bonjourConfig->validate()) {
                $bonjourConfig->save();
            }
        } else {
            $bonjourConfig->load();
        }
        return array(
            'bonjourConfig' => $bonjourConfig,
        );
    }
    protected function snmp()
    {
        $snmpConfig = new SNMPConfig();
        $snmpConfig->load();
        if (isset($_POST['SNMPConfig'])) {
            $snmpConfig->access = $_POST['SNMPConfig']['access'];
            $snmpConfig->setScenario($snmpConfig->access);
            $snmpConfig->setAttributes($_POST['SNMPConfig']);
            if ($snmpConfig->validate()) {
                $snmpConfig->save();
            }
        }

        return array(
            'snmpConfig' => $snmpConfig,
        );
    }

    static function ntp($ipConfig = null)
    {
        $ntpSettings = new NTPSettings();
        $ntpSettings->load();
        if (isset($_POST['NTPSettings'])) {
            $ntpSettings->setScenario('ntp');
            $ntpSettings->loadTime();

            $ntpSettings->setAttributes($_POST['NTPSettings']);
            if ($ntpSettings->validate()) {
                $ntpSettings->save($ipConfig);
            }
            // TODO: check if this is really necessay
            $ntpSettings->load();
        }

        return array('ntpSettings' => $ntpSettings);
    }

    static function streaming($playerConfig = null, $simpleFormId = "Logging")
    {
        if (!$playerConfig) {
            $playerConfig = new PlayerConfig();
        }
        $logsInfo = new LogsInfo();
        $logsInfo->loadStreaming();

        if ($simpleFormId == "Logging" && isset($_POST['PlayerConfig'])) {
            $playerConfig->setScenario('player');
            $playerConfig->setAttributes($_POST['PlayerConfig']);
            if ($playerConfig->validate()) {
                $playerConfig->saveConfig();
            }
        } else {
            $playerConfig->loadStreamValues();
        }

        return array(
            'logsInfo' => $logsInfo,
            'playerConfig' => $playerConfig,
        );
    }

    public function run()
    {
        $simpleFormId = isset($_POST['SimpleFormId'])
            ? $_POST['SimpleFormId']
            : "";

        $playerConfig = new PlayerConfig();
        $ipConfig = new IPConfig();
        $ipConfig->loadIP();
        $options = array(
            'basicInfo' => new BasicInfo(),
            'wiredAuthInfo' => getWiredAuthInfo(),
        );
        $options += self::network($ipConfig);
        $options += self::wifi();
        $options += self::proxy();
        $options += self::https($playerConfig, $simpleFormId);
        $options += self::ssl();
        $options += self::serverCertificates();
        $options += self::serverSecurity();
        $options += self::watchdog();
        $options += self::snmp();
        $options += self::upnp();
        $options += self::llmnr();
        $options += self::bonjour();
        $options += self::ntp($ipConfig);
        $options += self::streaming($playerConfig, $simpleFormId);
        $options += SystemAction::hardwareSetup();

        $this->controller->render('network', $options);
    }
}
