<?php
/* @var $this OperationController */

$form = $this->beginWidget('SimpleForm', array( 
    'title' => "Logging",    
    'id' => "Logging",    
    'button' => "Apply",
    'action' => array( 'post' => array( ), )
) );

    if ( Yii::app()->branding->hasRight('streaming') ) {
        echo BsHtml::alert( BsHtml::ALERT_COLOR_WARNING,
                "In case of problems when streaming video or audio to the ".Yii::app()->branding->product.
                ", it is possible to capture stream packets to help ".Yii::app()->branding->vendor." diagnose the problem and find possible solutions.". " ".
                "Be aware that the capture stream packets option will create large files on the internal storage of the device, and should not be left enabled for a long period of time.". " ".
                (count($logsInfo->streaming)>0?"<span data-bind='visible:hasStream'>Make sure you clear all the stream captures once the debugging is over so as to free space on the internal storage of the device.</span>":""),
                array( 'closeText' => false)
        );
    }
    
    if ( count($logsInfo->streaming)>0 ) {
        $streams = "";
        foreach ($logsInfo->streaming as $name ) {
            $streams .= CHtml::tag("span", array(), CHtml::link( CHtml::encode($name), "/capture/".$name ))."<br/>\n" ;
        }
        
        $this->widget('BsRow', array(
                    'options' => array( 'data-bind' => 'visible: hasStream', 'class' => 'spx-align-bottom-container'),
                    'cols' => array( 
                        array( 'size' => 6, 
                            'content'=> "<label class='control-label col-xs-12'>Files</label>"
                        ),
                        array( 'sizes' => array( 'xs' => 6, 'md' => 3),
                            'content'=> $streams
                        ),
                        array( 'sizes' => array( 'xs' => 12, 'sm' => 6, 'md' => 3), 
                                'offsets' => array( 'sm' => 6, 'md' => 0, 'lg' => 0),
                            'options' => array( 'class' => 'spx-align-bottom-item' ),
                            'content' => $this->widget('ActionButton', array(                                 
                                'label' =>'Clear Files',
                                'options' => array( 'class' => 'spx-align-bottom' ),
                                'block' => true, 
                                'link' => array("operation/reset", 'targets[]'=>'streaming', ),
                                'ko' => 'doClearStreams'
                                ), true )
                        )
                    ) )
        );        

        $this->observable("hasStream", count($logsInfo->streaming)>0 );
    }

    if ( Yii::app()->branding->hasRight('streaming') ) {
        echo $form->activeCheckBox( $playerConfig, 'debugstream', array( "uncheckValue"=>"off", "value"=>"on" ) );
    }

    echo $form->activeCheckBox( $playerConfig, 'httpLogs', array( "uncheckValue"=>"", "value"=>"network" ) );

$this->endWidget();
?>
<script type="text/javascript" >
//<![CDATA[
yiiModel.doClearStreams = function( model, ev ) {
    yiiModel.doAjaxButton( model, ev, 
        function( ev, response ) {
            if ( response.success ){
                model.hasStream( false )
            }
        }
    );
};
//]]></script>   

