<?php

/*
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

 * Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials provided
  with the distribution.

 * Neither the name of SpinetiX S.A. nor the names of its
  contributors may be used to endorse or promote products derived
  from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
  COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Description of Helpers
 *
 * @author jr
 */
class Helpers {
    
    static function createApps( $test, $name='test', $desc="dummy", $widgets = null, $data=null ) {
        $attributes = array (
            'name' => $name,
            'keywords' => array( 'test', 'auto' )
        );
        
        $folder = sys_get_temp_dir() ."/". uniqid( "apps", true ) ."/" ;
        if ( !$widgets ) {
            $widgets = array(
                array( )
            );
        }
        mkdir( $folder );
        mkdir( $folder ."widgets/" );
        
        $svg = <<<SVGDATA
<?xml version="1.0" encoding="UTF-8" ?>
<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><text y="128">$name</text></svg>
SVGDATA;
        file_put_contents($folder."icon.svg", $svg);
        
        
        if ( isset( $data['values']) ){
            $attributes['values'] = $data['values'];
            unset( $data['values'] );
        }
        
        $config = array();
        $config['desc'] = $desc;
        $config['data'] = $data;
        $config['widgets'] = array();
        
        foreach ( $widgets as $widget ){            
            $config['widgets'][] = self::createWidget( $folder, $widget );
        }
        file_put_contents($folder."apps.json", json_encode($config) );  
        if ( $data !== null ){
            mkdir( $folder ."interface/" );
            file_put_contents($folder ."interface/" ."index.html", " " );  
        }
        $apps = array(
            'format' => '7z',
            'folder' => $folder
        );
            
        $model = new Apps;
        $model->attributes = $attributes;
        $model->setAppsFile( $apps );
        $test->assertTrue( $model->save() );        
        
        $checkData = array();
        $checkData['id'] = $model->id;
        $checkData['name'] = $name;
        $checkData['desc'] = $desc;
        $checkData['data'] = $data;
        foreach ( $widgets as $idx => $widget ){
            $checkData['widgets'][$config['widgets'][$idx]] = $widgets;
            $checkData['widgetIds'][] = $config['widgets'][$idx];
        }
        $checkData['model'] = $model;
        
        return $checkData;
    }
    static function removeApps( $test, $id, $checkParent = false ) {
        $model = Apps::model()->findByPk( $id );
        $test->assertNotSame( null, $model, "id = $id" );
        
        if ( $checkParent ){
            $test->assertArrayNotHasKey( 'parents', $model->desc );
        }
        
        $test->assertTrue( $model->delete(), print_r( $model->errors, true ) );
        
        $folder = $model->folder;
        $test->assertFalse( file_exists( $folder ) );
    }
    
    static function createWidget( $appsFolder, $widget = array() ) {
        $widgetId = uniqid( "test" );
        $folder = $appsFolder ."widgets/$widgetId/";
        
        mkdir( $folder );
        
        if ( isset( $widget['name']) ){
            $name = $widget['name'];
        } else 
            $name = "";
        if ( isset( $widget['viewBox']) ){
            if ( $widget['viewBox']==="" )
                $viewBox = "";
            else
                $viewBox = " viewBox='".$widget['viewBox']."'";
        } else 
            $viewBox = " viewBox='0 0 1280 720'";;
        if ( isset( $widget['desc']) ){
            $desc = $widget['desc'];
        } else 
            $desc = "";
        if ( isset( $widget['json']) ){
            $json = $widget['json'];            
        } else 
            $json = true;
        if ( isset( $widget['options']) ){
            $options = $widget['options'];
        } else 
            $options = array();
        $debug = print_r( $widget, true );
        $svg = <<<SVGDATA
<?xml version="1.0" encoding="UTF-8"?>
<svg xmlns="http://www.w3.org/2000/svg" xmlns:spx="http://www.spinetix.com/namespace/1.0/spx" xmlns:xlink="http://www.w3.org/1999/xlink" $viewBox>
<title id="title">$name</title><desc id="desc">$desc</desc>
<spx:properties>
SVGDATA;
        foreach ( $options as $query=>$option ) {
            $type = $option['type'];
            if ( $json )
                $type = "json-".$type;
            $svg .= "<spx:$type query='$query' name='".$option['name']."' ";
            if ( isset( $option['desc'] ) )
                $svg .= "desc='".$option['desc']."' ";
            if ( $option['type']==='choice' ) {
                foreach ( $option['select'] as $i=>$item ){
                    if ( $i < 10 ){
                        $idx = "0".($i+1);
                    } else {
                        $idx = "".($i+1);
                    }
                    $svg .= "choice-".$idx."='".$item['value']."' ";
                    if ( isset( $item['name'] ) ){
                        $svg .= "name-".$idx."='".$item['name']."' ";                        
                    }
                }
                
            }
            $svg .= "/>\n";
        }
        $svg .= <<<SVGDATA
</spx:properties>
$debug
</svg>
SVGDATA;
        file_put_contents($folder."widget.svg", $svg); 
        return $widgetId;
    }
    
    static function createMedia( $test, $name, $options=null ) {         
        $data = array (
            'name' => $name,
            'keywords' => array( 'test', 'auto' )
        );
        if ( !$options )
            $options = array( 'format' => 'jpg', 'width'=>100, 'height'=>100, );
        
        
        $resource = new Resource;
        $resource->attributes = $data;
        $resource->type = "media";
        $test->assertTrue( $resource->save() );
            
        $model = new Media;
        $model->id = $resource->id;
        $model->processFile( $options );
        
        $test->assertTrue( $model->save() );
        return $model->id;
        
    }
    static function removeMedia( $test, $id, $checkParent = false ) {
        $model = Media::model()->findByPk( $id );
        $test->assertInstanceOf( 'Media', $model, "\n".$id."\n" );
        if ( $checkParent ){
            $test->assertArrayNotHasKey( 'parents', $model->desc );
        }
        $test->assertTrue( $model->delete() );
    }
    
    static function createPlaylist( $test, $name ) {         
        $data = array (
            'name' => $name,
            'keywords' => array( 'dummy' )
        );
        
        $model = new Playlist;
        $model->attributes = $data;
        
        $test->assertTrue( $model->save() );
        return $model->id;
        
    }
    static function removePlaylist( $test, $id, $checkParent = false ) {
        $model = Playlist::model()->findByPk( $id );
        $test->assertInstanceOf( 'Playlist', $model );
        if ( $checkParent ){
            $test->assertArrayNotHasKey( 'parents', $model->desc );
        }
        $test->assertTrue( $model->delete() );
    }
    
    
    
    static function checkKeywords( $test, $desc, $data=null, $name="" ){
        $test->assertArrayHasKey( 'keywords', $desc, $name );
        $test->assertTrue( is_array($desc['keywords']), $name );
        if ( $data && isset( $data['keywords'] ) ) {
            foreach( $desc['keywords'] as $keyword ) {
                $test->assertTrue( in_array($keyword, $data['keywords']), 
                        $name ." \n". print_r($desc['keywords'], true).
                        print_r($data['keywords'], true) );
            }
            foreach( $data['keywords'] as $keyword ) {
                $test->assertTrue( in_array($keyword, $desc['keywords']), 
                        $name." \n". print_r($desc['keywords'], true).
                        print_r($data['keywords'], true) );
            }
        }
    }
    static function checkPreviews( $test, $previews, $name="" ){
        $test->assertTrue(is_array( $previews ), $name );
        $test->assertTrue( count( $previews )>0, "Expecting at least 1 preview".$name );
        foreach ( $previews as $preview ){
            $test->assertArrayHasKey( 'type', $preview , $name);
            if ( $preview['type']!='icon' && $preview['type']!='preview' 
                 && $preview['type']!='widget' && $preview['type']!='slide' )
            {
                $test->assertArrayHasKey( 'size', $preview, $name );
                $test->assertArrayHasKey( 'time', $preview, $name );            
            }
            $test->assertArrayHasKey( 'uri', $preview, $name );
        }
        
        // check that previews exists
        $len = strlen( GlobalSettings::$uriBase );
        foreach ( $previews as $preview ){
            $path = GlobalSettings::$fileBase . substr($preview['uri'], $len );
            $test->assertTrue( file_exists( $path ), 
                    "file $path do not exist\n" );
        }
        
    }
    static function checkOptions( $test,$options, $data, $info = null ){
        if ( $info === null )
             $info = print_r($options, true);
        foreach ( $options as $cols =>$option ) {
            $d = null;
            if ( $data ) {
                $test->assertArrayHasKey( $cols, $data, $info );
                $d = $data[$cols];
            }
            Helpers::checkOption( $test, $option, $d, $info );            
        }
        if ( $data ) {
            foreach ( $data as $cols =>$option ) {
                $test->assertArrayHasKey( $cols, $options, $info );
            }
        }
    }
    static function checkValues( $test, $options, $values, $data ){
        //echo "\noptions:".print_r( $options, true )."\nvalues:".print_r( $values, true )."\ndata:".print_r( $data, true ) ."\n";
        if ( $data ) {
            $test->assertEquals( count( $data ), count( $values ) );
        }
        foreach ( $values as $idx => $rows ) {            
            if( $data )
                $dataRow = $data[$idx];
            else 
                $dataRow = null;
            
            foreach ( $rows as $cols =>$value ) {
                $test->assertArrayHasKey( $cols, $options );
                $option = $options[$cols];
                
                if ( $option['type']==='media' || $option['type']==='playlist' ) {
                    
                    $test->assertNotSame( null, $value );
                    $test->assertTrue( is_array( $value ), print_r( $value, true) );
                    if ( $option['type']==='media' ) 
                        Helpers::checkMediaItem( $test, $value );
                    else {
                        Helpers::checkPlaylist( $test, $value );  
                    }
                    if ( $dataRow && isset( $dataRow[$cols] ) ) {
                        $dataMedia = $dataRow[$cols];
                        $test->assertNotSame( null, $dataMedia, print_r( $dataMedia, true ) );
                        $test->assertTrue( is_array( $dataMedia ), print_r( $dataMedia, true) );
                        if ( $option['type']=='media' ) {
                            $test->assertArrayHasKey( 'id', $dataMedia );                            
                            $test->assertEquals($dataMedia['id'], $value['id'] );
                        }
                    }                    
                } else {
                    if ( $dataRow && isset( $dataRow[$cols] ) ) {
                        $test->assertEquals($dataRow[$cols], $value );
                    }
                }                            
            }            
        }
        if ( $data ) {
            foreach ( $data as $idx => $rows ) {
                $rowVal = $values[$idx];
                foreach ( $rows as $cols =>$d ) {
                    $test->assertArrayHasKey( $cols, $rowVal );
                }                
            }
        }
    }
    
    static function checkAppsListDesc( $test, $desc, $data=null ){
        
        $name = print_r( $desc, true );
        
        $test->assertArrayHasKey( 'id', $desc, $name );
        
        $test->assertArrayHasKey( 'name', $desc, $name );
        $test->assertArrayHasKey( 'desc', $desc, $name );
        
        $test->assertArrayHasKey( 'type', $desc, $name );
        $test->assertEquals($desc['type'], "apps" );
        
        Helpers::checkKeywords( $test, $desc, $data, $name );
        
        $test->assertArrayHasKey( 'icon', $desc, $name );
        $test->assertEquals(
                GlobalSettings::$uriBase."apps/".$desc['id']."/icon.svg", 
                $desc['icon'], $name );
        
        $test->assertArrayHasKey( 'manage', $desc, $name );
        $test->assertEquals(
                GlobalSettings::$uriBase."apps/".$desc['id']."/", 
                $desc['manage'] );
        
        $test->assertArrayHasKey( 'uri', $desc, $name );
        
        if ( $data ) {
            $test->assertEquals($data['id'], $desc['id'], $name );
            $test->assertEquals($data['name'], $desc['name'], $name );                    
        }
        
        // check that the file exist
        $path = GlobalSettings::$fileBase . "apps/".$desc['id']."/apps.json";
        $test->assertTrue( file_exists( $path ), 
                "file $path do not exist\n" );
    }
    
    static function checkAppsDesc( $test, $desc, $inputData=null, $info = null ){
        if ( $info === null )
             $info = print_r($desc, true);
        self::checkAppsListDesc( $test, $desc, $inputData );
        $name = print_r( $desc, true );
        
        $test->assertArrayHasKey( 'widgets', $desc, $name );
        $widgets = $desc['widgets'];
        $test->assertTrue(is_array( $widgets ), $name );
        foreach ( $widgets as $widgetId => $widget ){
            Helpers::checkWidget( $test, $widgetId, $widget, $inputData );            
        }
        $test->assertArrayHasKey( 'data', $desc, $name );
        if ( $desc['uri'] === null ){
            $test->assertNull( $desc['data'], $desc, $name );
        } else {
            $data = $desc['data'];
            
            $test->assertTrue(is_array( $data ), $name );            
            //$test->assertArrayHasKey( 'max', $data, $name );
            $test->assertArrayHasKey( 'options', $data, $name );
            $options = $data['options'];
            $test->assertTrue(is_array( $options ), $name );
            self::checkOptions( $test, $options, 
                $inputData&&isset($inputData['options'])?$inputData['options']:null, 
                $info );
                        
            $test->assertArrayHasKey( 'values', $data, $name );
            $values = $data['values'];
            $inputValues = null;
            if ( isset($inputData['data']) && isset($inputData['data']['values']) )
                $inputValues = $inputData['data']['values'];
            $test->assertTrue(is_array( $values ), $name );            
            self::checkValues( $test, $options, $values, $inputValues );
            
            
            $test->assertArrayHasKey( 'variable', $data, $name );
            
        }                
    }
    
    
    static function checkPlaylistOptions( $test, $options, $name="" ){
        $name .= "\n".print_r($options, true);
        
        $test->assertTrue(is_array( $options ), $name );
        
        $test->assertArrayHasKey( 'defaultDur', $options, $name );
        $test->assertInternalType('numeric', $options['defaultDur'], $name );
        
        $test->assertArrayHasKey( 'transition', $options, $name );
        if ( $options['transition']!==null ){            
            $test->assertTrue(is_array( $options['transition'] ), $name );
            $transition = $options['transition'];
            $test->assertArrayHasKey( 'ctor', $transition, $name );
            $test->assertArrayHasKey( 'args', $transition, $name );
        } 
        
        $test->assertArrayHasKey( 'looping', $options, $name );
        $test->assertInternalType('bool', $options['looping'], $name );
        
        $test->assertArrayHasKey( 'shuffle', $options, $name );
        $test->assertInternalType('bool', $options['looping'], $name );        
    }
    static function checkZone( $test, $zones, $name="" ){
        $test->assertTrue(is_array( $zones ) );
        foreach ( $zones as $zone) {
            $test->assertArrayHasKey( 'beginTime', $zone );
            $test->assertRegExp(
                        "/^\d{2}\:\d{2}(\:\d{2})?(\.\d*)?Z?$/",
                        $zone['beginTime'], $name
                        );
            $test->assertArrayHasKey( 'endTime', $zone );
            $test->assertRegExp(
                        "/^\d{2}\:\d{2}(\:\d{2})?(\.\d*)?Z?$/",
                        $zone['endTime'], $name
                        );
            $test->assertArrayHasKey( 'beginDay', $zone );
            $test->assertRegExp(
                        "/^[0-6]$/",
                        (string)$zone['beginDay'], $name
                        );
            $test->assertArrayHasKey( 'endDay', $zone );
            $test->assertRegExp(
                        "/^[0-6]$/",
                        (string)$zone['endDay'], $name
                        );
        }
    }
    static function checkSchedule( $test, $schedule, $name="" ){
        if ( isset( $schedule['beginDate'] )){
            $test->assertRegExp(
                    "/^\d{4}-\d{2}-\d{2}T\d{2}\:\d{2}(\:\d{2})?(\.\d*)?Z?$/",
                    $schedule['beginDate'], $name
                    );
        }
        if ( isset( $schedule['endDate'] )){
            $test->assertRegExp(
                    "/^\d{4}-\d{2}-\d{2}T\d{2}\:\d{2}(\:\d{2})?(\.\d*)?Z?$/",
                    $schedule['endDate'], $name
                    );
        }
        if ( isset( $schedule['validityZones'] )){
           self::checkZone( $test, $schedule['validityZones'], $name );
        }
        if ( isset( $schedule['exclusionZones'] )){
           self::checkZone( $test, $schedule['exclusionZones'], $name );
        }
    }
    static function checkMediaItem( $test, $media, $name="" ){
        $name .= "\nmedia:\n".print_r($media, true);
        $test->assertArrayHasKey( 'id', $media, $name );
        $test->assertArrayHasKey( 'type', $media, $name );
        $test->assertArrayHasKey( 'href', $media, $name );
        $test->assertArrayHasKey( 'manage', $media, $name );
        
        if ( isset( $media['dur'] )){
            $test->assertInternalType('numeric', $media['dur'], $name );
        }
        if ( isset( $media['schedule'] )){
            self::checkSchedule( $test, $media['schedule'], $name );            
        }
        if ( $media['type']=='apps' ){
            $test->assertArrayHasKey( 'widgetId', $media, $name );
            $test->assertArrayHasKey( 'apps', $media, $name );
            $apps = $media['apps'];
            
            Helpers::checkAppsDesc( $test, $apps );
            $widgetId = $media['widgetId'];
            $widgets = $apps['widgets'];
            $test->assertArrayHasKey( $widgetId, $widgets, $name );
            $widget = $widgets[$widgetId];
            if ( isset( $media['query'] )){
                $query = $media['query'];
                
                Helpers::checkQuery( $test, $query, $widget['options'] );                
                
                if ( $apps['data'] ){
                    $query['variable'] = $apps['data']['variable'];
                }
                Helpers::checkHrefQuery( $test, $media['href'], $query  );
            }
        }
        
    }
    static function checkPlaylist( $test, $desc, $name="" ){
        
        $test->assertArrayHasKey( 'options', $desc, $name );
        Helpers::checkPlaylistOptions( $test, $desc['options'], $name );
        
        $test->assertArrayHasKey( 'media', $desc, $name );
        $test->assertTrue(is_array( $desc['media'] ), $name );
        foreach ( $desc['media'] as $media ){
            Helpers::checkMediaItem( $test, $media, $name );
        }
    }
    
    static function checkParent( $test, $parent, $name="" ){
        $test->assertArrayHasKey( 'id', $parent, $name );
        $test->assertArrayHasKey( 'name', $parent, $name );
        $test->assertArrayHasKey( 'type', $parent, $name );
        $test->assertArrayHasKey( 'manage', $parent, $name );
    }
    
    static function checkMediaParents( $test, $desc, $parent_id, $name="" ){
        $test->assertArrayHasKey( 'parents', $desc, $name );
        $test->assertEquals( 1, count( $desc['parents'] ), print_r($desc, true) );
        self::checkParent( $test, $desc['parents'][0], $name );
        $test->assertEquals( $parent_id, $desc['parents'][0]['id'], $name );
        
    }
    static function checkArgs( $test, $args ){
        $test->assertTrue(is_array( $args ) );
        $mendatory = array( 'top', 'left', 'width', 'height' );
        foreach ($mendatory as $m ){
            $test->assertArrayHasKey( $m, $args );
        }        
    }
    
    static function checkQuery( $test, $query, $options ){
        $test->assertTrue( is_array( $query ), print_r($query, true) );
        foreach ( $query as $name=>$value ) {
            $test->assertArrayHasKey( $name, $options, "\nQuery not found in options\n".print_r($options, true) );
            //should also check the $value
        }
    }
    static function checkHrefQuery( $test, $href, $query ){
        if ( count($query) == 0 ) 
            return;
        $uri = explode("?", $href, 2);
        $test->assertEquals(2, count( $uri ), "\nMissing query in ".$href."\n".print_r($query, true) );
        $queryString = explode("&", $uri[1] );
        $test->assertEquals(count( $query ), count( $queryString ), "\nQuery string error\n".print_r($queryString, true).print_r($query, true) );
        foreach ( $queryString as $string ) {
            $q = explode("=", $string );
            $test->assertEquals(2, count( $q ) );
            $test->assertArrayHasKey( urldecode( $q[0] ), $query, "\nQuery not found in query\n".print_r($query, true) );
            $test->assertEquals( urldecode( $q[1] ), $query[ urldecode($q[0]) ], "\nQuery do not match value\n".print_r($query, true) );            
        }        
    }
    
    static function checkOption( $test, $option, $data=null, $info=null ){
         if ( $info === null )
             $info = print_r($option, true);
         $test->assertArrayHasKey( 'name', $option, $info );
         $test->assertArrayHasKey( 'type', $option, $info );
         $test->assertTrue( in_array($option['type'], array(
             'media', 'playlist', 'string', 'text', 'number', 'boolean', 
             'choice', 'color', 'date', 'time', 'datetime'
            )), "\nUnknown type ".$option['type'] );
         
         
         if ( $option['type']==='number' ) {
             // optional min and max
         }
         if ( $option['type']==='boolean' ) {
             // optional true and false
         }
         if ( $option['type']==='choice' ) {
             $test->assertArrayHasKey( 'select', $option, $info );
             $select = $option['select'];
             foreach ( $select as $item ){
                $test->assertArrayHasKey( 'value', $item, $info );
             }
         }
         if ( $data ){             
             $test->assertEquals($data['name'], $option['name'] );
             $test->assertEquals($data['type'], $option['type'] );
             if ( isset( $data['apps'] ) ){
                 $test->assertArrayHasKey( 'apps', $option );
                $test->assertEquals($data['apps'], $option['apps'] );
             }
             if ( isset( $data['desc'] ) )
                $test->assertEquals($data['desc'], $option['desc'] );
             if ( isset( $data['variable'] ) ){
                $test->assertArrayHasKey( 'variable', $option );
                $test->assertEquals($data['variable'], $option['variable'] );
             }
             
             if ( $data['type']=='choice' ) {
                 $test->assertEquals( count( $data['choices'] ), count( $option['choices'] ) );
                 for ( $i=0; $i<count( $data['choices'] ); $i++ ) {
                     $test->assertEquals($data['choices'][$i], $option['choices'][$i] );
                 }
             }
         }
    }
    
    static function checkWidget( $test, $widgetId, $widget, $data = null ){
        
        $name = "\nid: ".$widgetId."\n" . print_r($widget, true) ."\n" ;
        
        $test->assertArrayHasKey( 'name', $widget, $name );
        $test->assertArrayHasKey( 'desc', $widget, $name );
        $test->assertArrayHasKey( 'href', $widget, $name);
        //$test->assertArrayHasKey( 'type', $widget, $name);
        if( isset($widget['type']) ) {
            $type = $widget['type'];
            $test->assertTrue( $type === 'layer' ||  $type === 'slide' , $name);
        }
        $test->assertArrayHasKey( 'preview', $widget, $name );
        $test->assertArrayHasKey( 'options', $widget, $name );
        
        if ( $data && isset( $data['widgets'] ) && isset( $data['widgets'][$widgetId] ) )
            $widgetData = $data['widgets'][$widgetId];
        else
            $widgetData = false;
            
        foreach ( $widget['options'] as $query=>$option ){
            if ( $widgetData && isset( $widgetData['options'] ) && isset( $widgetData['options'][$query] ) )
                self::checkOption( $test, $option, $widgetData['options'][$query] );
            else
                self::checkOption( $test, $option );
        }
        if ( $data ){                        
            $test->assertEquals(
                    GlobalSettings::$hrefBase."apps/".$data['id']."/widgets/$widgetId/widget.svg", 
                    $widget['href'] );
        }
        if ( $widgetData && isset( $widgetData['name'] ))
            $test->assertEquals($widgetData['name'], $widget['name'] );
        
        // check that the file exist
        $len = strlen( GlobalSettings::$hrefBase );
        $path = GlobalSettings::$fileBase . substr($widget['href'], $len );
        $test->assertTrue( file_exists( $path ), 
                "file $path do not exist\n" );
        
    }
}
