<?php

Yii::import('application.modules.api.models.*');
Yii::import('application.modules.api.components.*');

class AppsController extends Controller
{
    public $defaultAction = 'list';

    public function accessRules()
    {
        $rules = array(      
            array('allow',  
                'actions' => array( "list" ),
                'roles'=>array('useApps'),
            ),
            array('allow',  
                'actions' => array( "edit" ),
                'roles'=>array('editApps'),
            ),
            array( 'deny' )           
        );        
        return $rules;
    }
    
    public function actionEdit( $id, $sv = "spx" )
	{
        $apps = Apps::model()->findByPk($id);
        if ( $apps === null )
            throw new CHttpException(404, "No apps fopr id=".$id);
        
        $this->render('edit', array( 
            'apps' => $apps,
            'variable' => $sv
        ));
        
	}
    
	public function actionList()
	{        
		$this->render('list');
	}
    
}