#!/bin/bash
#
#  Copyright 2006 by Texas Instruments Incorporated.
#  
#  Modifications (C) 2007 SpinetiX S.A.
#  
#  All rights reserved. Property of Texas Instruments Incorporated.
#  Restricted rights to use, duplicate or disclose this code are
#  granted through contract.
#  
#

#
# Function to load the hardware type into HARDWARE variable
#
function load_hardware
{
    local tag sep val
    HARDWARE=
    while read tag sep val; do
	if [ "$tag" = "Hardware" ]; then
	    HARDWARE="$val"
	    return 0
	fi
    done < /proc/cpuinfo
    echo "Could not find hardware type" >&2
    return 1
}

#
# Main
#

# Set a known path, /usr/local/{bin,sbin} may be missing
export PATH=/usr/local/bin:/usr/bin:/bin:/usr/local/sbin:/usr/sbin:/sbin

# Load hardware type
load_hardware || exit 1

if [ "$HARDWARE" = "ti8148evm" ] || [ "$HARDWARE" = "ikebana" ]; then

    # unload vpss and all modules dependent on it
    vpssmods=`awk '$1 == "vpss" {if ($4 != "-") gsub(/,/, " ", $4); else $4=""; print $4, $1}' /proc/modules`
    [ -n "$vpssmods" ] && modprobe -r $vpssmods
    if grep -q '^syslink[[:space:]]' /proc/modules; then
	if slaveloader list | grep -q "VPSS-M3 \[Running\]"; then
	    slaveloader shutdown VPSS-M3 > /dev/null
	fi
	modprobe -r syslink
    fi
    # Wait some time to correctly unload syslink. 5 sec seem to be enough.
    sleep 5

else

    grep -q '^dsplinkk[[:space:]]' /proc/modules && modprobe -r dsplinkk
    rm -f /dev/dsplink

fi

grep -q '^cmemk[[:space:]]' /proc/modules && modprobe -r cmemk
#
#  @(#) codec_engine_1_02 1,0,0,147 7-14-2006 ce-d14
#

