#!/bin/sh
#
# Sets the system and RTC time based on an time offset file, if present.
#

# This must be performed before the NTP daemon is started and before
# network is started, otherwise there are race conditions between NTP
# and us and we may end up with an unknown time and/or disabling the
# auto-update mode of NTP, even if NTP is set up to just loopback mode
# from the system time without an external reference clock.

# The file where the time offset is stored
OFFSET_FILE=/var/spool/spxutils/dateadjust

case "$1" in
    start|restart)
    if [ -f "$OFFSET_FILE" ]; then
	echo -n "Setting date: "
	OFFSET="$(< "$OFFSET_FILE" )"
	rm -f "$OFFSET_FILE"
	if [ -f "$OFFSET_FILE" ]; then
	    echo "failed removing offset file, cannot set date."
	    exit 1
	fi
	echo -n "system"
	date -s "$OFFSET" > /dev/null
	if [ $? -ne 0 ]; then
	    echo " failed."
	    exit 1
	fi
	echo -n ", RTC"
	spxrtc -f > /dev/null
	if [ $? -ne 0 ]; then
	    echo " failed."
	    exit 1
	fi
	echo "."
    fi
    ;;
    stop|reload|force-reload)
    ;;
esac



