<?php


class UserRights extends CFormModel
{
	protected static $rights = null;
    protected $_modified = false;
    public $id = 0;
    public $default = true;
    
    public function init() {
        if ( self::$rights == null ){
            self::$rights = array();
            // get the list of rights with type 
            $auth=Yii::app()->authManager;
            $roles = $auth->getRoles();        
            foreach ( $roles as $role ){
                if ( in_array($role->name, $auth->defaultRoles ) )
                    continue;
                self::$rights[$role->name] = $role;
            }
        }
        /*
        $tasks = $auth->getTasks();        
        foreach ( $tasks as $task ){
            self::$rights[$task->name] = $task;
        }
        */
    }
	/**
	 * Declares the validation rules.
	 * The rules state that username and password are required,
	 * and password needs to be authenticated.
	 */
	public function rules()
	{
        $rules = array();
        foreach ( self::$rights as $name => $item ){
            $rules[] = array( $name, 'boolean' );
        }
        return $rules;
	}

	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
        $rightsNameMap = array(
            "Content" => "Content authoring",
            "Monitoring" => "Monitoring",
            "Administrator" => "Admin",
            "Advanced" => "Advanced",
        );
		$labels = array();
        foreach ( self::$rights as $name =>$item ){
            if ( isset($rightsNameMap[$item->description])){
                $labels[$name] = $rightsNameMap[$item->description];
            } else {
                $labels[$name] = $item->description;
            }
        }
        $labels['default'] = "Read-only access";
        $labels['title'] = "User Rights";
        return $labels;
	}
    
    public function getAllRights()
	{
        $rights = array();
        foreach ( self::$rights as $name => $item ){
            $rights[$name] = array( 'desc' => $item->description,
                    'includes' => array(),
                    'depends' => array());
            foreach ( self::$rights as $n2 => $i2) {
                if ( $n2 == $name )
                    continue;
                if ( $item->hasChild( $n2 ) ){
                    $rights[$name]['includes'][] =  $n2;                    
                }                
            }
        }
        foreach ( self::$rights as $name => $item ){
            foreach ($rights[$name]['includes'] as $n2) {
                foreach ( $rights[$n2]['includes'] as $n3 ){
                    if ( !in_array($n3, $rights[$name]['includes']) ){
                        $rights[$name]['includes'][] = $n3;
                    }
                }                
            }
            foreach ($rights[$name]['includes'] as $n2) {
                if ( !in_array($name, $rights[$n2]['depends']) ){
                    $rights[$n2]['depends'][] = $name;
                }
            }
        }
		return $rights;
	}
    public function getUserRights()
	{
        $rights = array();        
        foreach ( self::$rights as $name => $item ){
            $rights[$name] = $item->isAssigned( $this->id );
        }
		return $rights;
	}
    public function getActiveGroups()
	{
        $rights = array();        
        foreach ( self::$rights as $name => $item ){
            if ( $item->isAssigned( $this->id ) ){
                $rights[] = $name;            
            }
        }
		return $rights;
	}
    
	public function __get($name)
    {

        if ( isset(self::$rights[$name]) ){
            return self::$rights[$name]->isAssigned( $this->id );
        } else {
            return parent::__get($name);
        }
    }
    public function __set($name,$value)
    {
        if ( isset(self::$rights[$name]) ){
            $item = self::$rights[$name];
            $id = $this->id;            
            if ( $value != $item->isAssigned( $this->id ) ){
                $this->_modified = true;
                if ( $value ){
                    $item->assign( $id );
                } else {
                    $item->revoke( $id );
                }
            } 
        } else {
            return parent::__set($name,$value);
        }
    }
    public function save($runValidation=true,$attributes=null)
    {
        if(!$runValidation || $this->validate($attributes)) {
            $auth = Yii::app()->authManager;
            try { 
                $auth->save();
            }catch(Exception $e) { // an exception is raised if a query fails
                // should do something about the $e 
                return false;
            }
            return true;
        } else
            return false;
    }
}
