<?php

/**
 * Description of Token
 *
 * @author jr
 */
class Token extends CFormModel {
    
  static $configFolder = "/var/lib/spxmanage/api-keys/";
  public $filenameTemplate = "token-{key}";
  public $token = "";
  public $enableToken = false;
  public function init() {
      
  }
  
  public function setPrefix( $prefix ){
      $this->filenameTemplate =  $prefix . "-{key}";
  }
  public function addTokenError( ){
      $this->addError( "Token", "Token is required");
  }
  public function checkToken( $attribute, $params  ) {
      if ( $this->enableToken === "1" || $this->enableToken === true){
          $this->enableToken = true;
      } else{
          $this->enableToken = false;
      }
      if ( $this->enableToken ){
          if ( empty( $this->token ) ){
              $this->addTokenError();
          }
      } else {
          $this->token = "";
      }        
  }
  public function verifyToken( $Token  ) {
      $this->loadToken( );
      return $Token === $this->token;
  }
  function filename( $token ) {
      return strtr( self::$configFolder . $this->filenameTemplate, array( "{key}" => trim($token) ));   
  }
  function loadToken( ) {
      $files = scandir( self::$configFolder );        
      foreach ($files as $file) {
          $matches = array();
    if ( !preg_match("|^".strtr( $this->filenameTemplate, array( "." => "\\.", "{key}" => "([-a-zA-Z0-9._+@]*)" ))."$|", $file, $matches) ){
              continue;
          }
          return trim($matches[1]);            
      }
      return "";
  }
  function generateToken( ) {
    return trim(file_get_contents( "/proc/sys/kernel/random/uuid" )); 
  }
  function load( ) {
      $this->token = $this->loadToken( );
      $this->enableToken = !empty( $this->token);   
      
      if ( empty( $this->token) ) {
          $this->token = $this->generateToken( );
      }
  }
  function save( $runValidation=true, $attributes=null ) {
      
      if( $runValidation && !$this->validate($attributes)){
          return false;
      }
      
      $oldToken = $this->loadToken( );
      if ( $this->enableToken && $oldToken == $this->token ){
          return;
      }
      if ( !empty($oldToken) ){
          @unlink( $this->filename($oldToken) );
      }
      if ( !empty($this->token) ){
          touch( $this->filename($this->token));        
      } else {
          $this->token = $this->generateToken( );   
      }
      exec('sync');
  }
}
