function getDur( start, end ){
    return (end - start)/1000;    
}
function addDur( start, dur ){
    var end = $.fullCalendar.moment( start );
    var d = ( "" + dur).split(":");
    if ( d.length === 1 ){
        end.add(d[0],'s');
    } else {
        end.add(d[0],'h');
        end.add(d[1],'m');
        if ( d.length > 2 ){
            end.add(d[2],'s');
        }
    }    
    return end;
}
var spx_date_fmt = "DD MMM YYYY";
ko.observableEvent = function( calendar, openResource, addRawEvent, updateCalEvents ){
    
    var srcEvent = ko.observable( null );
   
    var updating;
    
    function updateEvent( args ){
        args = args || {};
        var create = false;
        if ( !updating ){ 
            var event = srcEvent() || { virtual: true };
            if ( args.resource ){
                create = !event.resource;
                event.resource = args.resource;
                event.title = args.resource.model.name.shortStr();
                if ( create ) {
                    // dirty flag on
                    result.status.reset( true ); 
                    if ( !event.virtual ) {
                        addRawEvent( event );
                    }
                }
                srcEvent( event );
            }            
                        
            if ( create ){                
                calendar.clearSelect( );            
            } 
            if ( event.resource && !event.virtual ){
                updateCalEvents( event );                
            }
        }
    }
    var _event = {
    };
    $.each(['startDate', 'startTime', 'duration' ], function(i, name) {
        _event[name] = ko.computed({
            read: function() {                
                if ( srcEvent() ){
                    return srcEvent()[name];
                } else {
                    return "";
                }
            },
            write: function( val ) {
                if ( srcEvent() ){
                    var event = srcEvent();                    
                    event[name] = val;
                    srcEvent( event );
                    updateEvent( );  
                }
            }
        });
    });   

    _event.allDay = ko.computed({
        read: function() {                
            if ( srcEvent() ){
                return srcEvent().allDay;
            } else {
                return false;
            }
        },
        write: function( val ) {
            var event = srcEvent();
            if ( event ){                
                event.allDay = val;                
                srcEvent( event );
                updateEvent( );  
            }
        }
    });
    _event.endDate = ko.computed({
        read: function() {                
            var event = srcEvent();
            if ( event ){
                if ( event.endDate && event.endDate!=="" && (event.allDay || event.days !== false )){
                    var end = $.fullCalendar.moment( event.endDate );   
                    var ret = end.subtract( 1, 'd' ).format("YYYY-MM-DD");
                    return ret;
                } else {
                    return event.endDate || "";
                }
            } else {
                return "";
            }
        },
        write: function( val ) {
            var event = srcEvent();
            if ( event ){
                if ( val !== "" && val !== undefined && val !== null){
                    if ( event.allDay || event.days !== false ){
                        event.endDate = $.fullCalendar.moment( val ).add( 1, 'd' ).format("YYYY-MM-DD");
                    } else {
                        event.endDate = $.fullCalendar.moment( val ).format("YYYY-MM-DD");
                    }
                } else {
                    event.endDate = "";
                }
                srcEvent( event );
                updateEvent( );  
            }
        }
    });
    _event.days = ko.computed({
        read: function() {
            //console.log( "read days");
            if ( srcEvent() && srcEvent().days && $.isArray(srcEvent().days) ){                
                return srcEvent().days;
            } else if ( !srcEvent() || !srcEvent().days ){
                return [];
            } else {
                return [ 0, 1, 2, 3, 4, 5, 6 ];
            }
        },
        write: function( val ) {
            //console.log( "write days");
            if ( srcEvent() ){
                var event = srcEvent();
                if ( val.length === 0 ){
                    if ( event.days.length > 0) {
                        var view = calendar.getView();
                        var sd = $.fullCalendar.moment( event.startDate );                        
                        if ( sd.isBefore( view.start ) || sd.isAfter( view.end )){
                            var lastDay = event.days[0];
                            event.startDate = $.fullCalendar.moment( view.start )
                                               .day(lastDay).format( "YYYY-MM-DD" );
                        }
                    }                    
                    event.days = false;
                    event.endDate = "";
                } else {                    
                    var view = calendar.getView();  
                    var sd = $.fullCalendar.moment( event.startDate );
                    if ( event.days === false ){
                        event.startDate = sd.startOf('week').format("YYYY-MM-DD");
                    }                    
                    if ( event.endDate ){
                        var start = $.fullCalendar.moment( event.startDate ).add( 1, 'w');
                        var end = $.fullCalendar.moment( event.endDate );
                        if ( end.isBefore( start ) ){
                            end = start;
                            event.endDate = end.format("YYYY-MM-DD");
                        }
                    }
                    if ( val.length === 7 ){
                        event.days = true;
                    } else {
                        event.days = val;
                    }
                }
                srcEvent( event );
                updateEvent( );  
            }
        }
    });
    _event.open = function( ) {
        if ( srcEvent() ){
            var event = srcEvent();
            if ( event.resource ) {
                openResource( event.resource, event.id );
            } else {
                openResource( null, {
                    startTime: event.startTime,
                    duration: event.duration,
                    startDate: event.startDate,
                    endDate: event.endDate,
                    allDay: event.allDay,
                    days: event.days
                });
            }
        } else {
            openResource( null, { 'default' : true } );
        }
    };
    _event.remove = function( ) {
        result.status.reset( true );     
        if ( srcEvent().id ) {
            calendar.removeEvents( srcEvent().id );        
        }
        srcEvent().deleted = true;
        srcEvent( null );
    };
    _event.drop = function( resource ) {
        result.status.reset( true );          
        updateEvent( { resource: resource } );        
        srcEvent.notifySubscribers(); //valueHasMutated()                     
    };
    
    // used to check if something has been modified by the dirty flag 
    _event.toJSON = function() {
        var data = {
            startTime: _event.startTime(),
            duration: _event.duration(),
            startDate: _event.startDate(),
            endDate: _event.endDate(),
            allDay: _event.allDay(),
            days: _event.days()
        };
        if ( srcEvent() && !srcEvent().resource ){
            return "{}";
        }
        return JSON.stringify( data );
    };    
    
    var hideDateTime = ko.computed(function(){
        return _event.days().length !== 0 && _event.allDay();
    });
    var hideDateTop = ko.computed(function(){
        return _event.days().length !== 0;
    });
    var hideDateBottom = ko.computed(function(){
        return !hideDateTop();
    });

    _event.properties = [
        { name: spxapi.t('All day'), type : 'boolean', value: _event.allDay },   

        { name: spxapi.t('Start'), type : 'datetime', hiddenTime: _event.allDay, date: _event.startDate, time: _event.startTime },
        { name: spxapi.t('Duration'), type: 'dur', hidden: _event.allDay, value: _event.duration },
        
        { name: spxapi.t('Recurrence'), type : 'multichoice', value: _event.days, select: [
                { name: spxapi.t("Sunday"), value: 0 },
                { name: spxapi.t("Monday"), value: 1 },
                { name: spxapi.t("Tuesday"), value: 2 },
                { name: spxapi.t("Wednesday"), value: 3 },
                { name: spxapi.t("Thursday"), value: 4 },
                { name: spxapi.t("Friday"), value: 5 },
                { name: spxapi.t("Saturday"), value: 6 }
            ], options: {
                includeSelectAllOption: true,
                selectAllText: spxapi.t('Daily'),
                buttonText: function(options, select) {
                    function text( txt ){
                        return '<span class="pull-left">'+txt+'</span> <span class="caret"></span>';
                    }
                    
                    if (options.length === 0) {  
                        return text( spxapi.t('Never') );
                    } else if ( options.length === 7 ) {
                        return text( spxapi.t('Daily') );                            
                    } else if ( options.length === 2 && options[0].value === '0' && options[1].value === '6' ) {
                        return text( spxapi.t('Weekend') );                            
                    } else if ( options.length === 5 && options[0].value !== '0' && options[4].value !== '6' ) {
                        return text( spxapi.t('Weekdays') );                            
                    } else if (options.length > this.numberDisplayed) {
                        return text( spxapi.t( '{n} days selected', {"{n}": options.length } ) );
                    } else {
                        var selected = '';
                        options.each(function() {
                            var label = ($(this).attr('label') !== undefined) ? $(this).attr('label') : $(this).html();

                            selected += label + ', ';
                        });
                        return text( selected.substr(0, selected.length - 2) );
                    }                    
                }
            }
        },
        { name: spxapi.t('Recurrence ends'), type : 'dateclose',  hidden: hideDateBottom, value: _event.endDate }
        
    ];
   
    var result = ko.computed(function () {
        if ( !srcEvent() ){
            _event.valid = false;
            _event.id = 'invalid';
        } else {
            var event = srcEvent();
            _event.valid = true;
            if ( event.resource ) {
                _event.resource = event.resource;
                _event.title = event.resource.model.name.shortStr();
                _event.id = event.id;
            } else {
                _event.resource = null;
                _event.title = "";
                _event.id = 'edit';
            }
        }
        return _event;            
    });
    result.updateEvent = function( calEvent, deltaStart, deltaEnd ) {
        updating = true;
        var event = srcEvent();
        var sameDayEnd;;
        if ( event.allDay ){
            sameDayEnd = $.fullCalendar.moment(calEvent.start).add(1, 'd').isSame( calEvent.end );
        } else {
            sameDayEnd = $.fullCalendar.moment(calEvent.start).isSame( calEvent.end, 'd' );
        }
        if ( !sameDayEnd ){
            event.days = false;
        }
        
        if ( !event.allDay ){
            event.startTime = calEvent.start.format("HH:mm");
            event.duration = getDur( calEvent.start, calEvent.end );
        }
        
        if ( !event.days || ( $.isArray(event.days) && event.days.length === 0 ) ) {
            if ( event.allDay ) { 
                if ( calEvent.start.hour()<12 ){
                    event.startDate = calEvent.start.format( "YYYY-MM-DD" );
                } else {
                    event.startDate = $.fullCalendar.moment( calEvent.start )
                                       .add( 1, 'd').format( "YYYY-MM-DD" );
                }
            } else {
                event.startDate = calEvent.start.format( "YYYY-MM-DD" );
            }
            if ( event.endDate || !sameDayEnd ){                
                event.endDate = calEvent.end.format( "YYYY-MM-DD" );                   
            }
        } else if ( !$.isArray(event.days) ){
            if ( event.startDate && deltaStart ){
                event.startDate = $.fullCalendar.moment( event.startDate )
                                    .add( deltaStart.asDays(), 'd' )
                                    .format( "YYYY-MM-DD" );                
            }
            if ( event.endDate && deltaEnd ){
                event.endDate = $.fullCalendar.moment( event.endDate )
                                    .add( deltaEnd.asDays(), 'd' )
                                    .format( "YYYY-MM-DD" );  
            }
        } else {
            var view = calendar.getView();
            if ( event.startDate ){
                var sd = $.fullCalendar.moment( event.startDate );
                if ( sd.isAfter(view.start, 'd') ){
                    event.startDate = view.start.format( "YYYY-MM-DD" );
                }
            }
            if ( event.endDate ){
                var ed = $.fullCalendar.moment( event.endDate );
                if ( ed.isBefore(view.end, 'd') ){
                    event.endDate = view.end.format( "YYYY-MM-DD" );
                }
            }
            var activeDay;
            if ( calEvent.start.hour()<12 ){
                activeDay = calEvent.start.day();
            } else {
                activeDay = calEvent.end.day();
            }
            if ( event.days[0] !== activeDay ){
                event.days = [ activeDay ];                
            }
        }
        srcEvent( event );
        updateCalEvents( event );
        
        updating = false;
    };
    
    result.setEvent = function( event ) {
        
        var dirty = true;
        var clearSelect = false;
        if ( event && srcEvent() && srcEvent().id === event.id ){
            //console.log("Same event: "+event.id );
            return;
        }
        updating = true;

        dirty = result.status.isDirty();
        if ( dirty ) {
            result.status.reset( true ); // force dirty from now on
        }
        clearSelect = srcEvent() && !srcEvent().resource;
        

        if ( !event ){                  
            srcEvent( null );                     
        } else {
            //console.log( "setting event "+event.id)
            srcEvent( event );
        }
        if ( clearSelect && calendar.clearSelect ) {
            calendar.clearSelect( );
        }
        if ( !dirty ){
            result.status.reset();                
        }
        updating = false;
    };

    
    result.status = ko.dirtyFlag( _event );
    
    return result;
};

function ScheduleEdit( args ) {
    
    keywordsMemory( { reset: true } );
    args = args || {};
    
    var self = this;
    
    moment.locale( args.lang || "en" );
    if ( args.lang === 'ar' ){
        moment.defineLocale( 'ar' ,{
            preparse: function (string) { return string; },
            postformat: function (string) { return string; }
        });
    }
    var openResource = function ( resource, id ){
        if ( id !== true ) {
            if ( resource && id ) {
                spxapi.storage.set("spx-calendar-edit-item", id );
            }
            if ( !resource && id ) {
                spxapi.storage.set("spx-calendar-new-item", JSON.stringify( id ) );
            }
        }

        resource = resource || { type: 'playout', id: "" };
        var href = args.links[resource.type].replace( "%5Bid%5D", resource.id );
        if ( self.isDirty() ) {
            spxapi.storage.set("spx-calendar-data", JSON.stringify( self.toJS( true ) ) );
            spxapi.storage.set("spx-calendar-referrer", location.protocol + "//" + location.host + href );
            ignoreDirtyFlag = true;     
        }
        location.href = href;
        
    };
    
    self.create = function( ) {
        openResource();
    };
    var uid = 10000;
    function getNewId( id ) {
        if ( id ){
            uid = id;
        }            
        return uid++;
    }
    var rawData = null;
    function addRawEvent( event ){
        event.id = getNewId( event.id );
        rawData.push( event );
    }
    
    self.resources = resourcesSelect({
        resources: args.resources,
        draggable : true,
        type: "playout",
        viewId: 'schedule',
        noItemMsg: {
                type: 'warning',
                title: spxapi.t( 'Nothing to schedule' ),
                text: spxapi.t( "There is currently no resources available for scheduling. Please go to the Create page to manage resources." )
            }
    });
    iconView( self.resources, { 
        draggable : true,
        rows: 1,
        sizes: { large: "col-sm-4" }
    } );    
    
    
    self.dirty = ko.observable( false );    
    var fixView = true;
    function fixSize() {
        var h = $(window).height();
        var w = $(window).width();
        if ( h < 768 ) {
            if ( w < 1200 )
                self.calendar.setCalendarOptions( 'height', 350 );
            else 
                self.calendar.setCalendarOptions( 'height', 410 );            
        } else if ( h < 992 ){
            if ( w < 1200 )
                self.calendar.setCalendarOptions( 'height', 410 );
            else 
                self.calendar.setCalendarOptions( 'height', 520 );
        } else if ( w < 992 )
            self.calendar.setCalendarOptions( 'height', 424 );
        else{
            self.calendar.setCalendarOptions( 'height', 'auto' );
        }
        
        if ( w < 992 ){    
            if ( self.calendar.getView().name != "month" )
                self.calendar.changeView( 'agenda3Days' );
            $(".fc-agendaWeek-button").hide();
            $(".fc-agenda3Days-button").show();
        } else {
            if ( self.calendar.getView().name != "month" )
                self.calendar.changeView( 'agendaWeek' );
            $(".fc-agendaWeek-button").show();
            $(".fc-agenda3Days-button").hide();
        }
        if ( w < 768 ){
            $('.fc-month-button').hide();
            $(".fc-agenda3Days-button").hide();
        } else {
            $('.fc-month-button').show();
        }
    };    
    $(window).resize( fixSize );
    $( fixSize );
    self.calendar = {
        header: {
            left:   'title',
            right:  'month,agendaWeek,agenda3Days prev,next'
        },
        aspectRatio: 1.8,
        height: 'auto',
        scrollTime: '08:00:00',
        eventLimit: true,
        eventLimitClick: 'popover',
        defaultView: 'agendaWeek',
        allDaySlot: false,
        slotDuration: "01:00:00",
        selectable: args.editable,
        selectHelper: true,
        unselectAuto: false,
        editable: args.editable,
        droppable: args.editable,
        eventOverlap: false,
        locale: args.lang || "en",
        buttonText: {
            today:    spxapi.t( 'Today' ),
            month:    spxapi.t( 'Month' ),
            week:     spxapi.t( 'Week' ),
            day:      spxapi.t('Day' )
        },       
        timeFormat: 'H:mm',
        axisFormat: 'H:mm', 
        views: {
            month: {
                titleFormat: "MMMM YYYY",
                columnFormat: 'ddd'
            },    // Mon
            week: {
                titleFormat: "D MMMM YYYY",
                columnFormat: 'ddd - D MMM'
            }, // Mon 9/7
            day: {
                titleFormat: "D MMMM YYYY",
                columnFormat: 'dddd' 
            },
            agenda3Days: {
                type: 'agenda',
                titleFormat: "D MMMM YYYY",
                columnFormat: 'ddd', 
                duration: { days: 3 },
                buttonText: '3'
            }
        },
        viewRender: function( view, elem ){
            var cal = elem.parent();
            if ( fixView ) {                
                $('.fc-button-group')
                    .addClass('btn-group')
                    .removeClass('fc-button-group');
                $('.fc-button')
                    .addClass('btn btn-default btn-sm')
                    .removeClass('fc-button fc-state-default'); 
                $('.fc-month-button').html("<i class='fa fa-calendar'></i>");
                $('.fc-agendaWeek-button').html("<div style='position: relative;'><i class='fa fa-calendar-o'></i><div style='font-size: 0.6em; font-weight: bold; left: 6px; position: absolute; top: 5px'>7</div></div>");
                $('.fc-agenda3Days-button').html("<div style='position: relative;'><i class='fa fa-calendar-o'></i><div style='font-size: 0.6em; font-weight: bold; left: 6px; position: absolute; top: 5px'>3</div></div>");
                
                $('.fc-icon-right-single-arrow')
                    .addClass('fa fa-chevron-right ')
                    .removeClass('fc-icon fc-icon-right-single-arrow');
                $('.fc-icon-left-single-arrow')
                    .addClass('fa fa-chevron-left')
                    .removeClass('fc-icon fc-icon-left-single-arrow');
            }
            fixView = false;
        }
    };
    self.activeEvent = ko.observableEvent( self.calendar, openResource, addRawEvent, updateCalEvents );
    self.defaultEvent = ko.observableEvent( self.calendar, openResource, addRawEvent );
    self.defaultPowerOff = ko.observable();
    self.defaultProperties = [
        { name: spxapi.t('Turn monitor OFF'), type : 'boolean', value: self.defaultPowerOff },     
    ];
    
    var ignoreDirtyFlag = false;
    self.isDirty = ko.computed( function() {
        return self.dirty() || self.activeEvent.status.isDirty() || self.defaultEvent.status.isDirty();
    });
        
      
    self.fromJS = function ( data ){
        var event;
        var newData = [];
        for ( var i=0; i<data.length; i++ ){
            if ( data[i].resource && !data[i].resource.model ){                
                data[i].resource.model = spxapi.resources.get( data[i].resource.id );
            }
            if ( data[i].default ){   
                if ( data[i].resource ){
                    event = {
                        virtual: true,
                        resource: data[i].resource
                    };
                    self.defaultEvent.setEvent( event );
                    self.defaultPowerOff( false );
                } else if ( data[i].powerOff ) {
                    self.defaultPowerOff( true );
                }
            } else {                
                data[i].id = getNewId( data[i].id );
                if ( data[i].allDay ){
                    data[i].startTime = "08:00";
                    data[i].duration = 6*3600;
                }
                if ( data[i].startDate ){
                    data[i].startDate = $.fullCalendar.moment( data[i].startDate ).format( "YYYY-MM-DD" );
                }
                if ( data[i].endDate ){
                    data[i].endDate = $.fullCalendar.moment( data[i].endDate ).format( "YYYY-MM-DD" );                                         
                }                
                if ( !data[i].endDate || data[i].endDate.toString().length !== 10 ){
                    data[i].endDate = "";
                }
                newData.push( data[i] );
                if ( previousEditItem === "" + data[i].id ){
                    self.activeEvent.setEvent( data[i] );
                }
            }                    
        }
        if ( previousNewItem ) {
            if ( previousNewItem.default ) {
                event = {
                    virtual: true,
                    resource: previousNewItem.resource
                };
                event.resource.model =  spxapi.resources.get( previousNewItem.resource.id );
                self.defaultEvent.setEvent( event );
            } else {
                previousNewItem.id = getNewId();                
                previousNewItem.resource.model =  spxapi.resources.get( previousNewItem.resource.id );  
                newData.push( previousNewItem );
                self.dirty( true );
                self.activeEvent.setEvent( previousNewItem );
            }
            
        }
        return newData;
    };
    
    self.toJS = function( local ) {
        var data = [], item;
        for( var i=0; i<rawData.length; i++ ){
            if ( rawData[i].deleted ){
                continue;
            }
            item = $.extend({}, rawData[i]);
            item.resource = {
                id:  rawData[i].resource.id,
                type:  rawData[i].resource.type
            };
            if ( !local ){
                item.id = undefined;
            }            
            if ( item.startDate ){
                item.startDate = $.fullCalendar.moment( item.startDate ).format( "YYYY-MM-DD" );
            }
            if ( item.days !== false && item.endDate ){
                item.endDate = $.fullCalendar.moment( item.endDate ).format( "YYYY-MM-DD" );                                
            } else if ( item.days === false || !item.endDate) {
                item.endDate = undefined;
            }
            data.push( item );
        }
        if ( self.defaultPowerOff( )) {
            item = {
                "default": true,
                powerOff: true
            };
            data.push( item );            
        } else if ( self.defaultEvent().valid ){
            var event = self.defaultEvent();
            item = {
                "default": true,
                resource: {
                    id:  event.resource.id,
                    type:  event.resource.type
                }
            };
            data.push( item );
        }
        return data;
    };
    
    
    // memory

    
    var previousEditItem = spxapi.storage.get("spx-calendar-edit-item" );
    var previousNewItem = JSON.parse( spxapi.storage.get("spx-calendar-new-item" ) );
    if ( previousNewItem && !previousNewItem.resource ){
        previousNewItem = null;
    }
    if ( spxapi.storage.get("spx-calendar-referrer" ) === document.referrer ) {
        rawData = self.fromJS( JSON.parse( spxapi.storage.get("spx-calendar-data") ) );
        if ( rawData ) {
            self.dirty( true );
        }
    }
    spxapi.storage.remove("spx-calendar-edit-item" );
    spxapi.storage.remove("spx-calendar-new-item" );
    spxapi.storage.remove("spx-calendar-referrer" );
    spxapi.storage.remove("spx-calendar-data" );
    function rawDataToCalEvents( start, end, data ){
        //console.log( "updating: "+start.format() + " => " + end.format() );
        /*
        var delta = end - start;
        start.subtract( delta );
        end.add( delta );
        */
        var results = [];
        for ( var i=0; i<data.length; i++ ){
            if ( data[i].deleted ){
                continue;
            }
            var event = data[i];           
            if ( !event.days ){
                var calEvent = {
                    id: event.id,
                    title: event.resource.model.name.shortStr(),
                    src: event
                };
                // single occurence
                if ( event.allDay || !event.startTime || !event.duration ){
                    //calEvent.allDay = true;
                    calEvent.start = $.fullCalendar.moment( event.startDate ).time("00:00:00");
                    if ( event.endDate && !event.allDay ){
                        calEvent.end = $.fullCalendar.moment( event.endDate ).time("00:00:00");
                    } else {
                        calEvent.end = $.fullCalendar.moment( calEvent.start ).add(1, 'd');
                    }
                } else {
                    calEvent.start = $.fullCalendar.moment( event.startDate).time( event.startTime );
                    calEvent.end = addDur(calEvent.start, event.duration );                    
                }
                if ( calEvent.start <= end && calEvent.end >= start ){
                    //console.log( calEvent.start.format() + " => " + calEvent.end.format() );
                    results.push( calEvent );
                } else {
                    //console.log( "skip: "+calEvent.start.format() + " => " + calEvent.end.format() );
                }
            } else {
                // mulitple occurence
                var st = $.fullCalendar.moment(start);
                var ed = $.fullCalendar.moment(end);
                if ( event.startDate && st.isBefore( event.startDate ) ){
                    st = $.fullCalendar.moment( event.startDate );
                }
                if ( event.endDate && ed.isAfter( event.endDate ) ){
                    ed = $.fullCalendar.moment( event.endDate );
                }
                ed = ed.subtract(1, 'd');                
                for ( var d = $.fullCalendar.moment(st); !d.isAfter(ed); d = d.add(1, 'd') ){
                    if ( event.days === true || event.days.indexOf(d.day()) !== -1 ){
                         var calEvent = {
                            id: event.id,
                            title: event.resource.model.name.shortStr(),
                            src: event
                        };
                        if ( event.allDay || !event.startTime || !event.duration ){
                            //calEvent.allDay = true;
                            calEvent.start = $.fullCalendar.moment( d ).time("00:00:00");
                            calEvent.end = $.fullCalendar.moment( calEvent.start ).add(1, 'd');
                        } else {
                            calEvent.start = $.fullCalendar.moment( d ).time( event.startTime );
                            calEvent.end = addDur( calEvent.start, event.duration );
                        }
                        //console.log( calEvent.start.format() + " => " + calEvent.end.format() );
                        results.push( calEvent );
                    } 
                }                
            }
        }
        // should check for overlapping events
        
        return results;
    }
    function updateCalEvents( event ){        
        // we go the hard way, remove all, then add again all.
        self.calendar.removeEvents( event.id ); 
        var view = self.calendar.getView();
        var calEvents = rawDataToCalEvents( view.start, view.end, [ event ] );
        for (var i=0; i< calEvents.length; i++ ) {
            self.calendar.renderEvent( calEvents[i] );            
        }
        return calEvents;
    }
    self.calendar.events = function(start, end, timezone, callback) {       
        if ( rawData === null ){
            spxapi.schedule.get( ).done( function( data ) {
                rawData = self.fromJS( data );
                callback( rawDataToCalEvents( start, end, rawData ) );
            }).fail( function() {
                rawData = [];
            });
        } else {            
            callback( rawDataToCalEvents( start, end, rawData ) );
        }            
    };
    self.activeEvent.subscribe( function(newValue) {
        if ( newValue.valid ) {
            $('#collapseActive').collapse('show');
            $('#collapseDefault').collapse('hide');
        } else {
            $('#collapseActive').collapse('hide');
            $('#collapseDefault').collapse('show');
        }
    });
    self.showDefaultHelp = ko.observable( true );
    self.showActivetHelp = ko.observable( true );
    $('#collapseDefault').on('shown.bs.collapse', function() {
        setActiveEvent( null );
        self.showDefaultHelp( true );
    });
    $('#collapseDefault').on('hidden.bs.collapse', function() {
        self.showDefaultHelp( false );
    });
    $('#collapseActive').on('shown.bs.collapse', function() {
        self.showActivetHelp( true );
    });
    $('#collapseActive').on('hidden.bs.collapse', function() {
        self.showActivetHelp( false );
    });
    
    var lastNode;
    function setActiveEvent( calEvent, node ){
        if ( calEvent && self.activeEvent().id === calEvent.id ){
            $(node).addClass('active');
            return;
        }
        if ( calEvent ){
            if ( calEvent.src ){
                //console.log("setEvent: "+calEvent.id );
                self.activeEvent.setEvent( calEvent.src, node );
            } else {
                //console.log( "setEvent: ignored" );
                //self.activeEvent.setEvent( calEvent.src, node );
            }
        } else {
            //console.log("setEvent: null" );
            self.activeEvent.setEvent( null, node );
        }
        if ( lastNode ){
            $(lastNode).removeClass('active');
        }
        if ( node ){
            $(node).addClass('active');
        }
        lastNode = node;        
    }
    
    self.calendar.drop = function( date, jsEvent, ui  ) {
        var resource = ko.droppableHelpers.getDragItem( this );
        var start, duration, days = false, allDay = false;
        start = $.fullCalendar.moment( date );
        if ( start.hasTime() ){      
            start.subtract(3, 'h' );
            duration = 6*3600;
            days = false;
        } else {
            start.time('00:00');
            allDay = true;
            duration = 24*3600;
        }
        // drop event default: full day, repeat everyweek but if user un-check, then he get 6h
        var event = {
            allDay: allDay,
            startTime: start.format("HH:mm"),
            duration: duration,
            startDate: start.format( "YYYY-MM-DD" ),
            days: days,
            resource: {
                id: resource.id,
                type: resource.type,
                model: resource.model
            }
        };          
        addRawEvent( event );
        self.dirty( true );  
        setActiveEvent( { src: event, id: event.id } );
        updateCalEvents( event );     
        
    }; 
    
    self.calendar.eventClick = function( calEvent ) {
        //console.log("eventClick");
        $(".fc-event.fc-draggable.active").removeClass('active');
        setActiveEvent( calEvent, this );
    };
    self.calendar.select = function( start, end ){
        //console.log("select");
        
        $(".fc-event.fc-draggable.active").removeClass('active');       
        
        var sameDay = start.isSame( end, 'd' );
        if ( sameDay && $.fullCalendar.moment( start ).add(1, 'h').isSame( end ) ){
            self.calendar.setSelect( start.subtract(3,'h'), end.add(2,'h') );
            return;
        }
        var allDay = false;
        if ( start.format("HH:mm") === "00:00" && $.fullCalendar.moment( start ).add(1, 'd').isSame( end )){
            allDay = true;
            sameDay = true;
        }
        // create virtual event
        var vEvent = {
            id: 'new'+ getNewId(),
            start: start,
            end: end,
            src: { 
                startTime: start.format("HH:mm"),
                duration: getDur( start, end ),
                startDate: start.format("YYYY-MM-DD"),
                endDate: "",
                days: false,
                allDay: allDay
            }
        };
        setActiveEvent( vEvent );
    };
    self.calendar.unselect = function( start, end ){
        //console.log("unselect");
        if ( self.activeEvent().id === 'new' ){
            setActiveEvent( null );
        }
    };
    self.calendar.eventDragStart = function( calEvent ) {
        $(".fc-event.fc-draggable.active").removeClass('active');
        setActiveEvent( calEvent, this );
        //console.log("eventDragStart");
    };
    self.calendar.eventDragStop = function( calEvent ) {
        //console.log("eventDragStop");
    };
    self.calendar.eventDrop = function( calEvent, delta ){
        //console.log("eventDrop");
        //console.log("updateEvent: "+calEvent.id );
        self.activeEvent.updateEvent( calEvent, delta, delta );
        setActiveEvent( calEvent, this );
    };
    
    self.calendar.eventResizeStart = function( calEvent ) {
        //console.log("eventResizeStart");
        setActiveEvent( calEvent, false );
    };
    self.calendar.eventResizeStop = function( calEvent ) {
        //console.log("eventResizeStop");
        setActiveEvent( calEvent, this );        
    };
    self.calendar.eventResize = function( calEvent, delta ){
        //console.log("eventResize");
        //console.log("updateEvent: "+calEvent.id );
        self.activeEvent.updateEvent( calEvent, null, delta );
        setActiveEvent( calEvent, this  );
    };
    self.calendar.eventRender = function(calEvent, element, view ) {       
        //console.log("eventRender: "+calEvent.id + (self.activeEvent().id === calEvent.id?" *":" actif: "+self.activeEvent().id));
        if ( calEvent.id === undefined ){
            // this is a select placeholder
            element.addClass('active');
        } else if ( self.activeEvent().id === calEvent.id ){
            //setActiveEvent( calEvent, element );
            element.addClass('active');                
        } else {
            element.removeClass('active');            
        }  
        var dur = calEvent.end - calEvent.start;
        if ( calEvent.id ){
            $(element).addClass("event-"+calEvent.id);
        }
        if ( ( view.name === 'agendaWeek' ||  view.name === 'agenda3Days' ) 
                && dur > 1*3600*1000 && calEvent.src &&calEvent.src.resource ) {
            var preview = $("<div/>")
                    .addClass("spx-preview-fixed")
                    .appendTo( element );
            if ( calEvent.src.resource.model.vertical() ) {
                preview.addClass("vertical");
            }
            $("<div/>")
                    .addClass("spx-preview-fixed-item")
                    .addClass("spx-preview-background")
                    .css("background-image","url("+calEvent.src.resource.model.snapshots.small.src()+")")
                    .appendTo( preview );  
            
        }
        /*
        var resizer = $(element).children('.fc-resizer');
        resizer.html("<i class='fa fa-chevron-down' style='pointer-events:none;'></i>");
        */
    };
    self.clear = function ( data, event ) {
        // remove all events                
        setActiveEvent( null );
        self.calendar.removeEvents( ); 
        rawData = [];
        if ( self.defaultEvent().valid ){
            self.defaultEvent().remove();
        }
        self.dirty( true );   
        /*
        spxapi.ui.loading(event.target);
        return spxapi.schedule.clear( ).done( function() {
            setActiveEvent( null );
            self.calendar.removeEvents( ); 
            rawData = [];
            if ( self.defaultEvent().valid ){
                self.defaultEvent().remove();
            }
            self.dirty( false );
            self.activeEvent.status.reset();            
            self.defaultEvent.status.reset(); 
        }).always( function() {
            spxapi.ui.reset(event.target);
        });
        */
    };
    self.apply = function ( data, event ) {
        spxapi.ui.loading(event.target);
        return spxapi.schedule.set( self.toJS() ).done( function() {
            self.dirty( false );
            self.activeEvent.status.reset();            
            self.defaultEvent.status.reset();                
        }).always( function() {
            spxapi.ui.reset(event.target);
        });
    };
    self.cancel = function ( data, event ) { 
        location.href = document.referrer;         
    };
    self.save = function ( data, event ) {         
        self.apply( data, event ).done( function() {
            ignoreDirtyFlag = true;
            self.cancel( data, event );
        });        
    };
    
    // Prevent leaving the page with changes
    $(window).bind('beforeunload', function(e){
        if ( !ignoreDirtyFlag && self.isDirty() ) {
            return "Some changes have not been saved.";
        } else {
            return;
        }
    });
     
}
