<?php
/* @var $this ConfigController */

$formConfig = $this->beginWidget('SimpleForm', array( 
    'title' => "Live Sources",
    'id' => "Live",
    'button' => "Apply",
    'action' => array ( 'post' => array() )
) );
    $formConfig->errorSummary( $sourceConfig );

    $ns = new NetworkSource;
    $headers = array( 
        $ns->getAttributeLabel( "uri"),
        $ns->getAttributeLabel( "name"),
        ""
    );
    $options = array(
        "data-bind" => "foreach: liveSources",
        "sizes" => array( "col-sm-8", "col-sm-3", "col-sm-1" )
    );
    $row = array();
    
        
    $row[] = array( CHtml::textField( "", "", $formConfig->itemOptions( array(
        "data-bind" => "value: uri, attr: { name: 'NetworkSource['+\$index()+'][uri]', readonly: !obs}",
        'placeholder' => "http://SomeServer/SomePath/ or Folder"
    ) ) ), array('data-bind' => "css: { 'has-error' : uriError}"));
    $row[] = array( CHtml::textField( "", "", $formConfig->itemOptions( array(
        "data-bind" => "value: name, attr: { name: 'NetworkSource['+\$index()+'][name]'}"
    ) ) ) . CHtml::hiddenField( "", "", array(
        "data-bind" => "value: resourceId, attr: { name: 'NetworkSource['+\$index()+'][resourceId]'}"
    ) ), array('data-bind' => "css: { 'has-error' : nameError}"));
    $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-times"), "" ), "#", array(
        "data-bind" => "click: \$parent.removeSource, css: { disabled: \$parent.liveSources().length === 1 && obs === true && name() === '' && uri() == ''}",
        "class" => "btn btn-sm btn-warning btn-block"
    ) );
    $this->widget('BsRow', array( 
        'options' => array( 'class' => 'form-group table-responsive'),
        'content' => $formConfig->table( $headers, array( $row ), $options) 
    ));    
    $this->widget('BsRow', array( 'cols' => array( 
        array( 'size' => 3, 
            'content' => CHtml::link( "Add", "#", array(
                            "data-bind" => "click: addSource",
                            "class" => "btn btn-sm btn-default btn-block"
                        ))
            )
    )));
    
$this->endWidget();


?>
<script type="text/javascript" >
//<![CDATA[
yiiModel.addSource = function() {
    yiiModel.liveSources.push({ name: ko.observable(''), uri:ko.observable(''), resourceId: null, nameError: false, uriError: false, obs: true});
};
yiiModel.liveSources = ko.observableArray( <?php
    $liveSources = array();
    foreach ($sourceConfig->liveSources as $i => $source ){
        $liveSources[] = array(
            "name" => $source->name,
            "nameError" => count($source->getErrors('name'))!=0,
            "uri" => $source->uri,
            "uriError" => count($source->getErrors('uri'))!=0,
            "resourceId" => $source->resourceId,
            "obs" => false
        );
    }
    if ( count( $liveSources ) === 0 ){
        $liveSources[] = array(
            "name" => "js:ko.observable('')",
            "uri" => "js:ko.observable('')",
            "nameError" => false, 
            "uriError" => false,
            "resourceId" => null,
            "obs" => true
        );
    }
    echo CJavaScript::encode( $liveSources );
?> );
yiiModel.removeSource = function() {
    if ( yiiModel.liveSources().length > 1 ){
        yiiModel.liveSources.remove(this);
    } else {
        yiiModel.liveSources( [ { name: ko.observable(''), uri:ko.observable(''), obs: true} ] );
    }
};

//]]></script>