<?php /* @var $this Controller */ 
    $this->beginContent('//layouts/main'); 
?>


<div id="head-nav" class="navbar navbar-default navbar-fixed-top">
    <div class="container-fluid">
        <!-- Left Menu Side -->
        <div class="navbar-header">
            <!-- Toggle Button visible for Extra Small Devices -->
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </button>
            <!-- Brand Logo -->
            <?php echo CHtml::link( $this->name, array('/main/index'), array( 'class'=>"navbar-brand") ); ?>            
        </div>
        <!-- Right Menu Side -->
        <div class="navbar-collapse collapse">
            <!-- Left Menu Items -->
            <?php
                $this->widget('zii.widgets.CMenu', array(
                    'htmlOptions' => array( 'class' => "nav navbar-nav" ),
                    'submenuHtmlOptions' => array( 'class' => "dropdown-menu" ),
                    'activateParents' => true,
                    'items' => $this->menu,
                    'encodeLabel' => false
                ));
            ?>                
                       
            <ul class="nav navbar-nav navbar-right not-nav">
                <!-- Right Menu Notification Items -->
                <?php if ( Yii::app()->user->checkAccess('viewLogs') || Yii::app()->user->checkAccess('useControlCenter') ) { ?>
                <li class="spx-top-icon"><?php echo CHtml::link(CHtml::tag("i", array( 'class'=>'fa fa-cogs'), "" ), array('/controlcenter/main/index'), array());?></li>
                <?php } ?>
                <li class="spx-top-icon"><?php echo CHtml::link(CHtml::tag("i", array( 'class'=>'fa fa-user'), "" ), array('/controlcenter/user/profile'), array());?></li>
                <li class="spx-top-icon"><?php echo CHtml::link(CHtml::tag("i", array( 'class'=>'fa fa-sign-out'), "" ), array( "/user/logout"), array());?></li>
            </ul> 
        </div>
    </div>
</div>


<div id="cl-wrapper">
<?php 
    if ( $this->sidebar ) {
        echo CHtml::openTag( "div", array( "class"=>"cl-sidebar" ) );
        echo CHtml::tag( "div", array( "class"=>"cl-toggle" ),
                CHtml::tag( "i", array( "class"=>"fa fa-reorder" ), "" )."\n"
        );
        echo CHtml::tag( "div", array( "class"=>"cl-navblock" ), "\n" . $this->sidebar ."\n" );        
        echo CHtml::closeTag("div");
    }
?>
    <div class="container-fluid" id="pcont">
<?php
    $status = new Status;
    if ( !$status->getFirmwareok() ){
        $product = Yii::app()->branding->product;
        $info = "";
        $info .= "<h3>Corrupted Firmware</h3>\n"; 
        $info .= "<p>";
        $info .= "The current install of the $product firmware is corrupted.\n";
        $info .= "This has probably been caused by a power cut during a firmware upgrade.";
        $info .= "In this case the system becomes corrupted, no further updates are possible and your system may be unstable.";
        $info .= "</p>";
        $info .= "<p>";
        $info .= "To recover from this state do the following:";
        $info .= "</p>";
        $info .= "<ul>";
        $info .= "	<li>Restart the $product in diagnostics mode by clicking the \"Start Recovery Mode\" button below.</li>\n"; 
        $info .= "	<li>Allow for up to 2 mins for the $product to restart in recovery mode where diagnostics can be run and the firmware re-installed.</li>\n"; 
        $info .= "	<li>Click on the install factory image button, this will reinstall the factory firmware from scratch.</li>\n";
        $info .= "	<li>Wait until the page shows that the install process is finished, if your browser times out you can repeatedly reload the page until it shows that the install is finished.</li>\n";
        $info .= "	<li>Now your $product is back with the factory firmware and with factory default configuration as if it was a new unit.</li>\n";
        $info .= "	<li>Click the reboot button.</li>\n";
        $info .= "</ul>";
        $info .= $this->widget( 'DialogButton' , array(
            'label' => "Start Recovery Mode",
            'link' => array("/controlcenter/operation/reboot", 'rebootrecovery'=>true, ),
            'ko' => 'startRecoveryMode',
            'content' => false
        ), true);
        echo BsHtml::alert( BsHtml::ALERT_COLOR_WARNING, $info );
        
        $inf = new BasicInfo;
        $redirect = "http://".$inf->hostname.".local/";	
        $recTxt = "<p>The unit is always reachable at <a href='http://".$inf->hostname.".local/'>http://".$inf->hostname.".local</a> from Zeroconf enabled computers on the local network.</p>";
        $recTxt .= CHtml::tag("p", array(),  "Please use the <a href='http://".$inf->hostname.".local/'>following link</a> to refresh the interface."). "\n";
?>
<script type="text/javascript" >
//<![CDATA[

function startRecoveryMode( model, ev ) {
    yiiModel.doAjaxButton( model, ev, 
        function( ev, response ) {
            yiiModel.redirect = <?php echo CJavaScript::encode($redirect); ?>;
            spxapi.ui.message( { 
                type: 'info', 
                title: "Recovery Mode",
                sticky: true,
                text: <?php echo CJavaScript::encode($recTxt); ?>
            } );
        }
    );
};

//]]></script>
<?php
    }
    if ( $status->getSafemode() ){
        $product = Yii::app()->branding->product;
        $info = "";
        $info .= "<h3>Safe Mode</h3>\n"; 
        $info .= "<p>The $product is currently running in safe mode.\n";  
        $info .= "It means that most features are disabled and that the player is displaying a black screen with a blinking rectangle.</p>\n"; 
        $info .= "<p>The main reasons for the $product to arrive in safe mode are files that cannot be display properly.\n";  
        $info .= "For instance JavaScript code creating an infinite loop, or files much too complex to be rendered by the player.</p>\n"; 
        $info .= "<p>To leave the safe mode, please go to the ".CHtml::link("Operation page", array( '/controlcenter/main/operations', '#'=>'Maintenance' ) )." and restart the $product. </p>\n"; 
        $info .= "<p>Make sure that the faulty content has been removed from the player before the restart.\n"; 
        $info .= "This can be done either by uploading new content to the player or \n"; 
        $info .= "using the 'Restore Default Content' button from the ".CHtml::link("Operation page", array( '/controlcenter/main/operations', '#'=>'Reset' ))."\n";  
        $info .= "<p>The $product will automatically reboot if left in Safe Mode for more than one hour.</p>\n";
        echo BsHtml::alert( BsHtml::ALERT_COLOR_WARNING, $info );
    }    
?>
<script type="text/javascript" >
//<![CDATA[

function _spxapi_getCSRFdata( data ){
    var ret = $.extend({}, data);
    ret['<?php echo Yii::app()->request->csrfTokenName;?>'] =
        '<?php echo CJavaScript::quote(Yii::app()->request->csrfToken);?>';
    return ret;
}

//]]></script>
<?php
    if ( $this->title ) {
?>
        <div class="page-head">
            <?php echo $this->topBar;?>
            <!--h2><?php echo $this->title;?></h2-->
            <ol class="breadcrumb">
<?php                 
foreach ( $this->breadcrumbs as $name => $link ){
    if ( $name === "ko" ){
        echo "<!-- ko foreach: $link -->" ."\n";
        echo "<!-- ko ifnot: active -->" ."\n";
        echo CHtml::tag( "li", array( ),
            CHtml::link( "", "#", array( "data-bind"=>"text: name, click: function() { breadcrumbsRecurs( \$parent.$link, \$index ); }" )
            ) ) ."\n";
        echo "<!-- /ko -->" ."\n";
        echo "<!-- ko if: active -->" ."\n";
        echo CHtml::tag( "li", array( "class"=>'active' ), 
                    CHtml::tag( "span", array( "class"=>'hidden-xs', "data-bind"=>"text: name" ), " ") . 
                    CHtml::tag( "span", array( "class"=>'visible-xs-inline', "data-bind"=>"text: ko.unwrap(name).length>10?ko.unwrap(name).substr(0,17)+'...':ko.unwrap(name)" ), " ") 
             ) ."\n";
        echo "<!-- /ko -->" ."\n";
        echo "<!-- /ko -->" ."\n";
    } else if ( $link == "" )
        echo CHtml::tag( "li", array( "class"=>"active" ), $name );
    else if (is_numeric($name) )
        echo CHtml::tag( "li", array( "class"=>"active" ), $link );
    else 
        echo CHtml::tag( "li", array(), CHtml::link( $name, $link ) );
}    
?>
            </ol>
            
        </div>	
<?php } ?>
        <div class="cl-mcont">
            <?php echo $content; ?>
        </div>        
    </div>
</div>
<script type="text/javascript" >
//<![CDATA[

function breadcrumbsRecurs( data, idx ) {
    for ( var i=data().length-1; i>=idx(); i-- ) { 
        if ( data()[i].click ) {
            data()[i].click();
        }
    }
}
/*
function maxWidth() {
    var target = $('#cl-wrapper');
    target.width('100%');
    var width = target.width();
    var height = $( window ).height();
    if ( width > 4/3*height ){
        target.width( 4/3*height );
    }
}
$( window ).resize(function() {maxWidth();} );
$(function() { maxWidth();} );
*/
//]]></script>
<?php 
$this->endContent(); 
