#!/bin/sh

#
# Copyright (C) 2020 SpinetiX
#

set_led_off() {
    local led="$1"
    echo 0 > /sys/class/leds/"$led"/brightness
}

set_led_on() {
    local led="$1"
    echo none > /sys/class/leds/"$led"/trigger
    echo 255 > /sys/class/leds/"$led"/brightness
}

set_led_blink() {
    local led="$1"
    local offms="$2"
    local onms="$3"
    echo timer > /sys/class/leds/"$led"/trigger
    echo "$offms" > /sys/class/leds/"$led"/delay_off
    echo "$onms" > /sys/class/leds/"$led"/delay_on
    echo 255 > /sys/class/leds/"$led"/brightness
}

init_net_leds() {
    [ -f /usr/share/resources/default/init/main ] && . /usr/share/resources/default/init/main
    [ -f /etc/spinetix/identifiers ] && . /etc/spinetix/identifiers

    if [ "$SPX_HW_TYPE" = "fukiran" ]; then
        if [ "$rc_has_wlan" = "yes" -a -e /sys/class/ieee80211/phy0 ]; then
            if [ ! -f /etc/spxmanage/configured -a ! -d /usr/share/spxrecovery ]; then
                # device not configured and not in recovery: wireless LED blinks yellow at 1 Hz
                set_led_off wireless:blue:bluetooth
                set_led_blink wireless:green:wlan 500 500
                set_led_blink wireless:red:wlan 500 500
            elif ! grep -q '^\s*auto\s\+wlan0\b' /etc/network/interfaces; then
                # device configured without Wi-Fi: wireless LED solid yellow
                set_led_off wireless:blue:bluetooth
                set_led_on wireless:green:wlan
                set_led_on wireless:red:wlan
            else
                # device configured with Wi-Fi: wireless LED blinks red at 1 Hz initially
                set_led_off wireless:blue:bluetooth
                set_led_off wireless:green:wlan
                set_led_blink wireless:red:wlan 500 500
            fi
        else
            # no Wi-Fi module or functionality disabled by resources: wireless LED off
            set_led_off wireless:blue:bluetooth
            set_led_off wireless:green:wlan
            set_led_off wireless:red:wlan
        fi
    fi
}

case "$1" in
    start)
	init_net_leds
	;;
    stop|restart|reload|force-reload)
	;;
    *)
esac
