<?php

class UploadedFilePut extends CUploadedFile { 

    var $tempName;
    var $name = null;
    var $type = null;
    var $extensionName = null;
    
    public function __construct() {
        $this->tempName = tempnam( sys_get_temp_dir(), "PUT" );
        /* PUT data comes in on the stdin stream */
        $putdata = fopen("php://input", "r");

        /* Open a file for writing */
        $fp = fopen($this->tempName, "w");

        /* Read the data 1 KB at a time
           and write to the file */
        while ($data = fread($putdata, 1024)){
          fwrite($fp, $data);
        }

        /* Close the streams */
        fclose($fp);
        fclose($putdata);
        if ( isset($_SERVER["CONTENT_TYPE"]) )
            $this->type = $_SERVER["CONTENT_TYPE"];
        if ( isset($_SERVER["REQUEST_URI"]) ){
            $info = pathinfo( $_SERVER["REQUEST_URI"] );
            $this->name = $info['basename'];
            if ( isset($info['extension']) ) {
                $this->extensionName = $info['extension'];
            } else {
                
                if ( $this->type === 'image/jpeg' ){
                    $this->name .= ".jpg";
                    $this->extensionName = 'jpg';
                } else if ( $this->type === 'image/png' ){
                    $this->name .= ".png";
                    $this->extensionName = 'png'; 
                }                
            }
        }
    }
    public function __destruct() {
        if (file_exists($this->tempName ) )
            unlink( $this->tempName );
    }
    public function saveAs( $file, $deleteTempFile=true ) {
        if ($deleteTempFile)
            return rename( $this->tempName, $file );
        else
            return copy( $this->tempName, $file );
        
    }
    public function getError(){
        return 0;
    }
    public function getSize(){
        return filesize($this->tempName);
    }
    public function getExtensionName(){
        return $this->extensionName;
    }
    public function getTempName(){
        return $this->tempName;
    }
}
