var Media = function( data, args ) {
    
    args = args || { };
    
    var self = {
        name: ko.observable( ),        
        keywords: ko.observable(),        
        img: ko.observable(),
        properties: [],
        id: ko.observable( 'new media' ),
        manage: ko.observable(),
        hidden: ko.observable(),
    };
    
    self.fromJS = function( data ) {
        if ( data.id ) {
            self.id( data.id );
        }
        self.manage( data.manage );   
        self.hidden( data.hidden ); 
        
        self.name( data.name );
        if ( data.keywords ){
            self.keywords( data.keywords.join(",") );
        }
        if ( data.img ){
            self.img( data.img );
        } else {
            self.img( null );
        }      
             
        self.dimension = data.dimension;
        self.aspectRatio = data.aspectRatio;
        if ( data.active ){
            spxapi.ui.message({
                type: 'info',
                title: spxapi.t('Live Content'),
                text: spxapi.t("This is currently displayed on the screen")            
            });            
        }
    };
    self.fromJS( data );
    
    self.toJS = function(){
        var data = {
            name: self.name(),
            hidden: self.hidden()
        };
        if ( self.keywords() ){
            data.keywords = self.keywords().split(",");
        }        
        return data;        
    };
    self.toJSON = function(){
        return JSON.stringify( self.toJS() );
    };
      
    self.preview = ko.computed( function() {
        if ( self.img() ){
            return self.img();
        }
        var model = spxapi.resources.get( self.id() );
        return model.snapshots.single.src();
    });
    var darkroom = null;
    self.preview.subscribe( function( newValue ) {
        if ( darkroom ){
            darkroom.selfDestroy();
        }
        if ( self.img() ){
            new Darkroom('#target');
        }
    });
    
    self.properties.push( { name: spxapi.t('Name'), type : 'string', value: self.name } );        
    self.properties.push( { name: spxapi.t('Keywords'), type : 'tags', value: self.keywords, options: { tags: keywordsMemory().get() } } );
    if ( args.manageTemplate ){
        self.properties.push( { name: spxapi.t('Hidden'), type : 'boolean', value: self.hidden } );
    }
    self.breadcrumbs = ko.observableArray([ { 
        name: self.name,
        active: ko.observable( true ),
        click: self.stopEdit
    } ]).extend({ rateLimit: 0 });

    return self;
};

function MediaEdit( args ) {
    
    args = args || {};
    var self = this;
    
    self.media = new Media({
            name: spxapi.t("New media"),      
        }, {
            manageTemplate: args.manageTemplate
    });
    //console.log( self.media );
    
    self.id = args.id;
    self.status = new ko.dirtyFlag( self.media, true );
    
    self.load = function(){
        if ( self.id ){
            self.media.name( spxapi.t( "Loading ..." ) );
            spxapi.media.get( spxapi.media.uri + self.id + "/" )
            .done( function( data ){
                self.media.fromJS( data );
                self.status.reset();
            });
        } else {
            self.status.reset();
        }
    };
    self.load();
    
    self.saving = ko.observable();
    self.apply = function ( data, event ) {
        spxapi.ui.loading(event.target);
        var params = self.media.toJS();
        if( self.id ) {
            return spxapi.media.updateData( self.media.manage(), params ).done(function(){
                self.status.reset();                
            }).always( function() {
                spxapi.ui.reset(event.target);
            });
        } else {
            return spxapi.media.create( params ).done(function( data ){
                self.status.reset();
                
                // if this is a new item, then we complete it
                var memory = spxapi.storage.get("spx-calendar-new-item" );
                if ( memory ){
                    var newItem = JSON.parse( memory );
                    newItem.title = data.name;
                    newItem.resource = {
                        id: data.id,
                        type: data.type
                    };                    
                    spxapi.storage.set("spx-calendar-new-item", JSON.stringify( newItem ) );
                }                
            }).always( function() {
                spxapi.ui.reset(event.target);
            });
        }
    };
    self.cancel = function ( data, event ) { 
        location.href = document.referrer; 
    };
    self.save = function ( data, event ) {
        self.apply( data, event ).done( function() {
            self.cancel( data, event );
        });
    };
    self.updateMedia = function ( data, event ) {
        self.media.fromJS( data );
        self.status.reset();
    };
    self.breadcrumbs = ko.computed( function() {
        return self.media.breadcrumbs();
    });
    // Prevent leaving the page with changes
    $(window).bind('beforeunload', function(e){
        if ( self.status.isDirty() ) {
            return spxapi.t( "Some changes have not been saved." );
        } else {
            return;
        }
    });
};
