<?php

/**
 * Description of I18N
 *
 * @author jr
 */
class I18N {    
    static protected $_appsTranslationFile = array();    
    
    static function i( $message ){
        return $message;
    }
    static function t( $message, array $params=array ( ), string $source=NULL, string $language=NULL ){
        return Yii::t('app', $message, $params, $source, $language );
    }
    static function ht( $message, array $params=array ( ), string $source=NULL, string $language=NULL ){
        return htmlentities( Yii::t('app', $message, $params, $source, $language ) );
    }
    
    static function js(){
        $script = Yii::app()->baseUrl.'/i18njs.php?lang='.Yii::app()->getLanguage();
        if ( defined('YII_DEBUG') && YII_DEBUG ){
            $script .= "&debug=1";
        }
        Yii::app()->clientScript->registerScriptFile($script,CClientScript::POS_HEAD);
        Yii::app()->clientScript->registerScript('setLanguage', 'spxapi.locale.setLang( "'.Yii::app()->getLanguage().'" );', CClientScript::POS_END);        
    }
    static function appsName( $path, $name ){
        if ( !isset(Yii::app()->user) || !Yii::app()->user ){
            return $name;
        }
        $cacheName = $path .":". Yii::app()->getLanguage() . ":" . $name;
        $translated = Yii::app()->user->getState($cacheName, false );
        if ( !$translated ){
            $translations = self::apps( $path );
            if (is_array($translations) && isset( $translations[$name]) ){
                $translated = $translations[$name];
            } else {
                $translated = $name;
            }
            Yii::app()->user->setState($cacheName, $translated );
        }
        return $translated;
    }
    static function apps( $path ){   
        if ( isset(self::$_appsTranslationFile[ $path ])){
            $translations = self::$_appsTranslationFile[ $path ];           
        } else {
            $file = new CGettextPoFile();
            $fileName = $path."/messages/".Yii::app()->getLanguage().".po";
            if ( file_exists( $fileName ) ){
                $translations = $file->load( $fileName, "app" );
            } else {
                $translations = new stdClass;
            }        
            self::$_appsTranslationFile[ $path ] = $translations;
        }        
        return $translations;
    }    
}
