<?php
class PlayerLicenses extends CFormModel
{
    public $file = "/etc/spinetix/licenses";

    public $license = null;
    public function rules()
    {
        $res = array(
            array("license", 'match', 'pattern' => '/^[\w\s=\+-\/]*$/'),
        );
        return $res;
    }

    function load()
    {
        if (file_exists($this->file)) {
            $this->license = trim(file_get_contents($this->file));
        }
        if ($this->license === "") {
            $this->license = null;
        }
    }

    function save()
    {
        MaintenanceJobs::licenseupdate($this->license);
    }
}
