<?php

require_once dirname(__FILE__) . '/../utils/MainInfo.php';

/**
 * Controller is the customized base controller class.
 * All controller classes for this application should extend from this base class.
 */
class Controller extends CController
{
    /**
     * @var string the default layout for the controller view. Defaults to '//layouts/column1',
     * meaning using a single column layout. See 'protected/views/layouts/column1.php'.
     */
    public $layout = '//layouts/menu';
    /**
     * @var array context menu items. This property will be assigned to {@link CMenu::items}.
     */
    public $menu;
    /**
     * @var array the breadcrumbs of the current page. The value of this property will
     * be assigned to {@link CBreadcrumbs::links}. Please refer to {@link CBreadcrumbs::links}
     * for more details on how to specify this property.
     */
    public $breadcrumbs = array();

    /**
     * @var string Serial number of the device
     */
    public $serial;

    /**
     * @var string Service Serial number of the device
     */
    public $serviceSerial;

    /**
     * @var string Name of the device
     */
    public $name;
    /**
     * @var string Model of the device (Bonsai, Sakura, ikebana)
     */
    public $model;
    /**
     * @var string Hardware revision of the device
     */
    public $hardware;

    protected $template = "";
    protected $localScript = "var yiiModel = {};\n";
    protected $bases = array("yiiModel");
    public $title = "";
    public $topBar = "";

    public $sidebar = null;
    public function filters()
    {
        return array('accessControl');
    }
    public function accessRules()
    {
        return array(
            array('allow', 'actions' => array('login'), 'users' => array('*')),
            array(
                'allow',
                'controllers' => array('user'),
                'users' => array('*'),
            ),
            array('deny', 'users' => array('?')),
        );
    }
    public function registerTemplates($template)
    {
        $this->template .= $template;
    }
    public function registerSpxScript($script)
    {
        $baseFile = dirname(__FILE__) . "/../../";
        $baseUrl = Yii::app()->baseUrl;
        $url = $baseUrl . '/js/spx-model/' . $script;
        $lastMod = @filemtime($baseFile . $url);
        $url .= "?_=$lastMod";
        $cs = Yii::app()->getClientScript();
        $cs->registerScriptFile($url, CClientScript::POS_BEGIN);
    }
    public function ajaxOnly()
    {
        if (!Yii::app()->request->isAjaxRequest) {
            throw new CHttpException(400, "Ajax only");
        }
        $this->layout = '//layouts/jason';
    }
    public function helpButton(
        $options = array('tooltipPosition' => 'auto'),
        $function = "startIntro",
        $divOptions = array(),
        $btnOptions = array()
    ) {
        $ret = "";
        $this->addClass($divOptions, "pull-right btn-group");
        $this->addClass($btnOptions, "btn btn-default");
        $btnOptions['data-bind'] = "click: function() { $function(); }";
        $ret .= CHtml::openTag("div", $divOptions);
        $ret .= CHtml::tag(
            "span",
            $btnOptions,
            CHtml::tag("i", array("class" => "fa fa-question"), "")
        );
        $ret .= CHtml::closeTag("div") . "\n";
        $visibleSteps = array();
        foreach ($options['steps'] as $idx => &$option) {
            if (isset($option['visible'])) {
                if ($option['visible']) {
                    unset($option['visible']);
                    $visibleSteps[] = $option;
                }
            } else {
                $visibleSteps[] = $option;
            }
        }

        $options['nextLabel'] = I18N::t('Next');
        $options['prevLabel'] = I18N::t('Back');
        $options['skipLabel'] = I18N::t('Skip');
        $options['doneLabel'] = I18N::t('Done');

        $options['steps'] = $visibleSteps;
        $script = "function $function(){" . "\n";
        $script .= "    var intro = introJs();" . "\n";
        $script .=
            "    intro.setOptions( " .
            CJavaScript::encode($options) .
            " );" .
            "\n";
        $script .= "    intro.start();" . "\n";
        $script .= "}";
        $ret .= CHtml::script($script) . "\n";
        return $ret;
    }
    public function addOptions(&$options, $newOptions)
    {
        foreach ($newOptions as $name => $value) {
            $sep = "; ";
            switch ($name) {
                case 'class':
                    $sep = " ";
                    break;
                case 'data-bind':
                    $sep = ", ";
                    break;
            }
            if (isset($options[$name])) {
                $options[$name] .= $sep . $value;
            } else {
                $options[$name] = $value;
            }
        }
    }
    public function addClass(&$options, $class)
    {
        $this->addOptions($options, array('class' => $class));
    }
    public function addDatabind(&$options, $databind)
    {
        $this->addOptions($options, array('data-bind' => $databind));
    }
    function icon($icon, $options = array())
    {
        $this->addClass($options, "fa fa-" . $icon);
        return CHtml::tag(
            "span",
            array('class' => "input-group-addon"),
            CHtml::tag("i", $options, " ")
        );
    }
    function iconButton($icon, $options = array())
    {
        if (isset($options['html'])) {
            $html = $options['html'];
            unset($options['html']);
        } else {
            $html = "";
        }
        if (isset($options['title'])) {
            $html .= $options['title'];
        }

        $class = "btn";
        if (isset($options['type'])) {
            $class .= " btn-" . $options['type'];
            unset($options['type']);
        } else {
            $class .= " btn-default";
        }
        $this->addClass($options, $class);

        return CHtml::tag(
            "span",
            $options,
            //CHtml::tag("i", array( "class" =>"fa fa-".$icon ), "" ).
            $html
        );
    }
    function iconSet($icons, $options)
    {
        $this->addClass($options, "btn-group");
        $ret = CHtml::openTag("span", $options);
        foreach ($icons as $iconOptions) {
            $icon = $iconOptions['icon'];
            unset($iconOptions['icon']);
            $ret .= $this->iconButton($icon, $iconOptions);
        }
        $ret .= CHtml::closeTag("span");
        return $ret;
    }

    function activeIconInput(
        $name,
        $icon,
        $model,
        $attribute,
        $options = array()
    ) {
        $class = "form-group";
        if ($model->hasErrors($attribute)) {
            $class .= " has-error";
        }

        $output = "";
        $output .= CHtml::openTag("div", array('class' => $class));
        $output .= CHtml::openTag("div", array('class' => "col-sm-12"));
        $output .= CHtml::openTag("div", array('class' => "input-group"));
        $output .= $this->icon($icon);
        if (isset($options['class'])) {
            $options['class'] .= " form-control";
        } else {
            $options['class'] = "form-control";
        }
        $output .= CHtml::$name($model, $attribute, $options);
        $output .= CHtml::closeTag("div");
        $output .= CHtml::closeTag("div");
        $output .= CHtml::closeTag("div");
        return $output;
    }
    function observable($name, $value, $base = null)
    {
        if (!is_string($base)) {
            $base = "yiiModel";
        }
        if (!in_array($base, $this->bases)) {
            $this->localScript .= "$base = {};\n";
            $this->bases[] = $base;
        }
        if ($value instanceof CUploadedFile) {
            $value = null;
        }
        if ($name == 'password') {
            $this->localScript .= "$base.$name = ko.observable( );\n";
        } else {
            $this->localScript .=
                "$base.$name = ko.observable( " .
                CJavaScript::encode($value) .
                " );\n";
        }
    }
    function activeObservable($model, $attributes, $base = null)
    {
        if (!is_array($attributes)) {
            $attributes = array($attributes);
        }
        foreach ($attributes as $attr) {
            $this->observable($attr, $model->$attr, $base);
        }
    }
    function extend($name, $value)
    {
        $this->localScript .=
            "yiiModel." . $name . " = " . CJavaScript::encode($value) . ";\n";
    }
    protected function fixMenu($menu)
    {
        $result = array();
        foreach ($menu as $item) {
            if (isset($item['items'])) {
                $item['itemOptions'] = array('class' => "dropdown");
                $item['template'] =
                    "<a href='#' class='dropdown-toggle' data-toggle='dropdown'>" .
                    $item['label'] .
                    " <b class='caret'></b></a>";
                $item['items'] = $this->fixMenu($item['items']);
            }
            $item['label'] = strtoupper($item['label']);
            $result[] = $item;
        }
        return $result;
    }
    public function init()
    {
        parent::init();
        $info = getInfoSerial($this->serial, $this->model, $this->hardware);
        $this->serviceSerial = $info["altSerial"]["service"];

        $playerConfig = new PlayerConfig();
        $ARYAMode = new ARYAMode();

        $this->name = $playerConfig->deviceName;

        $this->menu = array(
            array(
                'label' => I18N::t('Create'),
                'url' => array('/assets/playing/create'),
                'visible' =>
                    !$ARYAMode->getEnabled() &&
                    (Yii::app()->user->checkAccess('viewMedia') ||
                        Yii::app()->user->checkAccess('viewPlaylist') ||
                        Yii::app()->user->checkAccess('viewPlayout') ||
                        Yii::app()->user->checkAccess('viewApps')),
            ),
            array(
                'label' => I18N::t('Schedule'),
                'url' => array('/assets/playing/schedule'),
                'visible' =>
                    !$ARYAMode->getEnabled() &&
                    Yii::app()->user->checkAccess('viewSchedule'),
            ),
            array(
                'label' => I18N::t('ARYA'),
                'url' => "https://arya.spinetix.cloud",
                'visible' => $ARYAMode->getEnabled(),
            ),
            //array('label'=>'Apps', 'url'=>array('/assets/apps/list'), 'visible' => Yii::app()->user->checkAccess('useApps') ),
        );

        $base = "/srv/raperca/content/";
        $interface = null;
        if (file_exists($base . "index.html")) {
            $interface = "index.html";
        } elseif (file_exists($base . "interface/index.html")) {
            $interface = "interface/index.html";
        }
        if ($interface !== null) {
            $index = file_get_contents($base . $interface);
            if (preg_match("|<title>([^<]+)</title>|", $index, $matches)) {
                $this->menu[] = array(
                    'label' => $matches[1],
                    'url' => array("/uiauth/content/" . $interface),
                    'visible' =>
                        Yii::app()->device->model !== 'ikebana' ||
                        Yii::app()->user->checkAccess('manageMedia'),
                    'linkOptions' => array('style' => 'max-width: 20ch; ' .
                        'white-space: nowrap; overflow: hidden; ' .
                        'text-overflow: ellipsis'),
                );
            }
        }
        $this->menu = $this->fixMenu($this->menu);
    }
}
