<?php /* @var $this Controller */ 

// We use a PHP script responce for this as we want to make sure that all previously send php request are over
// this is based on the hypothesis that a single PHP request can be served at the time.
$urlAlive = CHtml::normalizeUrl( "/main/checkAlive" );

function getUrl( $name, $ext ) {
    $base = dirname(__FILE__)."/../../../";
    $url = "$name.min.$ext";
    if ( !file_exists( $base.$url ) ){
        $url = "";
    }
    if ( empty( $url) || ( defined('YII_DEBUG') && YII_DEBUG )){
        $url2 = "$name.$ext";
        if ( file_exists( $base.$url2 ) ){
            $url = $url2;             
        } else {
            if ( substr( $url2, -9, 4 ) === ".zh-" ) {
                $url2 = substr($url2,0, -5 ) . strtoupper( substr($url2,-5, 2) ). substr($url2, -3 );
                if ( file_exists( $base.$url2 ) ){
                    $url = $url2;             
                }
            }            
        }
        if ( empty( $url) ){
            throw new CHttpException(404,"Script not found: $url2");;
        }
    } 
    $lastMod = filemtime( $base.$url );
    return $url . "?_=$lastMod";
   
}
function addScript( $name ){
     echo CHtml::scriptFile( getUrl( $name, "js")  ) ."\n";
}
function addCSS( $name ){
     echo CHtml::cssFile( getUrl( $name, "css")  ) ."\n";
}
function addScriptAndCSS( $name ){
    addScript( $name );
    addCSS( $name );
}
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <link rel="apple-touch-icon" sizes="180x180" href="/images/apple-touch-icon.png">
        <link rel="icon" type="image/png" href="/images/favicon-32x32.png" sizes="32x32">
        <link rel="icon" type="image/png" href="/images/favicon-16x16.png" sizes="16x16">
        <link rel="manifest" href="/images/manifest.json">
        <link rel="mask-icon" href="/images/safari-pinned-tab.svg" color="#5bbad5">
        <link rel="shortcut icon" href="/images/favicon.ico">
        <meta name="msapplication-config" content="/images/browserconfig.xml">
        <meta name="theme-color" content="#ffffff">
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="description" content="">
        <meta name="author" content="">
        <title>#<?php         
        $route = explode("/", Yii::app()->controller->route) ;
        if ( count($route) > 2 ){            
            if ( $route[0] == "controlcenter" ){
                if ( $route[2] == 'index'){
                    echo $this->serial . " - Control Center";
                } else {
                    echo $this->serial . " - Control Center - " . ucfirst($route[2]);
                }
            } else if ( $route[1] == "playing" ){
                echo $this->serial . " - " . ucfirst($route[2]);
            } else if ( $route[1] == "apps" && isset( Yii::app()->controller->title ) ){
                echo $this->serial . " - " . Yii::app()->controller->title;
            } else if ( $route[2] == "edit" ){
                echo $this->serial . " - " . ucfirst($route[1]);
            } else {
                echo $this->serial . " - " . ucfirst($route[1]). " - " . ucfirst($route[2]);
            }
        } else {
            echo $this->serial;
        }
        ?></title>
        <!--link href='https://fonts.googleapis.com/css?family=Open+Sans:400,300,600,400italic,700,800' rel='stylesheet' type='text/css'>
        <link href='https://fonts.googleapis.com/css?family=Raleway:300,200,100' rel='stylesheet' type='text/css'-->
<?php
    addScript(  "/js/jquery/jquery");
    
    addScript(  "/js/spx-api");
    I18N::js();
    echo CHtml::scriptFile( "/timezones.php" ) ."\n";
    
    // Bootstrap core CSS
    addCSS(     "/js/bootstrap/css/bootstrap");
    addCSS(     "/fonts/font-awesome-4/css/font-awesome");
    
    // Plugins Includes
    addCSS(     "/js/jquery.ui/jquery-ui");
    
    addScript(  "/js/jquery.nanoscroller/jquery.nanoscroller");
    addCSS(     "/js/jquery.nanoscroller/nanoscroller");
    
    addScript(  "/js/bootstrap.datetimepicker/js/bootstrap-datetimepicker");
    addCSS(     "/js/bootstrap.datetimepicker/css/bootstrap-datetimepicker");
    
    addScript(  "/js/bootstrap.datetimepicker/js/locales/bootstrap-datetimepicker." . Yii::app()->getLanguage() );
    
    addScriptAndCSS(  "/js/bootstrap.switch/bootstrap-switch");
    
    addScriptAndCSS(  "/js/jquery.select2/select2");
    
    addScript(  "/js/jquery.icheck/icheck");
    addCSS(     "/js/jquery.icheck/skins/square/blue");

    addScript(  "/js/jquery.gritter/js/jquery.gritter");
    addCSS(     "/js/jquery.gritter/css/jquery.gritter");
    
    addScriptAndCSS(  "/js/bootstrap.multiselect/bootstrap-multiselect");    
    
    addScript( "/js/jquery.inputmask/jquery.inputmask");
    
    addScript(  "/js/bootstrap-slider/js/bootstrap-slider");
    addCSS(     "/js/bootstrap-slider/css/slider");
    
    addScript(  "/js/jquery.datatables/media/js/jquery.dataTables");
    addScript(  "/js/jquery.datatables/bootstrap-adapter/js/datatables");
    addCSS(     "/js/jquery.datatables/bootstrap-adapter/css/datatables");
    
    addScript(  "/js/bootstrap.typeahead/typeahead.bundle");
    addCSS(     "/js/bootstrap.typeahead/typeahead");
      
    addScript(  "/js/jquery.ui/jquery-ui");    
    addScript(  "/js/jquery.fileupload/jquery.fileupload");
    addScript(  "/js/jquery.fileupload/load-image/load-image.all");
    addScript(  "/js/jquery.fileupload/canvas-to-blob/canvas-to-blob");
    addScript(  "/js/jquery.fileupload/jquery.fileupload-process");
    addScript(  "/js/jquery.fileupload/jquery.fileupload-image");
    addCSS(     "/js/jquery.fileupload/jquery.fileupload");
    addCSS(     "/js/jquery.fileupload/jquery.fileupload-ui");
    
    addScriptAndCSS(  "/js/bootstrap/bootstrap-select");
    
    addScript(  "/js/bootstrap.colorpicker/js/bootstrap-colorpicker");
    addCSS(     "/js/bootstrap.colorpicker/css/bootstrap-colorpicker");
  
    addScriptAndCSS(  "/js/bootstrap.wizard/bootstrap-wizard");
    
    addScript(  "/js/knockout/knockout");
    echo CHtml::script( "ko.options.foreachHidesDestroyed = true;" ) . "\n";
    addScript(  "/js/knockout/knockout.mapping");
    addScript(  "/js/knockout/knockout.sortable");
    addScript(  "/js/knockout/knockout-bootstrap");
    
    //addScript(  "/js/moment/moment");
    echo CHtml::scriptFile( "/spxjslibs/moment/moment.min.js" ) ."\n";
    echo CHtml::scriptFile( "/spxjslibs/moment/moment-timezone-with-data.min.js" ) ."\n";
    
    addScriptAndCSS(  "/js/jquery.fullcalendar/fullcalendar");
    addScript(  "/js/jquery.fullcalendar/locale-all");
    
    addScript(  "/js/spx-model/localepicker");
    addScript(  "/js/spx-model/timezonepicker");
    
    addScript(  "/js/intro.js/intro");
    addCSS(     "/js/intro.js/introjs");
    
    //addScript(  "/js/spx-api");
    addScript(  "/js/spx-bindings");
    //I18N::js();
    
    addScript(  "/js/spx-model/messages/locales" );
    addScript(  "/js/spx-model/messages/".Yii::app()->getLanguage());
    
    // General Plugins Instances
    addScript(  "/js/behaviour/general");
    
    addScript(  "/js/jquery.ui/jquery.ui.touch-punch");
    addScript(  "/js/bootstrap/js/bootstrap");
    
    // Template Style
    addCSS(     "/css/style");
    addCSS(     "/css/spx-style");
    
    
?>
    </head>
    <body>
        <?php echo $this->template; ?>
        <?php echo $content; ?>             
        <script type="text/javascript" >
//<![CDATA[
loadButtonWithCheck = function( target ) {
    target.button('loading');
    setTimeout( function () {
        $.ajax({
            url: '<?php echo $urlAlive; ?>',
            dataType: 'text'
        }).always( function( ) {
            target.button( 'reset' );
        });        
    }, 500);
};
$(function(){
    //initialize all the general components
    App.init({
        nestableLists: false,
        slider: true,
        selectpicker: true
    });
});
//]]></script>
    </body>
</html>
