<?php

Yii::import('zii.widgets.grid.CGridView');


class BsTable extends CGridView
{
    /**
     * @var string|array the table style.
     * Valid values are BsHtml::GRID_TYPE_STRIPED, BsHtml::GRID_TYPE_BORDERED, BsHtml::GRID_TYPE_CONDENSED and/or
     * BsHtml::GRID_TYPE_HOVER.
     */
    public $type;
    /**
     * @var string the CSS class name for the pager container. Defaults to 'pagination'.
     */
    public $pagerCssClass = 'pagination';
    /**
     * @var array the configuration for the pager.
     * Defaults to <code>array('class'=>'ext.bootstrap.widgets.TbPager')</code>.
     */
    public $pager = array('class' => 'bootstrap.widgets.BsPager');
    
    /**
     * @var string the template to be used to control the layout of various sections in the view.
     */
    public $template = "{items}";

    public $cssFile =  false;
    public $baseScriptUrl = false;
    public $itemsCssClass = 'no-border no-border-y';
    public $hideHeader = true;
    /**
     * Initializes the widget.
     */
    public function init()
    {
        parent::init();
        $classes = array('table');
        if (isset($this->type) && !empty($this->type)) {
            if (is_string($this->type)) {
                $this->type = explode(' ', $this->type);
            }

            foreach ($this->type as $type) {
                $classes[] = 'table-' . $type;
            }
        }
        if (!empty($classes)) {
            $classes = implode(' ', $classes);
            if (isset($this->itemsCssClass)) {
                $this->itemsCssClass .= ' ' . $classes;
            } else {
                $this->itemsCssClass = $classes;
            }
        }        
    }
    public function run() {
        $this->renderContent();
        $this->renderKeys();        
    }

    /**
     * Creates column objects and initializes them.
     */
    protected function initColumns()
    {
        foreach ($this->columns as $i => $column) {
            if (is_array($column) && !isset($column['class'])) {
                $this->columns[$i]['class'] = 'bootstrap.widgets.BsDataColumn';
            }
        }
        parent::initColumns();
    }

    

}
