#!bin/sh

# The major:minor of the root filesystem
ROOTFSDEV=

# checks if an option is present in a comma separated list of options
has_opt() {
    local opt="$1"
    local optset="$2"

    [ "$opt" = "$optset" ] && return 0
    [ "${optset#$opt,}" != "$optset" ] && return 0
    [ "${optset%,$opt}" != "$optset" ] && return 0
    [ "${optset/,$opt,/}" != "$optset" ] && return 0
    return 1
}

find_rootfs_dev() {
    ROOTFSDEV=
    local mountid parentid dev root mpt mopts other sbopts

    while read mountid parentid dev root mpt mopts other; do
        [ "$root" = / ] || continue
        [ "$mpt" = / ] || continue
        ROOTFSDEV="$dev"
    done < /proc/self/mountinfo
}

fixup_rw_bind_from_root() {
    local mountpoint="$1"
    local mountid parentid dev root mpt mopts other sbopts

    [ -n "$ROOTFSDEV" ] || find_rootfs_dev
    while read mountid parentid dev root mpt mopts other; do
        [ "$mpt" = "$mountpoint" ] || continue
        [ "$dev" = "$ROOTFSDEV" ] || continue
        has_opt rw "$mopts" && continue
        sbopts="$(echo "$other" | sed -e 's/\(\|.*\s\)-\s\+//;s/\S\+\s\+\S\+\s\+//')"
        has_opt rw "$sbopts" || continue
        # mount is not rw but super-block is rw => remount rw
        mount -o remount,rw "$mountpoint"
        return
    done < /proc/self/mountinfo
}

fixup_bind_mounts() {
    local dev mpt fstype opts junk

    while read dev mpt fstype opts junk; do
        [ "${dev#/}" != "$dev" ] || continue
        has_opt bind "$opts" || continue
        has_opt ro "$opts" && continue
        fixup_rw_bind_from_root "$mpt"
    done < /etc/fstab
}

case "$1" in
    start|restart)
        fixup_bind_mounts
        ;;
    stop|reload|force-reload)
        ;;
    *)
esac
