<?php

/*
 * Created on 30 Oct 2007
 * By julien reichel <julien.reichel@spinetix.com>
 */
header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
header("Expires: Sat, 13 Jan 1973 15:55:00 GMT"); // Date in the past
if (isset($_GET["png"])) {
    header("Content-type: image/png");
    $opts = "";
} else {
    header("Content-type: image/jpeg");
    $opts = "-j";
}
if ($_SERVER['REQUEST_METHOD'] == 'HEAD') {
    echo "\n";
} elseif ($_SERVER['REQUEST_METHOD'] == 'GET') {
    $cpuinfo = file_get_contents("/proc/cpuinfo");
    $identifiers_path = "/etc/spinetix/identifiers";
    if (file_exists($identifiers_path)) {
        $identifiers = file_get_contents($identifiers_path);
    } else {
        $identifiers = "";
    }

    $model = "[undefined]";
    if (preg_match("/Hardware\W+:\s+(\w+)/", $cpuinfo, $match)) {
        $model = $match[1];
    } elseif (
        preg_match(
            '/^\s*SPX_HW_TYPE=(\'|"|)((?![\'"]).*?)\1\s*$/m',
            $identifiers,
            $match
        )
    ) {
        $model = $match[2];
    }

    $ret = 1;
    if (PHP_OS == "WINNT") {
        $ret = 1;
    } elseif ($model == 'Bonsai') {
        passthru("fbgrab $opts -d /dev/fb/1", $ret);
    } elseif ($model == 'Sakura') {
        passthru("vograb $opts -d /dev/video2 -", $ret);
    } elseif ($model == 'ikebana') {
        passthru("vograb $opts -d /dev/video1 -", $ret);
    } elseif (!isset($_GET["png"])) {
        $snapshotFile = "/var/run/raperca/screenshot.jpg";
        if (file_exists($snapshotFile)) {
            unlink($snapshotFile);
        }
        try {
            $dbus = new Dbus(Dbus::BUS_SYSTEM, false);
            $raperca = $dbus->createProxy(
                'com.spinetix.raperca', '/com/spinetix/SpxPlayer/Raperca', 
                'com.spinetix.SpxPlayer.Raperca1.Player');
            $snapshot = $raperca->RequestSnapshot($snapshotFile);
            //syslog(LOG_DEBUG, 'snapshot: ' . print_r($snapshot, true));
            if (file_exists($snapshotFile)) {
                echo file_get_contents($snapshotFile);
                $ret = 0;
                unlink($snapshotFile);
            }
        } catch (Exception $e) {
            syslog(LOG_ERR, $e->getMessage());
        }
    }
    if ($ret != 0) {
        if (isset($_GET["png"])) {
            echo file_get_contents("img/snapshot.png");
        } else {
            echo file_get_contents("img/snapshot.jpg");
        }
    }
}
