<?php
/* @var $this OperationController */

   
$form = $this->beginWidget('SimpleForm', array( 
    'title' => "Reset",
    'id' => "Reset",
    'button' => "Clear Selected",
    'action' => array( 'post' => array("operation/reset" ),
                'ko' => 'doAjaxForm')
) );
    $this->widget( 'DialogButton' , array(
        'label' => "Restore Default Content",
        'link' => array("operation/reset", 'targets[]'=>'content'),
        'ko' => 'doAjaxButton',        
        'level' => BsHtml::ALERT_COLOR_WARNING,
        'content' => "Pressing 'Restore Default Content' will remove all content from the local storage and replace it by the factory default content.",
    ));
    $this->widget( 'DialogButton' , array(
        'label' => "Reset to Factory",
        'link' => array("operation/reset", 'targets[]'=>'factory'),
        'ko' => 'doAjaxButton',        
        'level' => BsHtml::ALERT_COLOR_WARNING,
        'content' => "Pressing 'Reset to Factory' will restore all the settings of the ".Yii::app()->branding->product." to their initial factory values.".
                     "It will also remove all content from the local storage and replace it by the factory default content.",
    ));
    $this->widget( 'DialogButton' , array(
        'label' => "Format Internal Storage",
        'link' => array("operation/reset", 'targets[]'=>'storage'),
        'ko' => 'doAjaxButton',        
        'level' => BsHtml::ALERT_COLOR_WARNING,
        'content' => "Pressing 'Format Internal Storage' will format the local storage and restore it to the factory state.",
    ));
    echo $form->formGroup(array(
        $form->checkBox( "Logs", "targets[]", false, array('value'=>"logs") ),
        $form->checkBox( "Cache", "targets[]", false, array('value'=>"cache") ),
        $form->checkBox( "Clock calibration", "targets[]", false, array('value'=>"ntp") )
    ));
    
    echo $form->formGroup(array(
        $form->checkBox( "Shared variables", "targets[]", false, array('value'=>"webstorage") ),
        $form->checkBox( "Splash screen", "targets[]", false, array('value'=>"splash") ),
        Yii::app()->branding->hasRight('interactivity')?
            $form->checkBox( "Touchscreen calibration", "targets[]", false, array('value'=>"calibration") ):
            ""
    ));
    echo $form->formGroup(array(
        Yii::app()->branding->hasRight('firmware')?
            $form->checkBox( "Firmware updates server", "targets[]", false, array('value'=>"firmware") ):
            "",
        Yii::app()->branding->hasRight('HTML') ? 
            $form->checkBox("Web page data", "targets[]", false, array(
                'value' => "webPageData")) : "",
        ""
    ));
    
$this->endWidget();
