<?php

class Cockpit extends CFormModel {
	
    protected $config_name = '/etc/raperca/uploaderconf.xml';
    protected $uploadercal = "/etc/raperca/uploader.ics";

    protected $_enabled;
    
    public function rules() {
		$res = array(
            array( "enabled", 'safe' ),           
    	);
        return $res;
	}
    public function attributeLabels()
	{
        $labels = array(
            'enable' => "Enabled",            
		);
        return $labels;
	}
    public function getEnabled() {
        $xlinkNS = 'http://www.w3.org/1999/xlink';

        $config = new DOMDocument;
        $config->loadXML(file_get_contents($this->config_name));
        
        $proj = $config->getElementsByTagName("action");
        foreach ($proj as $action) {
            $name = $action->getAttribute("summary");
            if ($name == 'rpc') {
                $concentrator = $action->getAttributeNS($xlinkNS,"href");
                if (preg_match("/cockpit/", $concentrator) ){
                    return true;
                }                
            }
        }
        
        $schedules = $config->getElementsByTagName("schedule");
        foreach ($schedules as $schedule) {
            $link = $schedule->getAttributeNS($xlinkNS,"href");
            if ( $link == "uploader.ics" || $link == $this->uploadercal ) {
                $ical = file_get_contents( $this->uploadercal );
                if (preg_match("/cockpit/", $ical) ){
                    // could be more fine
                    return true;
                }
            }
        }
        return false;
    }    
}