#!/bin/sh
#
# chkconfig: S 38 0
#
# Sets the hostname and apache header to the serial number of the device
# prepending the prefix from the resources to the hostname

RCMAIN=/usr/share/resources/default/init/main

# Load resources
[ -f "$RCMAIN" ] && . "$RCMAIN"

case "$1" in
    start|restart)
    if [ ! -e /etc/hostname -o ! -e /etc/apache/conf.d/30-spxserial.conf ]; then
	sn="$(sed -ne '/^Serial\s\+/{s,.*:\s\+,,p}' /proc/cpuinfo)"
	if [ $? -ne 0 ]; then
	    echo "failed recovering serial number from /proc/cpuinfo"
	    exit 1
	fi
	hw="$(sed -ne '/^Hardware\s\+/{s,.*:\s\+,,p}' /proc/cpuinfo)"
	if [ $? -ne 0 ]; then
	    echo "failed recovering hardware type from /proc/cpuinfo"
	    exit 1
	fi
	hw="$hw""$rc_hwtype_suffix"
    else
	exit 0
    fi
    if [ -z "$sn" -o "$sn" = "000000000000" -o "$sn" = "0000000000000000" ]; then
	echo "No serial number, using eth0 MAC address as fallback."
	sn="$(sed -e 's/://g' /sys/class/net/eth0/address)"
	if [ -z "$sn" ]; then
	    echo -n "No eth0 MAC address"
	    exit 0
	fi
    fi
    if [ ! -e /etc/hostname ]; then
	echo -n "Setting the hostname to serial number"
	echo "${rc_host_prefix}${sn}" > /etc/hostname
	echo "."
    fi
    if [ ! -e /etc/apache/conf.d/30-spxserial.conf ]; then
	echo -n "Setting apache httpd server name and serial number / hardware headers"
	sed -e "s/@@servername@@/${rc_host_prefix}${sn}.local./;s/@@serial@@/$sn/;s/@@hardware@@/$hw/;" /etc/apache/conf.d/30-spxserial.conf.tmpl > /etc/apache/conf.d/30-spxserial.conf
	echo "."
    fi
    ;;
    stop|reload|force-reload)
    ;;
esac



