#!/bin/sh
#
# chkconfig: S 30 0
#
# Sets special kernel configurations through /proc which are
# not accessible from sysctl.

set_kopts() {
    # Set to fixup+warn for mis-aligned access from user-space
    # (normally the kernels sends a kill signal to process and warns)
    # Disabled as we now no longer have system software make unaligned accesses
#    echo 3 > /proc/cpu/alignment
    : # need at least one command in a function to avoid syntax error
}

case "$1" in
    start|restart|reload|force-reload)
    set_kopts
    ;;
    stop)
    ;;
esac
