<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity
{

    public $user;

    public function __construct($username=null,$password=null) {
		$this->username=$username;
		$this->password=$password;
	}
	/**
	 * Authenticates a user.
	 */
	public function authenticate()
	{
        $record = User::find($this->username);
        
		if( $record === NULL )
			$this->errorCode=self::ERROR_USERNAME_INVALID;
		else if( $record->password !== $this->password )
			$this->errorCode=self::ERROR_PASSWORD_INVALID;
		else {
			$this->errorCode=self::ERROR_NONE;
            $this->user = $record; // associate the record to the Identity 
            //$this->setState('userModel', serialize($record)); // store all the user data in the state, i.e. cookies
        }
		return !$this->errorCode;
	}
}