<?php


class ZipHandler {
    //static $exe = '"C:\Program Files\7-Zip\7za"';
    static $exe = "ulimit -v 8192 && 7za";
    
    var $name;
    var $content=array();
    var $folders=array();
    var $type='7zip';
    
    var $error=null;
    
    
    function open( $name, $type='7z', $list=true ) {
        if(PHP_OS == "WINNT")
            self::$exe = '"C:\Program Files\7-Zip\7za"';
        if ( file_exists($name) ){
            if ( $list ) {
                $ret = $this->getFileList( $name, $type, $this->content, $this->folders );
                if ( $ret!==true ) {
                    $this->error = $ret;
                    return false;
                }
            }
            if(PHP_OS == "WINNT")            
                $this->name = $name;
            else
                $this->name = "'" . str_replace("'", "'\\''", $name) . "'" ;
            $this->type = $type;
            
            return true;
        }
        $this->error = Yii::t('app', 'File not found');
        return false;
    }
    
    function close( ) {
    }
    
    function fileList( ) {
        return sefl::getFileList( $this->name );
    }
    
    static function getFileList( $name, $type, &$content, &$folders ) {
        $out = array();
        $code = 0;
        if(PHP_OS == "WINNT")
            self::$exe = '"C:\Program Files\7-Zip\7za"';
        
        $cmd = self::$exe." l ".$name." 2>&1";
        
        $last = exec( $cmd, $output, $code );
        if ( $code!=0 ) {
            return $this->parseError( $code, $output );
        }
        if ( $type=='zip' ) {
            // check that there are not a single UTF-8 char in the zip file
            foreach ($output as $line ) {
                $enc = mb_detect_encoding($line);
                if ( $enc!="ASCII" ) {
                    return Yii::t('app', 'Zip file contains invalid encoding:')." ".$enc.". ".Yii::t('app', 'Only ASCII characters are supported. Use 7-Zip format for non-ASCII characters.');
                }
            }
        }
		
        foreach ($output as $line ) {
            $ok = preg_match("/\S+\s+\S+\s+(\S+)\s+\S+\s+\S+\s+(.*)/u", $line, $matches);
			if ( !$ok )
				$ok = preg_match("/\S+\s+\S+\s+(\S+)\s+\S+\s+(.*)/u", $line, $matches);
            if ( $ok ){
			    if ($matches[1]=="....." || $matches[1]=="....A"){
                    // file
                    if ( !preg_match("/\.preview/u", $matches[2] ) )
                        $content[]=$matches[2];
                }elseif ($matches[1]=="D...."){
                    // folder
                    $folders[]=$matches[2];
                }
            }
        }
        if ( $type=='zip' && count($folders)>0 && strpos($folders[0], "/")!==false ) {
            // add the base folder in case of zip files, because it is not reported by 7z
            $folders[] = substr($folders[0], 0 , strpos($folders[0], "/") );
        }
        $folders[]= "" ; // always add the root folder
        sort( $folders );
        
        if ( count($content)==0 && count($folders)==0 ) {
            return Yii::t('app', 'Archive contains no files. Make sure you use 7-Zip archive format.'). print_r($output, true);
        } else
            return true;
    }
    function parseError( $code, $output, $ignoreEmpty=false ) {
        if ( $code==0 )
            return null; // nothing wrong
        elseif ( $code==1 ) {
			foreach ( $output as $line ){
				if ( strpos($line, "No files to process")!==false ){
					if ( $ignoreEmpty )
						return null;
					else
						return Yii::t('app', 'File extraction failed.'). " " . Yii::t('app', 'No files found in archive.');
				}
			}
			return Yii::t('app', 'File extraction failed.'). " " . Yii::t('app', 'Your content may be corrupted.');
        } elseif ( $code==2 || $code==8 ) {
            foreach ( $output as $line ){
                if ( strpos($line, "Enter password")!==false ){
                    return Yii::t('app', 'File extraction failed.'). " " . Yii::t('app', 'Is the archive password protected?');
                }
            }
            return Yii::t('app', 'File extraction failed.'). " " . Yii::t('app', 'The compression factor may be too high. Try re-generating the archive with the compression level set to Store or Fast.');
        } elseif ( $code==7 ) {
            return Yii::t('app', 'File extraction failed.'). " " . Yii::t('app', 'Filename may contains invalid characters.');
        } elseif ( $code==255 ) {
            return Yii::t('app', 'File extraction failed.'). " " . Yii::t('app', 'Process interupted.');
        }
        return Yii::t('app', 'File extraction failed.') ." ($code)";
        
    }
    function extractFolderTo( $dest, $basepath, $exclude="", $ignoreEmpty=false ) {
        if(PHP_OS == "WINNT")
            self::$exe = '"C:\Program Files\7-Zip\7za"';
        
        $cmd = self::$exe." x ".$this->name." -xr!.SPXDAV ";
        if ( $exclude!="" ) {
            $cmd .= "-x!".$exclude." ";
        }
        if(PHP_OS == "WINNT")
            $cmd .= "-aoa -o".$dest." ".$basepath."*"." 2>&1";
        else {
            $cmd .= "-aoa -o".escapeshellarg($dest)." ".escapeshellarg($basepath."*")." 2>&1";
            
            if ( $basepath=="*/" )
                $cmd .= " && chmod -R -- a+rX ".escapeshellarg($dest);
            else
                $cmd .= " && chmod -R -- a+rX ".escapeshellarg($dest.$basepath);
        }
        
        
        $last = exec( $cmd, $output, $code );
        
        Yii::trace( $cmd ."\n". print_r($output, true) );
        if ( $code!=0) {
            $this->error = $this->parseError( $code, $output, $ignoreEmpty );
			if ( $this->error!==null )
				return false; // cannot list the content
        }
        
        $out = array();
        foreach ($output as $line ) {
            if (preg_match("/Extracting\s+(.*)/u", $line, $matches) ){
                $out[] = $matches[1];
            }
        }
        
        return $out;
    }
    function extractFfileTo( $dest, $files ) {
        if(PHP_OS == "WINNT")
            self::$exe = '"C:\Program Files\7-Zip\7za"';
        $cmd = self::$exe." x ".$this->name." -aoa -o".$dest;
        
        foreach ($files as $file ) {
            if(PHP_OS == "WINNT")
                $cmd .= " ".$file;
            else
                $cmd .= " ".escapeshellarg($file);
        }
        $cmd .= " 2>&1";
        
        $last = exec( $cmd, $output, $code );
        Yii::trace( $cmd ."\n". print_r($output, true) );
        if ( $code!=0) {
            $this->error = $this->parseError( $code, $output );
            return false; // cannot list the content
        }
        
        $out = array();
        foreach ($output as $line ) {
            if (preg_match("/Extracting\s+(.*)/u", $line, $matches) ){
                $out[] = $matches[1];
            }
        }
        
        return $out;
    }
    function extractExtTo( $dest, $ext ) {
        if(PHP_OS == "WINNT")
            self::$exe = '"C:\Program Files\7-Zip\7za"';
        if ( is_array($ext) ) {
            $cmd = self::$exe." e ".$this->name." -xr!.SPXDAV -aoa -o".$dest." -r ";
            $found=false;
            foreach ($ext as $e){
                if ($e=='zip' || $e=='7z' || $e=='xml' )
                    continue;
                if ( $e=='png' )
                    $cmd.="*.png *.PNG -x!.preview.* -x!*.preview.* ";
                else
                    $cmd.="*.".$e." *.".strtoupper($e)." *.preview.*.$e.png ";
                $found=true;
            }
            $cmd.="2>&1";
            if ( !$found )
                return array();
        } else {
            if ($ext=='zip' || $ext=='7z' || $ext=='xml' )
                return array(); // we don't do zip files
            if ( $ext=='png' )
                $cmd = self::$exe." e ".$name." -o".$dest." -r *.png -x!.preview.* 2>&1";
            else
                $cmd = self::$exe." e ".$name." -o".$dest." -r *.".$ext." *.preview.*.$ext.png 2>&1";
        }        
        
        $last = exec( $cmd, $output, $code );
        Yii::trace( $cmd ."\n". print_r($output, true) );
        if ( $code!=0) {
            $this->error = $this->parseError( $code, $output );
            return false; // cannot list the content
        }
        $out = array();
        foreach ($output as $line ) {
            if (preg_match("/Extracting\s+(.*)/u", $line, $matches) ){
                if ( !preg_match("/\.preview/u", $matches[1] ) )
                    $out[] = FileItem::basenamepath( $matches[1], $path );
            }
        }
        
        return $out;
    }
    
    function createArchive( $infile, $paths, $base) {
        if(PHP_OS == "WINNT")
            self::$exe = '"C:\Program Files\7-Zip\7za"';
        
        $cp = 2;
        $name = $infile;
        while ( file_exists( $name ) ) {
            $name = substr($infile, 0, -3) ." (".($cp++).")" .substr($infile, -3);
        }
        $file = "'" . str_replace("'", "'\\''", $name) . "'" ;
        
        $cmd = "cd $base 2>&1 && ".self::$exe." a ".$file." -t7z -mx0 -mhc=off";
        foreach ($paths as $path ) {
            $cmd.=" ".$path;
        }
        $cmd.=" 2>&1";
        //file_put_contents("/var/log/fusion/debug.log", $cmd ."\n" );
        $last = exec( $cmd, $output, $code );
        Yii::trace( $cmd ."\n". print_r($output, true) );
        if ( $code!=0) {
            $this->error = Yii::t('app', 'Archive creation failed')." ($code)";
            return false; // cannot list the content
        }
        return true;
    }
 }